#!/sbin/sh
#
# DirectSD SD-EXT Mounter v1.0
# Author: tytung - xda-developers

if [ ! -d "/DirectSystem" ]; then
	mkdir "/DirectSystem"
fi

if [ ! -d "/DirectData" ]; then
	mkdir "/DirectData"
fi

if [ -f "/tmp/mount.prop" ]; then
	rm "/tmp/mount.prop"
fi

if [ -f "/tmp/fs.prop" ]; then
	rm "/tmp/fsdetect.prop"
fi

# Mount the SD-EXT partition
mounted=`mount | grep '/dev/block/mmcblk0p2 on /DirectData'`
if [ "$mounted" = "" ]; then
	 mount -t auto /dev/block/mmcblk0p2 /DirectData
fi

# Mount the SD-EXT partition
mounted=`mount | grep '/dev/block/mmcblk0p3 on /DirectSystem'`
if [ "$mounted" = "" ]; then
	 mount -t auto /dev/block/mmcblk0p3 /DirectSystem
fi

ext4data=`mount | grep '/dev/block/mmcblk0p2 on /DirectData type ext4'`
ext4system=`mount | grep '/dev/block/mmcblk0p3 on /DirectSystem type ext4'`
f2fsdata=`mount | grep '/dev/block/mmcblk0p2 on /DirectData type f2fs'`
f2fssystem=`mount | grep '/dev/block/mmcblk0p3 on /DirectSystem type f2fs'`

if [ "$ext4system" != "" ] && [ "$ext4data" != "" ]; then
	echo 'fs=ext4' > "/tmp/fsdetect.prop"
	echo 'status=mounted' > "/tmp/mount.prop"
fi

if [ "$f2fssystem" != "" ] && [ "$f2fsdata" != "" ]; then
	echo 'fs=f2fs' > "/tmp/fsdetect.prop"
	echo 'status=mounted' > "/tmp/mount.prop"
fi

exit 0
