#!/sbin/sh

# Get $ROM_NAME from ROM_NAME.prop
ROM_NAME=`cat '/tmp/aroma/ROM_NAME.prop' | sed 's/ROM_NAME=//g'`

# Mount the SD-EXT partition
# Done by DirectSD_mounter.sh
STATUS=`cat '/tmp/mount.prop' | sed 's/status=//g'`
if [ "$STATUS" = "mounted" ]; then

	mkdir -p /DirectSystem/$ROM_NAME/system
	mkdir -p /DirectData/$ROM_NAME/data

	mount --bind /DirectSystem/$ROM_NAME/system /system
	mount --bind /DirectData/$ROM_NAME/data   /data
	
	mkdir -p /sdcard/DirectSD/$ROM_NAME
	mkdir -p /boot
	mkdir -p /boot_dir

	mount --bind /sdcard/DirectSD/$ROM_NAME /boot
	mount --bind /sdcard/DirectSD           /boot_dir

	# delete the old system
	rm -rf /system/*

	echo "DirectSD=true" >> /tmp/nfo.prop

else

	# no SD-EXT partition found	
	echo "DirectSD=false" >> /tmp/nfo.prop

fi
