#!/sbin/sh

echo "bootloader=MAGLDR" > /tmp/aroma/device.prop

output=`grep -i "clk" /proc/cmdline`

if [ -n "$output" ]; then
	echo "bootloader=cLK" > /tmp/aroma/device.prop
fi

output=`grep -i "haret" /proc/cmdline`

if [ -n "$output" ]; then
	echo "bootloader=HaRet" > /tmp/aroma/device.prop
fi

# T-Mobile HD2 and EXT4 partition detection
# added by Daekin

index=`cat /tmp/aroma/data.prop | cut -d = -f2`

if [ "$index" == "3" ]; then
	blockname=mtdblock2
elif [ "$index" == "4" ]; then
	blockname=mtdblock3
elif [ "$index" == "5" ]; then
	blockname=mtdblock4
elif [ "$index" == "6" ]; then
	blockname=mtdblock5
elif [ "$index" == "7" ]; then
	blockname=mtdblock6
fi

mkdir /tmp/userdata
mount -t auto /dev/block/$blockname /tmp/userdata

output=`df | grep /tmp/userdata | cut -d " " -f 5`

umount /tmp/userdata
rmdir /tmp/userdata

if [ "$output" -gt "455680" ]; then
	echo "model=US" >> /tmp/aroma/device.prop
else
	echo "model=EU" >> /tmp/aroma/device.prop
fi

output=`ls /dev/block | grep -c mmcblk0p`

echo "partitions=$output" >> /tmp/aroma/device.prop
