#!/sbin/sh

# Unpack old kernel
dump_image boot /tmp/tools/old_boot.img
/tmp/tools/unpackbootimg /tmp/tools/old_boot.img /tmp/tools

kernel=/tmp/tools/zImage
base=0x11800000

# Build kernel image
/tmp/tools/mkbootimg --kernel $kernel \
                     --ramdisk /tmp/tools/old_boot.img-ramdisk.gz \
                     --cmdline "`cat /tmp/tools/old_boot.img-cmdline`" \
                     --base $base \
                     --output /tmp/tools/boot.img
# Flash new kernel
flash_image boot /tmp/tools/boot.img 

# Perform cleanup
rm /tmp/tools/old_boot.img*
rm $kernel
rm /tmp/tools/boot.img
