# Params:
#  minfreq=X => change min speed to given number
#  maxfreq=Y => change max speed to given number

/write.*scaling_governor/ { next; }

minfreq>0 && /write.*scaling_min_freq/ {
        found_minfreq=1;
        if ($0 ~ /^[ \t]*\#/) {
                print "    write /sys/devices/system/cpu/cpu0/cpufreq/scaling_min_freq", minfreq;
                next;
        }
        else sub($3,minfreq,$0);
}
maxfreq>0 && /write.*scaling_max_freq/ {
        found_maxfreq=1;
        if ($0 ~ /^[ \t]*\#/) {
                print "    write /sys/devices/system/cpu/cpu0/cpufreq/scaling_max_freq", maxfreq;
                next;
        }
        else sub($3,maxfreq,$0);
}
found_service==0 && $1=="service" {
        if (minfreq>0 && found_minfreq==0)
                print "    write /sys/devices/system/cpu/cpu0/cpufreq/scaling_min_freq", minfreq;
        if (maxfreq>0 && found_maxfreq==0)
                print "    write /sys/devices/system/cpu/cpu0/cpufreq/scaling_max_freq", maxfreq;
        found_service=1;
}

# keep rest of file as is:
{ print; }

