# Params:
#  nologo=1 => add no boot animation directives
#  logo=1   => remove no boot animation directives
#  noatime=1 => add noatime to all partition mounts
#  atime=1 => remove atime to all partition mounts

# remove scheduler tweaks to allow kernel default to take effect:
/sched_latency_ns/ { next; }
/sched_wakeup_granularity_ns/ { next; }
/sched_min_granularity_ns/ { next; }
/sched_compat_yield/ { next; }
/sched_child_runs_first/ { next; }
/sched_features/ { next; }

# mount all partition with noatime:
noatime==1 && $1 == "mount" && ! /noatime/ && ($NF == "remount" || $NF == "nodev") {
        print $0, "noatime";
        next;
}

# undo mount all partition with noatime:
atime==1 && $1 == "mount" && /noatime/ {
        sub(/ noatime/,"");
        print;
        next;
}

# handle logo/nologo flags:
(logo==1 || nologo==1) && /setprop ro.kernel.android.bootanim/ {
        if (found_bootanim==1 || logo==1) {
                if ($0 ~ /^[ \t]*\#/)
                        print $0;
                else
                        print "#" $0;
        }
        else if (nologo == 1)
                print "    setprop ro.kernel.android.bootanim 0";
        else print $0; # shouldn't get here but just in case.
        found_bootanim=1;
        next;
}
(logo==1 || nologo==1) && /setprop debug.sf.nobootanimation/ {
        if (found_nobootanim==1 || logo == 1) {
                if ($0 ~ /^[ \t]*\#/)
                        print $0;
                else
                        print "#" $0;
        }
        else if (nologo == 1)
                print "    setprop debug.sf.nobootanimation 1";
        else print $0; # shouldn't get here but just in case.
        found_nobootanim=1;
        next;
}
nologo==1 && /^on boot/ {
        if (found_bootanim==0)
                print "    setprop ro.kernel.android.bootanim 0";
        if (found_nobootanim==0)
                print "    setprop debug.sf.nobootanimation 1";
        nologo=0; # prevent another addition
}

# keep rest of file as is:
{ print; }
