#!/system/bin/sh
#
# Default network type switcher
#
# 0 => WCDMA preferred, switch to GSM when WCDMA can't be used.
# 1 => GSM Only.
# 3 => GSM/WCMDA autoswitching to strongest signal
# 4 => CDMA / EVDO.

if [ $1 -ge 0 -a $1 -le 4 ]
then
	rwsystem
	# Save old setting
	oldline=`cat /system/build.prop | grep ro.telephony.default_network`
	# Remove old ro.telephony.default_network line
	mv /system/build.prop /system/build.old
	cat /system/build.old | grep -v ro.telephony.default_network > /system/build.prop
	# Add new line
	echo "ro.telephony.default_network=$1" >> /system/build.prop
	rosystem
	#
	newline=`cat /system/build.prop | grep ro.telephony.default_network`
	echo "Old setting: $oldline"
	echo "New setting: $newline"
else
	echo "Usage: default_network.sh <num>"
	echo "0 => WCDMA preferred"
	echo "1 => GSM Only"
	echo "2 => ??????"
	echo "3 => GSM/WCMDA autoswitching to strongest signal"
	echo "4 => CDMA / EVDO"
fi

