#!/system/bin/sh
#
# ro.sf.lcd_density switcher
#


if [ $1 -ge 80 -a $1 -le 240 ]
then
	rwsystem
	# Save old setting
	oldline=`cat /system/build.prop | grep ro.sf.lcd_density`
	# Remove old ro.sf.lcd_density line
	mv /system/build.prop /system/build.old
	cat /system/build.old | grep -v ro.sf.lcd_density > /system/build.prop
	# Add new line
	echo "ro.sf.lcd_density=$1" >> /system/build.prop
	rosystem
	#
	newline=`cat /system/build.prop | grep ro.sf.lcd_density`
	echo "Old setting: $oldline"
	echo "New setting: $newline"
else
	echo "Usage: lcd_density.sh <num>"
	echo "120 => default for 240x320 (QVGA)"
	echo "144 => recommended for 320x428"
	echo "160 => default for 320x480 (HVGA)"
	echo "240 => default for 480x800"
fi

