#!/system/bin/sh
#
# Market switcher / Paid apps enabler
#

# Save original fingerprint on first run
if [ ! -f /system/froyo_fingerprint ]
then
	rwsystem
	cat /system/build.prop | grep "ro.build.description=" > /system/froyo_fingerprint
	cat /system/build.prop | grep "ro.build.fingerprint=" >> /system/froyo_fingerprint
	echo "Saved original fingerprint in /system/froyo_fingerprint"
	rosystem
fi

case "$1" in
   eclair)
   		rwsystem
		# Remove fingerprint
   		cat /system/build.prop | grep -v "ro.build.description=" | grep -v "ro.build.fingerprint=" > /system/build.tmp
   		mv /system/build.tmp /system/build.prop
		# Add new lines
		echo "ro.build.description=passion-user 2.1-update1 ERE27 24178 release-keys" >> /system/build.prop
		echo "ro.build.fingerprint=google/passion/passion/mahimahi:2.1-update1/ERE27/24178:user/release-keys" >> /system/build.prop
		rosystem
		echo "Market switched to Eclair. Restart phone!"
   ;;

   froyo)
   		rwsystem
		# Remove fingerprint
   		cat /system/build.prop | grep -v "ro.build.description=" | grep -v "ro.build.fingerprint=" > /system/build.tmp
   		mv /system/build.tmp /system/build.prop
		# Restore original market
		cat /system/froyo_fingerprint >> /system/build.prop
		rosystem
		echo "Market switched to Froyo. Restart phone!"
   ;;

   paid)
		while true ; do
			echo "Setting properties to enable paid apps in market."
			setprop gsm.sim.operator.numeric 310260
			setprop gsm.operator.numeric 310260
			setprop gsm.sim.operator.iso-country us
			setprop gsm.operator.iso-country us
			sleep 210
		done
   ;;

   *)
      echo "Usage: $0 {eclair|froyo|paid}"
      exit 1
esac

exit 0