
#
# system/app odex-er by Paul O'Brien @ www.MoDaCo.com
#
# experimental - nandroid backup before you run this script!
#
# version 0.1, 29th January 2010
# updated by Martin Johnson, M.J.Johnson @ massey.ac.nz June 2010 for Vogue

# set permissions
chmod 4755 /data/odex/dexopt-wrapper
chmod 4755 /data/odex/zip
chmod 4755 /data/odex/zipalign

# mount system as rw
mount -o remount,rw /system

# change to system/app and process each apk!

cd /system/framework
rm /tmp.odex
for filename in core.jar ext.jar framework.jar android.policy.jar services.jar *.jar
do
	name=`basename $filename .jar`
	if [ ! -f $name.odex ]
	then 
		/data/odex/dexopt-wrapper $filename /tmp.odex
		if [ $? -eq 0 ]
		then
			/data/odex/zip -d $filename classes.dex
			mv /tmp.odex $name.odex
		else
			rm /tmp.odex
		fi
	fi
done

cd /system/app

for filename in *.apk
do
	name=`basename $filename .apk`
	if [ ! -f $name.odex ]
        then
		# step 1 - odex the apk
		/data/odex/dexopt-wrapper $filename /tmp.odex

		# step 2 - did we succesfully odex?
		if [ $? -eq 0 ]
		then
			# step 3 - remove the classes.dex from the apk
			/data/odex/zip -d $filename classes.dex
			# step 4 - zipalign, just in case
			/data/odex/zipalign -f -v 4 $filename /$filename.new
			mv /$filename.new $filename
			mv /tmp.odex $name.odex
		fi
	fi

done;

# clear dalvik cache
rm -r /data/dalvik-cache/*

# reboot
