#!/system/bin/sh
#
# Compcache manager
#

#
# Change these variables to tweak the compcache
#
opts='disksize_kb=26010'	# Use 25% of the avaliable RAM (leaving it blank doesn't seem to work with 2.6.32.9 kernel and compcache 0.6.2)
#opts='disksize_kb=16384'	# 16Mb compcache
#opts='disksize_kb=32768'	# 32Mb compcache
#opts='backing_swap=/dev/block/mmcblk0p4'						# compcache (default size 15% of available RAM) + backing swap (on SD card)
#opts='backing_swap=/dev/block/mmcblk0p4 memlimit_kb=32768'		# 32Mb compcache + backing swap (on SD card)

# Swappiness
swappy=30

case "$1" in
   start)
	  sleep 120
      	  insmod /system/lib/modules/lzo_compress.ko
	  insmod /system/lib/modules/lzo_decompress.ko
  	  insmod /system/lib/modules/ramzswap.ko $opts
	  swapon /dev/block/ramzswap0
	  sysctl -w vm.swappiness=$swappy
   ;;

   stop)
      swapoff /dev/block/ramzswap0
   ;;

   enable)
      setprop persist.service.compcache 1
      echo "Compcache will be enabled in 120 seconds."
   ;;

   disable)
      setprop persist.service.compcache 0
   ;;

   *)
      echo "Usage: $0 {start|stop}"
      exit 1
esac

exit 0
