#!/system/bin/sh
#
# Default network type switcher
#
# 0 => WCDMA preferred, switch to GSM when WCDMA can't be used.
# 1 => GSM Only.
# 2 => WCDMA Only.

if [ -e /sys/class/vogue_hw/gsmphone ]
then
	if [ $1 -ge 0 -a $1 -le 2 ]
	then
		rwsystem
		# Remove old ro.telephony.default_network line
		mv /system/build.prop /system/build.old
		cat /system/build.old | grep -v ro.telephony.default_network > /system/build.prop
		# Add new line
		echo "ro.telephony.default_network=$1" >> /system/build.prop
		rosystem
		# Activate new settings
   		echo -e "AT+BANDSET=0\r" > /dev/smd0
		echo -e "AT+CGAATT=2,1,$1\r" > /dev/smd0
   		echo -e "AT+COPS=0\r" > /dev/smd0
   		echo "Default network set to: $1"
	else
		echo "Usage: default_network.sh <num>"
		echo "0 => Dual mode, WCDMA preferred"
		echo "1 => GSM Only"
		echo "2 => WCDMA only"
	fi
else
	echo "This is not a GSM phone, ignoring attempt to change default network."
	exit 1
fi
