#!/system/bin/sh
#
# system/app odex-er by Paul O'Brien @ www.MoDaCo.com
#
# experimental - nandroid backup before you run this script!
#
# version 0.1, 29th January 2010
# updated by Martin Johnson, M.J.Johnson @ massey.ac.nz June 2010 for Vogue

rm /tmp.odex

cd /data/devapp
for filename in *.apk
do
	name=`basename $filename .apk`
	if [ ! -f $name.odex ]
        then
		# step 1 - odex the apk
		/system/bin/dexopt-wrapper $filename /tmp.odex

		# step 2 - did we succesfully odex?
		if [ $? -eq 0 ]
		then
			# step 3 - remove the classes.dex from the apk
			/system/bin/zip -d $filename classes.dex
			# step 4 - zipalign, just in case
			/system/bin/zipalign -f -v 4 $filename /$filename.new
			mv /$filename.new $filename
			mv /tmp.odex $name.odex
		fi
	fi
done;


