#!/system/bin/sh
#
# ro.ril.gprsclass switcher
#
#    * Class 2 : 3 slots : 8  12 kbps upload / 16  24 kbps download
#    * Class 4 : 4 slots : 8  12 kbps upload / 24  36 kbps download
#    * Class 6 : 4 slots : 24  36 kbps upload / 24  36 kbps download
#    * Class 8 : 5 slots : 8  12 kbps upload / 32  40 kbps download
#    * Class 10 : 5 slots : 16  24 kbps upload / 32  48 kbps download
#    * Class 12 : 5 slots : 32  48 kbps upload / 32  48 kbps download

if [ $1 -ge 2 -a $1 -le 12 ]
then
	rwsystem
	# Save old setting
	oldline=`cat /system/build.prop | grep ro.ril.gprsclass`
	# Remove old ro.ril.gprsclass line
	mv /system/build.prop /system/build.old
	cat /system/build.old | grep -v ro.ril.gprsclass > /system/build.prop
	# Add new line
	echo "ro.ril.gprsclass=$1" >> /system/build.prop
	rosystem
	#
	newline=`cat /system/build.prop | grep ro.ril.gprsclass`
	echo "Old setting: $oldline"
	echo "New setting: $newline"
else
	echo "Usage: gprsclass.sh <num>"
	echo "2  => Class 2 : 3 slots : 8  12 kbps upload / 16  24 kbps download"
	echo "4  => Class 4 : 4 slots : 8  12 kbps upload / 24  36 kbps download"
	echo "6  => Class 6 : 4 slots : 24  36 kbps upload / 24  36 kbps download"
	echo "8  => Class 8 : 5 slots : 8  12 kbps upload / 32  40 kbps download"
	echo "10 => Class 10 : 5 slots : 16  24 kbps upload / 32  48 kbps download"
	echo "12 => Class 12 : 5 slots : 32  48 kbps upload / 32  48 kbps download"
fi

