#!/system/bin/sh
#
# system/app odex-er by Paul O'Brien @ www.MoDaCo.com
#
# experimental - nandroid backup before you run this script!
#
# version 0.1, 29th January 2010
# updated by Martin Johnson, M.J.Johnson @ massey.ac.nz June 2010 for Vogue
#

rm /tmp.odex
cd /data/app

# Check for and delete leftover .odex files after uninstalled apps
for filename in *.odex
do
	name=`basename $filename .odex`
	if [ ! -f $name.apk -a -f $filename ]
	then
		rm $filename
		echo "Removed $filename"
	fi
done;

# Loop through all installed apps
for filename in *.apk
do
	name=`basename $filename .apk`
	if [ ! -f $name.odex -o $filename -nt $name.odex ]
        then
		# step 1 - odex the apk
		rm -f /tmp.odex
		/system/bin/dexopt-wrapper $filename /tmp.odex

		# step 2 - did we succesfully odex?
		if [ $? -eq 0 ]
		then
			# step 3 - remove the classes.dex from the apk
			/system/bin/zip -d $filename classes.dex

			# continue only if classes.dex was present
			if [ $? -eq 0 ]
			then
				# step 4 - zipalign, just in case
				/system/bin/zipalign -f -v 4 $filename /$filename.new
				mv -f /$filename.new $filename
				mv -f /tmp.odex $name.odex
				touch $name.odex
				echo "Odexed $filename"
			else
				echo "Error $filename did not contain classes.dex"
			fi
		else
			echo "Error creating odex from $filename"
		fi
	else
		echo "Nothing to do: $filename"
	fi
done;

# clear dalvik cache
rm -r /data/dalvik-cache/*