#!/system/bin/sh
#
# Script for relocating /data/app to a loopback ext2 filesystem on /sdcard/andboot/apps.img
#

fail() {
	echo "Failed"
	echo "$1"
	exit 1
}

case "$1" in
   create)
   	# Make sure we do not have an image allready
	if [ -f /sdcard/andboot/apps.img ]
	then
		fail "/sdcard/andboot/apps.img allready exists."
	fi

	# Create empty block file and format it to ext2
	echo "- Creating empty /sdcard/andboot/apps.img ($2Mb)"
	dd if=/dev/zero of=/sdcard/andboot/apps.img bs=1048576 count=$2
	[ $? -eq 0 ] || fail "Failed to format"
	echo "- Formatting /sdcard/andboot/apps.img"
	/bin/mke2fs -F /sdcard/andboot/apps.img
	[ $? -eq 0 ] || fail "Failed to format"

	# Mount the new block device
	echo "- Mounting /sdcard/andboot/apps.img on /mnt"
	losetup /dev/block/loop2 /sdcard/andboot/apps.img
	[ $? -eq 0 ] || fail "Failed to mount"
	mkdir /mnt
	mount -t ext2 -o noatime,nodiratime /dev/block/loop2 /mnt
	[ $? -eq 0 ] || fail "Failed to mount"

	# Relocate the apps and mark the contents of the old folders for deletion on the next boot
	echo "- Copying /data/app/*"
	chown 1000.1000 /mnt
	chmod 771 /mnt
	cp -rp /data/app/* /mnt
	touch /data/app/delete_contents
	umount /mnt

	# Mount the relocated folders
	echo "- Switching to relocated apps"
	mount -t ext2  -o noatime,nodiratime /dev/block/loop2 /data/app
	[ $? -eq 0 ] || fail "Failed to mount"
	chown 1000.1000 /data/app
	chmod 771 /data/app

	# Done!
	echo " - Done. /data/app will be cleared on next reboot."
   ;;

   *)
      echo "Usage: $0 create [size]M"
      exit 1
esac
