/*
 * Decompiled with CFR 0.152.
 */
package com.sonyericsson.kx.widget;

import com.sonyericsson.kx.DynamicItem;
import com.sonyericsson.kx.TimeStamp;
import com.sonyericsson.kx.widget.ItemHolder;
import com.sonyericsson.res.Images;
import javax.microedition.lcdui.Font;
import javax.microedition.lcdui.Graphics;
import javax.microedition.lcdui.Image;

public class KxItemPresenter {
    private static final String MSG_PRE = "\u60a8\u6709";
    private static final int FONT_COLOR = 0;
    private static final int FONT_COLOR_BLEND = 0x555555;
    private static final int SPRITES_COLUMS = 13;
    private static final int MARK_Y_OFFSET = 3;
    private static final int MARK_X_OFFSET = 105;
    private static final int LB = 36;
    private static final int LT = 20;
    public static final int HIDDEN = 0;
    public static final int FOCUSED = 1;
    public static final int UNFOCUSED = 2;
    public static final int MAX_STEPS = 10;
    public static final int HEIGHT_BG = 55;
    public static final int WIDTH_BG = 210;
    public static final int Y_INCREASE_1ST = 5;
    public static final int H_ADD_INTERACTIVE = 50;
    public static final int MARGIN_LEFT_2ND = 10;
    public static final int H_SHOW_2ND = 35;
    public static final int H_HIDE_2ND = 20;
    public static final int X_INCREASE_2ND = 1;
    public static final int Y_INCREASE_2ND = 3;
    public static final int WIDTH_2ND = 190;
    public static final int HEIGHT_2ND = 49;
    public static final int MARGIN_LEFT_3RD = 18;
    public static final int H_SHOW_3RD = 25;
    public static final int H_HIDE_3RD = 30;
    public static final int X_INCREASE_3RD = 1;
    public static final int Y_INCREASE_3RD = 2;
    public static final int WIDTH_3RD = 174;
    public static final int HEIGHT_3RD = 45;
    public static final int MARGIN_LEFT_4TH = 24;
    public static final int H_SHOW_4TH = 15;
    public static final int H_HIDE_4TH = 40;
    public static final int X_INCREASE_4TH = 1;
    public static final int Y_INCREASE_4TH = 1;
    public static final int WIDTH_4TH = 162;
    public static final int HEIGHT_4TH = 45;
    private static final int SPRITE_WIDTH = 15;
    public static final Font TEXT_FONT = Font.getFont((int)0, (int)0, (int)8);
    public int width;
    public int height;
    private ItemHolder holder;
    public boolean focused;

    public KxItemPresenter(ItemHolder holder) {
        this.holder = holder;
    }

    public void draw(Graphics g, int x, int y, DynamicItem item, boolean focused) {
        boolean isBlend = false;
        this.focused = focused;
        if (focused) {
            if (this.holder.mode == 2) {
                g.drawImage(Images.ITEM_BG_FOCUSED, x, y, 36);
            } else {
                g.drawImage(Images.ITEM_BG, x, y, 36);
            }
        } else if (this.holder.mode == 0) {
            isBlend = true;
            if (item.type == 3) {
                g.drawImage(Images.MYSTATUS_BG_BLEND, x, y, 36);
            } else {
                g.drawImage(Images.ITEM_BG_BLEND, x, y, 36);
            }
        } else if (item.type == 3) {
            g.drawImage(Images.MYSTATUS_BG, x, y, 36);
        } else {
            g.drawImage(Images.ITEM_BG, x, y, 36);
        }
        if (this.holder == null || item == null) {
            return;
        }
        if (item.img != null) {
            if (isBlend) {
                this.drawImage(g, x, y, item.imgBlend);
            } else {
                this.drawImage(g, x, y, item.img);
            }
        } else if (isBlend) {
            this.drawImage(g, x, y, Images.DEFAULT_BLEND);
        } else {
            this.drawImage(g, x, y, Images.DEFAULT);
        }
        if (!isBlend) {
            g.setColor(0xFFFFFF);
            g.drawRect(x + 1, y - 54, 51, 51);
        }
        g.setFont(TEXT_FONT);
        g.setColor(749610);
        int firstLine = this.get1stLine(y);
        if (item.fname != null) {
            if (item.fname.length() > 3) {
                g.drawSubstring(item.fname, 0, 3, x + 55, firstLine, 36);
            } else {
                g.drawString(item.fname, x + 55, firstLine, 36);
            }
        }
        switch (item.type) {
            case 1: {
                this.drawBirthday(g, x, y, item, isBlend);
                break;
            }
            case 2: {
                this.drawStatus(g, x, y, item, isBlend);
                break;
            }
            case 3: {
                this.drawStatus(g, x, y, item, isBlend);
                break;
            }
            case 4: {
                this.drawMessage(g, x, y, item, isBlend);
                break;
            }
        }
    }

    private void drawMessage(Graphics g, int x, int y, DynamicItem item, boolean isBlend) {
        int firstLine = this.get1stLine(y);
        if (isBlend) {
            g.drawImage(Images.MSG_BLEND, x + 105, firstLine - 3, 36);
        } else {
            g.drawImage(Images.MSG, x + 105, firstLine - 3, 36);
        }
        this.setTextColor(g, isBlend);
        g.drawString("\u6536\u5230\u65b0\u6d88\u606f", x + 120, firstLine, 36);
        int secondLine = y - 5;
        this.setTextColor(g, isBlend);
        g.drawString(MSG_PRE, x + 55, secondLine, 36);
        int stringWidth = TEXT_FONT.stringWidth(MSG_PRE);
        g.drawString(item.strMessage, x + 55 + stringWidth, secondLine, 36);
        int countWidth = TEXT_FONT.stringWidth(item.strMessage);
        g.drawString("\u6761\u672a\u8bfb\u6d88\u606f", x + 55 + stringWidth + countWidth, secondLine, 36);
    }

    private void setTextColor(Graphics g, boolean isBlend) {
        if (isBlend) {
            g.setColor(0x555555);
        } else {
            g.setColor(0);
        }
    }

    private void drawBirthday(Graphics g, int x, int y, DynamicItem item, boolean isBlend) {
        int firstLine = this.get1stLine(y);
        if (isBlend) {
            g.drawImage(Images.CAKE_BLEND, x + 105, firstLine - 3, 36);
        } else {
            g.drawImage(Images.CAKE, x + 105, firstLine - 3, 36);
        }
        this.setTextColor(g, isBlend);
        g.drawString("\u751f\u65e5\u63d0\u9192", x + 120, firstLine, 36);
        int secondLine = y - 5;
        g.setColor(0x8F8F8F);
        TimeStamp t = new TimeStamp(item.ctime);
        g.drawString(t.toString(), x + 165, secondLine, 36);
        this.setTextColor(g, isBlend);
        g.clipRect(x + 55, secondLine - 20, 105, 20);
        if (this.focused) {
            g.drawString(item.strMessage, x + 55 + this.holder.xTextOffset, secondLine, 36);
        } else {
            g.drawString(item.strMessage, x + 55, secondLine, 36);
        }
    }

    private void drawImage(Graphics g, int x, int y, Image img) {
        if (img != null) {
            int height = img.getHeight() < 50 ? img.getHeight() : 50;
            int width = img.getWidth() < 50 ? img.getWidth() : 50;
            g.drawRegion(img, 0, 0, width, height, 0, x + 2, y + 3 - 55, 20);
        }
    }

    private void drawStatus(Graphics g, int x, int y, DynamicItem item, boolean isBlend) {
        int firstLine = this.get1stLine(y);
        this.drawIcon(item, g, x, firstLine, isBlend);
        g.setColor(0x8F8F8F);
        TimeStamp t = new TimeStamp(item.ctime);
        int secondLine = y - 5;
        g.drawString(t.toString(), x + 165, secondLine, 36);
        if (item.strMessage != null) {
            this.setTextColor(g, isBlend);
            if (item.strMessage.length() > 6) {
                g.drawSubstring(item.strMessage, 0, 5, x + 120, firstLine, 36);
                g.clipRect(x + 55, secondLine - 20, 105, 20);
                if (item.sprites == null) {
                    if (this.focused) {
                        g.drawSubstring(item.strMessage, 5, item.strMessage.length() - 5, x + 55 + this.holder.xTextOffset, secondLine, 36);
                    } else {
                        g.drawSubstring(item.strMessage, 5, item.strMessage.length() - 5, x + 55, secondLine, 36);
                    }
                } else {
                    this.drawScript(item, g, x + 55, secondLine, isBlend);
                }
            } else {
                g.drawString(item.strMessage, x + 120, firstLine, 36);
            }
        }
    }

    private void drawIcon(DynamicItem item, Graphics g, int x, int firstLine, boolean isBlend) {
        switch (item.nStatusType) {
            case 1: {
                if (isBlend) {
                    g.drawImage(Images.PHOTO_BLEND, x + 105, firstLine - 3, 36);
                    break;
                }
                g.drawImage(Images.PHOTO, x + 105, firstLine - 3, 36);
                break;
            }
            case 2: {
                if (isBlend) {
                    g.drawImage(Images.DIARY_BLEND, x + 105, firstLine - 3, 36);
                    break;
                }
                g.drawImage(Images.DIARY, x + 105, firstLine - 3, 36);
                break;
            }
            case 1018: {
                if (isBlend) {
                    g.drawImage(Images.RECORD_BLEND, x + 105, firstLine - 3, 36);
                    break;
                }
                g.drawImage(Images.RECORD, x + 105, firstLine - 3, 36);
                break;
            }
            default: {
                if (isBlend) {
                    g.drawImage(Images.STATUS_BLEND, x + 105, firstLine - 3, 36);
                    break;
                }
                g.drawImage(Images.STATUS, x + 105, firstLine - 3, 36);
            }
        }
    }

    private int get1stLine(int y) {
        return y - 30;
    }

    private void drawScript(DynamicItem item, Graphics g, int x, int y, boolean isBlend) {
        if (this.focused) {
            x += this.holder.xTextOffset;
        }
        int[][] s = item.sprites;
        int textWidth = 0;
        int j = 6;
        Font font = TEXT_FONT;
        g.setFont(font);
        int i = 0;
        while (i < item.sprites.length) {
            g.drawSubstring(item.strMessage, j, s[i][0] - j, x, y, 36);
            textWidth = font.substringWidth(item.strMessage, j, s[i][0] - j);
            x += textWidth;
            j = s[i][0] + s[i][1];
            int iSprite = s[i][2];
            int ySprite = 0;
            int xSprite = iSprite % 13;
            ySprite = iSprite == 0 ? 0 : iSprite / 13;
            Image sprite = null;
            sprite = isBlend ? item.spriteBlend : item.sprite;
            g.drawRegion(sprite, 15 * xSprite, 15 * ySprite, 15, 15, 0, x, y, 36);
            x += 15;
            ++i;
        }
        g.drawSubstring(item.strMessage, j, item.strMessage.length() - j, x, y, 36);
    }
}

