/*
 * Decompiled with CFR 0.152.
 */
package com.sonyericsson.kx;

import com.nokia.mid.ui.DirectGraphics;
import com.nokia.mid.ui.DirectUtils;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.DataInputStream;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Calendar;
import java.util.Date;
import java.util.Enumeration;
import java.util.TimeZone;
import javax.microedition.amms.GlobalManager;
import javax.microedition.amms.MediaProcessor;
import javax.microedition.amms.control.ImageFormatControl;
import javax.microedition.amms.control.imageeffect.ImageEffectControl;
import javax.microedition.amms.control.imageeffect.ImageTransformControl;
import javax.microedition.io.PushRegistry;
import javax.microedition.lcdui.Graphics;
import javax.microedition.lcdui.Image;
import javax.microedition.midlet.MIDlet;
import javax.microedition.pim.Event;
import javax.microedition.pim.EventList;
import javax.microedition.pim.PIM;
import javax.microedition.pim.PIMException;

public class Utility {
    private static Image background = null;

    public static Calendar getTime(String ctime) {
        Calendar time = Calendar.getInstance();
        TimeZone tz = time.getTimeZone();
        time.setTime(new Date(Long.parseLong(ctime) * 1000L));
        return time;
    }

    public static Image getImage(Image icon) {
        Image img;
        if (background == null) {
            try {
                background = DirectUtils.createImage((int)70, (int)90, (int)0xFFFFFF);
                img = Image.createImage((String)"/iconback.png");
                background.getGraphics().drawImage(img, 0, 0, 0);
            }
            catch (Exception img2) {
                // empty catch block
            }
        }
        try {
            img = DirectUtils.createImage((int)70, (int)90, (int)0xFFFFFF);
            img.getGraphics().drawImage(Utility.scaleImage(icon, 53, 53), 8, 7, 0);
            img.getGraphics().drawImage(background, 0, 0, 0);
            return img;
        }
        catch (Exception e) {
            return null;
        }
    }

    public static Image scaleImage(Image original, int newWidth, int newHeight) {
        int width = original.getWidth();
        int height = original.getHeight();
        if (height == newHeight && width == newWidth) {
            return original;
        }
        int[] rawInput = new int[height * width];
        DirectGraphics dg = null;
        try {
            if (original.isMutable()) {
                dg = DirectUtils.getDirectGraphics((Graphics)original.getGraphics());
            } else {
                Image tmp = DirectUtils.createImage((int)width, (int)height, (int)0);
                tmp.getGraphics().drawImage(original, 0, 0, 0);
                dg = DirectUtils.getDirectGraphics((Graphics)tmp.getGraphics());
            }
        }
        catch (Exception e) {
            System.out.println(e.toString());
            return null;
        }
        int format = dg.getNativePixelFormat();
        dg.getPixels(rawInput, 0, width, 0, 0, width, height, 8888);
        int[] rawOutput = new int[newWidth * newHeight];
        int YD = height / newHeight * width - width;
        int YR = height % newHeight;
        int XD = width / newWidth;
        int XR = width % newWidth;
        int outOffset = 0;
        int inOffset = 0;
        int y = newHeight;
        int YE = 0;
        while (y > 0) {
            int x = newWidth;
            int XE = 0;
            while (x > 0) {
                rawOutput[outOffset++] = rawInput[inOffset];
                inOffset += XD;
                if ((XE += XR) >= newWidth) {
                    XE -= newWidth;
                    ++inOffset;
                }
                --x;
            }
            inOffset += YD;
            if ((YE += YR) >= newHeight) {
                YE -= newHeight;
                inOffset += width;
            }
            --y;
        }
        Image img = DirectUtils.createImage((int)newWidth, (int)newHeight, (int)0);
        dg = DirectUtils.getDirectGraphics((Graphics)img.getGraphics());
        dg.drawPixels(rawOutput, true, 0, newWidth, 0, 0, newWidth, newHeight, 0, 8888);
        rawOutput = null;
        rawInput = null;
        return img;
    }

    public static boolean isAppAutoStart() {
        String[] conns = PushRegistry.listConnections((boolean)true);
        if (conns != null && conns.length > 0) {
            System.out.println("Auto app Start!" + conns[0]);
            return true;
        }
        System.out.println("Manual app Start!");
        return false;
    }

    public static String getMobileID() {
        String str = System.getProperty("com.sonyericsson.sim.subscribernumber");
        if (str == null) {
            return "";
        }
        return str;
    }

    public static String getVersion(MIDlet midlet) {
        return midlet.getAppProperty("MIDlet-Version");
    }

    public static String getType(boolean bHomeScreen) {
        if (bHomeScreen) {
            return "HSapp";
        }
        return "MAINapp";
    }

    public static String getJavaPlatform() {
        String str = System.getProperty("com.sonyericsson.java.platform");
        if (str == null) {
            return "JP-8.4.2";
        }
        return str;
    }

    public static String getModel() {
        String str = System.getProperty("microedition.platform");
        if (str == null) {
            return "Norika";
        }
        int nPos = str.indexOf("/");
        if (nPos > 0) {
            return str.substring(0, nPos);
        }
        return "Norika";
    }

    public static String getOpt(MIDlet midlet) {
        return midlet.getAppProperty("KX-Opt");
    }

    public static boolean isFlightMode() {
        return System.getProperty("com.sonyericsson.net.rat") == null;
    }

    public static boolean isMobileRoaming() {
        String cmcc = System.getProperty("com.sonyericsson.net.cmcc");
        String mcc = System.getProperty("com.sonyericsson.net.mcc");
        if (mcc == null) {
            return false;
        }
        return !mcc.equals(cmcc);
    }

    public static Image scaleSNSTransIcon(Image in, int nWidth, int nFlipHeight) {
        Image out = null;
        try {
            int[] rawInt = new int[in.getWidth() * in.getHeight()];
            in.getRGB(rawInt, 0, in.getWidth(), 0, 0, in.getWidth(), in.getHeight());
            Utility.blendIcon(rawInt, nWidth, nFlipHeight);
            out = Image.createRGBImage((int[])rawInt, (int)in.getWidth(), (int)in.getHeight(), (boolean)true);
        }
        catch (Exception e) {
            out = null;
            e.printStackTrace();
        }
        return out;
    }

    public static Image scaleSNSIconA(Image in) {
        Image out = null;
        try {
            out = Image.createImage((int)32, (int)45);
            Image temp = Utility.scaleImage(in, 32, 32, false);
            out.getGraphics().drawImage(temp, 0, 0, 0);
            temp = Utility.flipImage(temp);
            out.getGraphics().drawImage(temp, 0, 34, 0);
        }
        catch (Exception e) {
            out = null;
            e.printStackTrace();
        }
        return out;
    }

    public static Image scaleSNSIconA(Image in, int nWidth, int nFlipHeigth) {
        Image out = null;
        try {
            out = Image.createImage((int)nWidth, (int)(in.getHeight() + 1 + nFlipHeigth));
            Image temp = Utility.scaleImage(in, nWidth, nWidth, false);
            out.getGraphics().drawImage(temp, 0, 0, 0);
            temp = Utility.flipImage(temp);
            out.getGraphics().drawImage(temp, 0, nWidth + 1, 0);
        }
        catch (Exception e) {
            out = null;
            e.printStackTrace();
        }
        return out;
    }

    public static void blendIcon(int[] raw, int nWidth, int nFlipHeight) {
        int len = raw.length;
        int nHeight = len / nWidth;
        int alphaValue = 0x64000000;
        int i = 0;
        while (i < nHeight) {
            int nStart = i * nWidth;
            if (i > nWidth + 1) {
                alphaValue -= 100 / nFlipHeight << 24;
            }
            int j = 0;
            while (j < nWidth) {
                int color = raw[nStart + j] & 0xFFFFFF;
                raw[nStart + j] = color += alphaValue;
                ++j;
            }
            ++i;
        }
    }

    public static Image makeMonoImage(Image in) {
        Image out = null;
        if (in == null) {
            System.out.println("null input image");
            return null;
        }
        try {
            MediaProcessor processor = GlobalManager.createMediaProcessor((String)"image/raw");
            processor.setInput((Object)in);
            ByteArrayOutputStream os = new ByteArrayOutputStream();
            processor.setOutput((OutputStream)os);
            ImageEffectControl imageEffect = (ImageEffectControl)processor.getControl("javax.microedition.amms.control.imageeffect.ImageEffectControl");
            if (imageEffect != null) {
                imageEffect.setPreset("monochrome");
            }
            imageEffect.setEnabled(true);
            ImageFormatControl format = (ImageFormatControl)processor.getControl("javax.microedition.amms.control.ImageFormatControl");
            format.setFormat("image/jpeg");
            format.setParameter("quality", 75);
            processor.complete();
            ByteArrayInputStream bais = new ByteArrayInputStream(os.toByteArray());
            out = Image.createImage((InputStream)bais);
            return out;
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    public static Image blendImage(Image image) {
        try {
            int[] rawInt = new int[image.getWidth() * image.getHeight()];
            image.getRGB(rawInt, 0, image.getWidth(), 0, 0, image.getWidth(), image.getHeight());
            Utility.blendIcon(rawInt, image.getWidth(), image.getHeight() - image.getWidth());
            Image out = Image.createRGBImage((int[])rawInt, (int)image.getWidth(), (int)image.getHeight(), (boolean)true);
            rawInt = null;
            return out;
        }
        catch (Exception e) {
            return null;
        }
    }

    public static Image blurImage(Image image, boolean blurAll) {
        try {
            int nWidth = image.getWidth();
            int nHeight = image.getHeight();
            int[] rawInt = new int[nWidth * nHeight];
            image.getRGB(rawInt, 0, nWidth, 0, 0, nWidth, nHeight);
            int alphaValue = -1442840576;
            int i = 0;
            while (i < nHeight) {
                int nStart = i * nWidth;
                if (i < nWidth && !blurAll) {
                    alphaValue = -16777216;
                } else {
                    if (i == nWidth) {
                        alphaValue = -1442840576;
                    }
                    if (i > nWidth) {
                        alphaValue -= 170 / (nHeight - nWidth - 1) << 24;
                    }
                }
                int j = 0;
                while (j < nWidth) {
                    int color = rawInt[nStart + j] & 0xFFFFFF;
                    rawInt[nStart + j] = color |= alphaValue;
                    ++j;
                }
                ++i;
            }
            Image out = Image.createRGBImage((int[])rawInt, (int)nWidth, (int)nHeight, (boolean)true);
            rawInt = null;
            return out;
        }
        catch (Exception e) {
            return null;
        }
    }

    public static void blend(int[] raw, int alphaValue, int maskColor, int dontmaskColor) {
        int len = raw.length;
        int i = 0;
        while (i < len) {
            int a = 0;
            int color = raw[i] & 0xFFFFFF;
            if (maskColor == color) {
                a = 0;
            } else if (dontmaskColor == color) {
                a = 255;
            } else if (alphaValue > 0) {
                a = alphaValue;
            }
            raw[i] = color += (a <<= 24);
            ++i;
        }
    }

    public static void blend(int[] raw, int alphaValue) {
        Utility.blend(raw, alphaValue, -1, -1);
    }

    public static Image flipImage(Image in) {
        Image out = null;
        if (in == null) {
            System.out.println("null input image");
            return null;
        }
        try {
            MediaProcessor processor = GlobalManager.createMediaProcessor((String)"image/raw");
            processor.setInput((Object)in);
            ByteArrayOutputStream os = new ByteArrayOutputStream();
            processor.setOutput((OutputStream)os);
            ImageTransformControl transform = (ImageTransformControl)processor.getControl("javax.microedition.amms.control.imageeffect.ImageTransformControl");
            ImageFormatControl format = (ImageFormatControl)processor.getControl("javax.microedition.amms.control.ImageFormatControl");
            transform.setEnabled(true);
            transform.setSourceRect(0, in.getHeight(), in.getWidth(), -in.getHeight());
            transform.setTargetSize(0, 0, 0);
            format.setFormat("image/jpeg");
            format.setParameter("quality", 75);
            processor.complete();
            ByteArrayInputStream bais = new ByteArrayInputStream(os.toByteArray());
            out = Image.createImage((InputStream)bais);
            return out;
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    public static Image scaleImage(Image in, int width, int height, boolean maintainAspectRatio) {
        Image out = null;
        if (in == null) {
            System.out.println("null input image");
            return null;
        }
        try {
            MediaProcessor processor = GlobalManager.createMediaProcessor((String)"image/raw");
            processor.setInput((Object)in);
            ByteArrayOutputStream os = new ByteArrayOutputStream();
            processor.setOutput((OutputStream)os);
            ImageTransformControl transform = (ImageTransformControl)processor.getControl("javax.microedition.amms.control.imageeffect.ImageTransformControl");
            ImageFormatControl format = (ImageFormatControl)processor.getControl("javax.microedition.amms.control.ImageFormatControl");
            transform.setEnabled(true);
            int sourceWidth = transform.getSourceWidth();
            int sourceHeight = transform.getSourceHeight();
            if (maintainAspectRatio && sourceWidth > sourceHeight) {
                height = (int)((float)width * ((float)sourceHeight / (float)sourceWidth));
            } else if (maintainAspectRatio) {
                width = (int)((float)height * ((float)sourceWidth / (float)sourceHeight));
            }
            transform.setSourceRect(0, 0, sourceWidth, sourceHeight);
            transform.setTargetSize(width, height, 0);
            processor.complete();
            ByteArrayInputStream bais = new ByteArrayInputStream(os.toByteArray());
            out = Image.createImage((InputStream)bais);
            return out;
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    public static void scaleImage(InputStream is, OutputStream os, int width, int height, boolean maintainAspectRatio) {
        try {
            MediaProcessor processor = GlobalManager.createMediaProcessor((String)"image/jpeg");
            processor.setInput(is, is.available());
            processor.setOutput(os);
            ImageTransformControl transform = (ImageTransformControl)processor.getControl("javax.microedition.amms.control.imageeffect.ImageTransformControl");
            ImageFormatControl format = (ImageFormatControl)processor.getControl("javax.microedition.amms.control.ImageFormatControl");
            transform.setEnabled(true);
            int sourceWidth = transform.getSourceWidth();
            int sourceHeight = transform.getSourceHeight();
            if (maintainAspectRatio && sourceWidth > sourceHeight) {
                height = (int)((float)width * ((float)sourceHeight / (float)sourceWidth));
            } else if (maintainAspectRatio) {
                width = (int)((float)height * ((float)sourceWidth / (float)sourceHeight));
            }
            transform.setSourceRect(0, 0, sourceWidth, sourceHeight);
            transform.setTargetSize(width, height, 0);
            format.setFormat("image/jpeg");
            format.setParameter("quality", 75);
            processor.complete();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public static String[] readSetting(String fileName, Class a) {
        InputStream stream;
        block6: {
            String lang = System.getProperty("microedition.locale");
            System.out.println(lang);
            if (lang == null) {
                lang = "en";
            }
            if ((stream = a.getResourceAsStream("/" + lang + "/" + fileName)) == null && (stream = a.getResourceAsStream("/" + lang.substring(0, 2) + "/" + fileName)) == null) {
                stream = a.getResourceAsStream("/en/" + fileName);
            }
            if (stream != null) break block6;
            return null;
        }
        try {
            DataInputStream in = new DataInputStream(stream);
            int nLines = Integer.parseInt(in.readUTF());
            String[] lines = new String[nLines];
            int i = 0;
            while (i < nLines) {
                lines[i] = in.readUTF();
                ++i;
            }
            in.close();
            stream.close();
            in = null;
            stream = null;
            return lines;
        }
        catch (Exception e) {
            System.out.println(e.toString());
            return null;
        }
    }

    public static boolean FindBirthdayEvent(Calendar time, String name) {
        EventList events = null;
        String[] listsA = PIM.getInstance().listPIMLists(2);
        if (listsA == null || listsA.length == 0) {
            return false;
        }
        try {
            events = (EventList)PIM.getInstance().openPIMList(2, 1, listsA[0]);
        }
        catch (PIMException e) {
            System.out.println(e.toString());
            return false;
        }
        boolean bRet = false;
        try {
            Enumeration enums = events.items(0, time.getTime().getTime() + 43200000L - 1L, time.getTime().getTime() + 43200000L + 600000L + 1L, true);
            while (enums.hasMoreElements()) {
                String str;
                Event e = (Event)enums.nextElement();
                if (!events.isSupportedField(107) || (str = e.getString(107, 0)) == null || !str.equals(String.valueOf(name) + "\u7684\u751f\u65e5")) continue;
                bRet = true;
                break;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        try {
            events.close();
        }
        catch (PIMException pIMException) {
            // empty catch block
        }
        return bRet;
    }

    public static boolean AddBirthdayEvent(Calendar time, String name) {
        EventList events = null;
        String[] listsA = PIM.getInstance().listPIMLists(2);
        if (listsA == null || listsA.length == 0) {
            return false;
        }
        try {
            events = (EventList)PIM.getInstance().openPIMList(2, 2, listsA[0]);
        }
        catch (PIMException e) {
            System.out.println(e.toString());
            return false;
        }
        int[] nFields = events.getSupportedFields();
        Event event = events.createEvent();
        if (events.isSupportedField(107)) {
            event.addString(107, 0, String.valueOf(name) + "\u7684\u751f\u65e5");
        }
        if (events.isSupportedField(106)) {
            event.addDate(106, 0, time.getTime().getTime() + 43200000L);
        }
        if (events.isSupportedField(102)) {
            event.addDate(102, 0, time.getTime().getTime() + 43200000L + 600000L);
        }
        if (events.isSupportedField(100)) {
            event.addInt(100, 0, 86400);
        }
        try {
            if (events.maxCategories() != 0 && events.isCategory("Work")) {
                event.addToCategory("Work");
            }
        }
        catch (Exception e) {
            System.out.println(e.toString());
        }
        events.importEvent(event);
        boolean bRet = false;
        try {
            event.commit();
            bRet = true;
        }
        catch (PIMException e) {
            System.out.println(e.toString());
        }
        try {
            events.close();
        }
        catch (PIMException pIMException) {
            // empty catch block
        }
        return bRet;
    }
}

