/*
 * Decompiled with CFR 0.152.
 */
package com.myweather.control;

import com.myweather.constants.GeneralConstants;
import com.myweather.util.ConnectionUtil;
import com.myweather.valueobject.AdInfo;
import com.myweather.valueobject.ChargeInfo;
import com.myweather.valueobject.CityInfo;
import com.myweather.valueobject.ForecastDay;
import com.myweather.valueobject.LifeStyle;
import java.util.Hashtable;

public class AppEngine {
    private static AppEngine _THIS = null;
    public boolean firstInited = false;
    public String initError;

    private AppEngine() {
        try {
            this.init();
        }
        catch (Exception e) {
            this.initError = e.getMessage();
            System.out.println(e.getMessage());
        }
    }

    public static AppEngine getInstance(boolean createIfNull) {
        if (_THIS == null && createIfNull) {
            _THIS = new AppEngine();
        }
        return _THIS;
    }

    public static void nullInstance() {
        _THIS = null;
    }

    public void init() throws Exception {
        if (this.firstInited) {
            return;
        }
        this.firstInited = true;
        _THIS = this;
    }

    public CityInfo getCityList(String currUrl) throws Exception {
        System.gc();
        return ConnectionUtil.getCityInfo(null, currUrl, null, 0, 0, null);
    }

    public ForecastDay getForeCastDays(String forecastUrl) throws Exception {
        System.gc();
        return ConnectionUtil.getForeCastDay(null, forecastUrl, null, 0, 0, null);
    }

    public LifeStyle getLifeStyle(String lifeStyleUrl) throws Exception {
        System.gc();
        return ConnectionUtil.getLifeStyle(null, lifeStyleUrl, null, 0, 0, null);
    }

    public ChargeInfo getChargeInfo(String chargeUrl) throws Exception {
        System.gc();
        return ConnectionUtil.getChargeInfo(null, chargeUrl, null, 0, 0, null);
    }

    public AdInfo getAdInfo(String adUrl) throws Exception {
        System.gc();
        return ConnectionUtil.getAdInfo(null, adUrl, null, 0, 0, null);
    }

    public String getMessage(String messageUrl) throws Exception {
        System.gc();
        Hashtable<String, String> headers = new Hashtable<String, String>();
        headers.put("manufacture", GeneralConstants.HEADER_MANUFACTURE);
        headers.put("version", GeneralConstants.HEADER_VERSION);
        headers.put("model", GeneralConstants.HEADER_MODEL);
        headers.put("platform", GeneralConstants.HEADER_PLATFORM);
        return ConnectionUtil.getMessage(null, messageUrl, null, 0, 0, headers);
    }
}

