/*
 * Decompiled with CFR 0.152.
 */
package com.myweather.ui;

import com.myweather.constants.CommandConstants;
import com.myweather.constants.GeneralConstants;
import com.myweather.control.thread.GetCityListThread;
import com.myweather.midlet.MyWeatherMidlet;
import com.myweather.ui.MainUI;
import com.myweather.ui.SettingUI;
import com.myweather.util.BasicFunction;
import com.myweather.util.RmsUtility;
import de.enough.polish.ui.Alert;
import de.enough.polish.ui.ChoiceGroup;
import de.enough.polish.ui.FilteredChoiceGroup;
import de.enough.polish.ui.Form;
import de.enough.polish.ui.Item;
import de.enough.polish.ui.ItemCommandListener;
import de.enough.polish.ui.MasterCanvas;
import de.enough.polish.ui.StringItem;
import de.enough.polish.ui.Style;
import de.enough.polish.ui.StyleSheet;
import de.enough.polish.ui.TextField;
import de.enough.polish.ui.UiAccess;
import de.enough.polish.util.Debug;
import java.io.IOException;
import java.util.Vector;
import javax.microedition.lcdui.AlertType;
import javax.microedition.lcdui.Command;
import javax.microedition.lcdui.CommandListener;
import javax.microedition.lcdui.Displayable;
import javax.microedition.lcdui.Graphics;
import javax.microedition.lcdui.Image;
import javax.microedition.rms.RecordStore;

public class AddCityUI
extends Form
implements CommandListener,
ItemCommandListener {
    public SettingUI settingUI;
    public MainUI mainUI;
    public ChoiceGroup cityGroup;
    public FilteredChoiceGroup cityGroupFilter;
    public TextField cityfield;
    public Vector searchResultList = new Vector();
    private int recordIdOfCity = -1;
    boolean isExist = false;

    public AddCityUI(SettingUI settingUI) {
        super("");
        this.settingUI = settingUI;
        this.setCommandListener(this);
        this.addCommand(CommandConstants.BACK);
    }

    public AddCityUI(MainUI mainUI) {
        super("");
        this.mainUI = mainUI;
        this.setCommandListener(this);
        this.addCommand(CommandConstants.BACK);
    }

    public AddCityUI(SettingUI settingUI, Style style) {
        super("", style);
        this.settingUI = settingUI;
        this.setCommandListener(this);
        this.addCommand(CommandConstants.BACK);
        this.addCommand(CommandConstants.SAVE);
        StringItem label = new StringItem(null, "\u8bf7\u8f93\u5165\u57ce\u5e02\u540d\u79f0\uff1a", StyleSheet.inputlabelStyle);
        this.cityfield = new TextField(null, "", 30, 0, StyleSheet.inputStyle);
        UiAccess.setInputMode(this.cityfield, 4);
        this.cityGroupFilter = new FilteredChoiceGroup("", "\u8bf7\u9009\u62e9\u57ce\u5e02...", 3, StyleSheet.fromStyle);
        this.cityGroupFilter.addCommand(CommandConstants.SELECTCITY);
        this.cityGroupFilter.setItemCommandListener(this);
        for (int i = 0; i < GeneralConstants.cityList.length; ++i) {
            this.cityGroupFilter.append(GeneralConstants.cityList[i][1], null);
        }
        this.append(this.cityGroupFilter);
    }

    public AddCityUI(MainUI mainUI, Style style) {
        super("", style);
        this.mainUI = mainUI;
        this.setCommandListener(this);
        this.addCommand(CommandConstants.BACK);
        this.addCommand(CommandConstants.SAVE);
        StringItem label = new StringItem(null, "\u8bf7\u8f93\u5165\u57ce\u5e02\u540d\u79f0\uff1a", StyleSheet.inputlabelStyle);
        this.cityfield = new TextField(null, "", 30, 0, StyleSheet.inputStyle);
        UiAccess.setInputMode(this.cityfield, 4);
        this.cityGroupFilter = new FilteredChoiceGroup("", "\u8bf7\u9009\u62e9\u57ce\u5e02...", 3, StyleSheet.fromStyle);
        this.cityGroupFilter.addCommand(CommandConstants.SELECTCITY);
        this.cityGroupFilter.setItemCommandListener(this);
        for (int i = 0; i < GeneralConstants.cityList.length; ++i) {
            this.cityGroupFilter.append(GeneralConstants.cityList[i][1], null);
        }
        this.append(this.cityGroupFilter);
    }

    private void searchCity() throws IOException {
        boolean isDeleteAll = false;
        for (int i = 0; i < GeneralConstants.cityList.length; ++i) {
            String cityName = GeneralConstants.cityList[i][1];
            if (this.cityfield.getString() == null || this.cityfield.getString() == "" || cityName.indexOf(this.cityfield.getString()) < 0) continue;
            if (!isDeleteAll) {
                this.cityGroupFilter.deleteAll();
                isDeleteAll = true;
            }
            this.cityGroupFilter.append(GeneralConstants.cityList[i][1], null);
            this.searchResultList.addElement(new Integer(i));
        }
        this.cityGroupFilter.setSelectedIndex(0, true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void saveCity(int index) {
        RecordStore cityRms;
        block5: {
            cityRms = null;
            int[] customizeCityIds = BasicFunction.getCustomizeCityIds();
            try {
                for (int i = 0; i < customizeCityIds.length; ++i) {
                    if (index != customizeCityIds[i]) continue;
                    this.isExist = true;
                    break;
                }
                if (this.isExist) break block5;
                cityRms = RmsUtility.openRms("CITY_LIST", true);
                byte[] data = BasicFunction.serialize(index);
                this.recordIdOfCity = cityRms.addRecord(data, 0, data.length);
                if (this.settingUI == null) break block5;
                this.settingUI.addNewCity = true;
            }
            catch (Exception e) {
                try {
                    System.out.println("save city:" + e.getMessage());
                }
                catch (Throwable throwable) {
                    RmsUtility.closeRmsQuietly(cityRms);
                    throw throwable;
                }
                RmsUtility.closeRmsQuietly(cityRms);
            }
        }
        RmsUtility.closeRmsQuietly(cityRms);
    }

    public void showAlertUI(String desc) {
        Alert alert = new Alert(null, desc, null, AlertType.INFO, StyleSheet.setselectcityalertStyle);
        alert.setTimeout(2000);
        MasterCanvas.setCurrent(MyWeatherMidlet.getInstance().display, (Displayable)alert);
    }

    public void paint(Graphics g) {
        super.paint(g);
        try {
            Image downImg = Image.createImage((String)"/arrowDown.png");
            g.drawImage(downImg, this.getWidth(), 45, 24);
        }
        catch (Exception e) {
            Debug.debug("error", "com.myweather.ui.AddCityUI", 200, e.getMessage());
        }
    }

    public void commandAction(Command command, Displayable disp) {
        if (command == CommandConstants.BACK) {
            if (this.settingUI != null) {
                this.settingUI.delete(1);
                this.settingUI.showOrderedCityList();
                MasterCanvas.setCurrent(MyWeatherMidlet.getInstance().display, (Displayable)this.settingUI);
            } else {
                MasterCanvas.setCurrent(MyWeatherMidlet.getInstance().display, (Displayable)this.mainUI);
            }
        }
        if (command == CommandConstants.SAVE) {
            this.isExist = false;
            int selectedIndex = -1;
            selectedIndex = this.searchResultList.size() > 0 ? Integer.parseInt(this.searchResultList.elementAt(this.cityGroupFilter.getSelectedIndex()).toString()) : this.cityGroupFilter.getSelectedIndex();
            if (selectedIndex != -1) {
                this.saveCity(selectedIndex);
                if (this.isExist) {
                    this.showAlertUI("\u9009\u62e9\u7684\u57ce\u5e02\u5df2\u7ecf\u5b58\u5728\uff01");
                } else if (this.settingUI != null) {
                    this.settingUI.delete(1);
                    this.settingUI.showOrderedCityList();
                    MasterCanvas.setCurrent(MyWeatherMidlet.getInstance().display, (Displayable)this.settingUI);
                } else {
                    this.mainUI.deleteAll();
                    new GetCityListThread(this.mainUI, GeneralConstants.CURR_URL).start();
                }
            } else {
                this.showAlertUI("\u8bf7\u9009\u62e9\u57ce\u5e02\uff01");
            }
        }
        if (command == CommandConstants.SEARCH) {
            try {
                this.searchCity();
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
    }

    public void commandAction(Command command, Item arg1) {
    }
}

