/*
 * Decompiled with CFR 0.152.
 */
package com.myweather.ui;

import com.myweather.constants.GeneralConstants;
import de.enough.polish.ui.Form;
import de.enough.polish.ui.MasterCanvas;
import de.enough.polish.util.Debug;
import javax.microedition.lcdui.Graphics;
import javax.microedition.lcdui.Image;

public class AppStartUI
extends Form
implements Runnable {
    public Object SYNC_OBJ = new Object();
    public Thread waitingThread;
    public boolean stopped = false;
    public Image welcomeImage;
    public Image progressImage;
    public int progressX;
    public int progressY;
    public int welcomeImageX;
    public int welcomeImageY;

    public AppStartUI() {
        super(null);
        this.init();
        this.resume();
    }

    public void init() {
        try {
            this.welcomeImage = Image.createImage((String)"/welcome.png");
            this.welcomeImageX = (this.getWidth() - this.welcomeImage.getWidth()) / 2;
            this.progressImage = GeneralConstants.PROGRESS_IMAGE;
            this.progressX = 0;
        }
        catch (Exception e) {
            Debug.debug("error", "com.myweather.ui.AppStartUI", 52, e.getMessage());
        }
    }

    public void paint(Graphics g) {
        super.paint(g);
        this.drawWelcomeInfo(g);
    }

    public void drawWelcomeInfo(Graphics g) {
        try {
            g.setColor(255, 255, 255);
            g.fillRect(0, 0, this.getWidth(), this.getHeight());
            this.welcomeImageY = this.getHeight() / 6;
            g.drawImage(this.welcomeImage, this.welcomeImageX, this.welcomeImageY, 20);
            this.progressY = this.getHeight() * 5 / 6;
            g.drawImage(this.progressImage, this.progressX, this.progressY, 20);
        }
        catch (Exception e) {
            Debug.debug("error", "com.myweather.ui.AppStartUI", 73, e.getMessage());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void run() {
        while (!this.stopped) {
            this.progressX = this.progressX < this.getWidth() - this.progressImage.getWidth() ? (this.progressX += this.progressImage.getWidth() / 3) : 0;
            MasterCanvas.repaintCanvas(this);
            Object object = this.SYNC_OBJ;
            synchronized (object) {
                try {
                    this.SYNC_OBJ.wait(200L);
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
            if (!this.stopped) continue;
            break;
        }
    }

    public void resume() {
        this.stopped = false;
        if (this.waitingThread != null && this.waitingThread.isAlive()) {
            this.forceNotify();
        } else {
            this.waitingThread = new Thread(this);
            this.waitingThread.start();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void forceNotify() {
        Object object = this.SYNC_OBJ;
        synchronized (object) {
            try {
                this.SYNC_OBJ.notifyAll();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void forceWait() {
        Object object = this.SYNC_OBJ;
        synchronized (object) {
            try {
                this.SYNC_OBJ.wait();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }
}

