/*
 * Decompiled with CFR 0.152.
 */
package com.myweather.ui;

import com.myweather.constants.CommandConstants;
import com.myweather.constants.GeneralConstants;
import com.myweather.control.AppEngine;
import com.myweather.control.thread.GetCityDetailThread;
import com.myweather.midlet.MyWeatherMidlet;
import com.myweather.ui.AboutUI;
import com.myweather.ui.AddCityUI;
import com.myweather.ui.ChargeUI;
import com.myweather.ui.CityDetailUI;
import com.myweather.ui.HelpUI;
import com.myweather.ui.SettingUI;
import com.myweather.ui.TemperatureSettingUI;
import com.myweather.util.BasicFunction;
import com.myweather.util.RmsUtility;
import com.myweather.valueobject.CityInfo;
import de.enough.polish.ui.Alert;
import de.enough.polish.ui.Form;
import de.enough.polish.ui.ImageItem;
import de.enough.polish.ui.Item;
import de.enough.polish.ui.ItemCommandListener;
import de.enough.polish.ui.MasterCanvas;
import de.enough.polish.ui.Style;
import de.enough.polish.ui.StyleSheet;
import de.enough.polish.ui.TableItem;
import de.enough.polish.util.ArrayList;
import de.enough.polish.util.Debug;
import java.io.IOException;
import javax.microedition.lcdui.AlertType;
import javax.microedition.lcdui.Command;
import javax.microedition.lcdui.CommandListener;
import javax.microedition.lcdui.Displayable;
import javax.microedition.lcdui.Graphics;
import javax.microedition.lcdui.Image;
import javax.microedition.rms.RecordEnumeration;
import javax.microedition.rms.RecordStore;

public class MainUI
extends Form
implements CommandListener,
ItemCommandListener {
    private int recordIdOfCity = -1;
    private boolean isClickLeftMenu = false;
    CityDetailUI cityDetailUI = null;
    int size = 0;

    public MainUI() throws IOException {
        super("");
        this.setCommandListener(this);
        this.addCommand(CommandConstants.EXIT);
        this.addCommand(CommandConstants.SET);
    }

    public MainUI(Style style) throws IOException {
        super("", style);
        this.setCommandListener(this);
        this.addCommand(CommandConstants.EXIT);
        this.addCommand(CommandConstants.SET);
        this.addCommand(CommandConstants.SET_TEMP);
        this.addCommand(CommandConstants.HELP);
        this.addCommand(CommandConstants.ABOUT);
    }

    public void showCityList(ArrayList cityList) throws IOException {
        this.size = cityList.size();
        for (int i = 0; i < this.size; ++i) {
            Image skyConditionIcon = null;
            CityInfo cityInfo = (CityInfo)cityList.get(i);
            TableItem table = new TableItem(3, 1, StyleSheet.defaulttableStyle);
            table.set(0, 0, cityInfo.city, StyleSheet.citynametablecellStyle);
            for (int j = 0; j < GeneralConstants.SKY_CONDITIONS.length; ++j) {
                if (!GeneralConstants.SKY_CONDITIONS[j][0].equals(cityInfo.skyConditions)) continue;
                skyConditionIcon = Image.createImage((String)GeneralConstants.SKY_CONDITIONS[j][1]);
            }
            if (skyConditionIcon == null) {
                skyConditionIcon = GeneralConstants.NA;
            }
            ImageItem imgItem = new ImageItem(null, skyConditionIcon, 0, null);
            table.set(1, 0, imgItem);
            table.set(2, 0, BasicFunction.temperatureConverter(cityInfo.temperature), StyleSheet.citytablecellStyle);
            table.setSelectionMode(16);
            table.setLineStyle(TableItem.LINE_STYLE_INVISIBLE, 0);
            table.addCommand(CommandConstants.OPEN);
            this.append(table);
        }
    }

    public void showCityList(CityInfo cityInfo) throws IOException {
        TableItem table = new TableItem(3, 1, StyleSheet.defaulttableStyle);
        Image skyConditionIcon = Image.createImage((String)"/clear.gif");
        table.set(0, 0, cityInfo.city, StyleSheet.citynametablecellStyle);
        for (int j = 0; j < GeneralConstants.SKY_CONDITIONS.length; ++j) {
            if (!GeneralConstants.SKY_CONDITIONS[j][0].equals(cityInfo.skyConditions)) continue;
            skyConditionIcon = Image.createImage((String)GeneralConstants.SKY_CONDITIONS[j][1]);
        }
        ImageItem imgItem = new ImageItem(null, skyConditionIcon, 0, null);
        table.set(1, 0, imgItem);
        table.set(2, 0, BasicFunction.temperatureConverter(cityInfo.temperature), StyleSheet.citytablecellStyle);
        table.setSelectionMode(16);
        table.setLineStyle(TableItem.LINE_STYLE_INVISIBLE, 0);
        this.append(table);
    }

    public void showCityListFromMap() throws IOException {
        CityInfo cityInfo = null;
        int[] customizeCityIds = BasicFunction.getCustomizeCityIds();
        int customizeCitySize = customizeCityIds.length;
        if (GeneralConstants.IS_FREE && customizeCitySize > 3) {
            customizeCitySize = 3;
        }
        try {
            String tempture = "";
            for (int i = 0; i < customizeCitySize; ++i) {
                Image skyConditionIcon = GeneralConstants.NA;
                cityInfo = (CityInfo)GeneralConstants.cityIdsMap.get(String.valueOf(customizeCityIds[i]));
                if (cityInfo != null) {
                    tempture = BasicFunction.temperatureConverter(cityInfo.temperature);
                    for (int j = 0; j < GeneralConstants.SKY_CONDITIONS.length; ++j) {
                        if (!GeneralConstants.SKY_CONDITIONS[j][0].equals(cityInfo.skyConditions)) continue;
                        skyConditionIcon = Image.createImage((String)GeneralConstants.SKY_CONDITIONS[j][1]);
                    }
                } else {
                    tempture = "-";
                }
                TableItem table = new TableItem(3, 1, StyleSheet.defaulttableStyle);
                table.set(0, 0, GeneralConstants.cityList[customizeCityIds[i]][1], StyleSheet.citynametablecellStyle);
                ImageItem imgItem = new ImageItem(null, skyConditionIcon, 0, null);
                table.set(1, 0, imgItem);
                table.set(2, 0, tempture, StyleSheet.citytablecellStyle);
                table.setSelectionMode(16);
                table.setLineStyle(TableItem.LINE_STYLE_INVISIBLE, 0);
                table.addCommand(CommandConstants.OPEN);
                this.append(table);
            }
            if (GeneralConstants.IS_FREE) {
                ImageItem adItem = new ImageItem(null, GeneralConstants.AD_IMAGE, 0, null, StyleSheet.titlecenterStyle);
                this.append(adItem);
            }
            this.showHuafeng();
        }
        catch (Exception e) {
            Debug.debug("error", "com.myweather.ui.MainUI", 237, e.getMessage());
        }
    }

    public void showAd() {
        ImageItem huafengItem = new ImageItem(null, GeneralConstants.AD_IMAGE, 0, null, StyleSheet.titlecenterStyle);
        this.append(huafengItem);
    }

    public void showHuafeng() {
        ImageItem huafengItem = new ImageItem(null, GeneralConstants.HUAFENG, 0, null, StyleSheet.titlecenterStyle);
        this.append(huafengItem);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void showMessageUI() {
        RecordStore messageRms;
        block5: {
            String pre = "";
            String messageBody = "";
            String rmsPre = "";
            messageRms = null;
            try {
                String message;
                if (GeneralConstants.isShowMessage) break block5;
                GeneralConstants.isShowMessage = true;
                messageRms = RmsUtility.openRms("PROGRAM_MESSAGE", true);
                RecordEnumeration recordEnu = messageRms.enumerateRecords(null, null, false);
                if (recordEnu.numRecords() > 0) {
                    rmsPre = BasicFunction.deserializeString(messageRms.getRecord(1));
                }
                if ("".equals((message = AppEngine.getInstance(true).getMessage(GeneralConstants.MESSAGE_URL)).trim()) || message == null) break block5;
                pre = message.substring(0, 8);
                messageBody = message.substring(8);
                if (rmsPre.equals(pre)) break block5;
                this.setMessage(pre);
                Alert alert = new Alert(null, messageBody, null, AlertType.INFO, StyleSheet.settemperaturealertStyle);
                alert.setTimeout(5000);
                MasterCanvas.setCurrent(MyWeatherMidlet.getInstance().display, (Displayable)alert);
            }
            catch (Exception exp) {
                try {
                    GeneralConstants.isShowMessage = false;
                    System.out.println(exp.getMessage());
                }
                catch (Throwable throwable) {
                    RmsUtility.closeRmsQuietly(messageRms);
                    throw throwable;
                }
                RmsUtility.closeRmsQuietly(messageRms);
            }
        }
        RmsUtility.closeRmsQuietly(messageRms);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setMessage(String pre) {
        RecordStore messageRms = null;
        try {
            messageRms = RmsUtility.openRms("PROGRAM_MESSAGE", true);
            RecordEnumeration recordEnu = messageRms.enumerateRecords(null, null, false);
            byte[] data1 = BasicFunction.serialize(pre);
            if (recordEnu.numRecords() == 0) {
                messageRms.addRecord(data1, 0, data1.length);
            } else {
                messageRms.setRecord(1, data1, 0, data1.length);
            }
        }
        catch (Exception e) {
            System.out.println("exception:" + e.getMessage());
        }
        finally {
            RmsUtility.closeRmsQuietly(messageRms);
        }
    }

    public void openDetailUI() {
        try {
            this.cityDetailUI = new CityDetailUI(GeneralConstants.HEADINGS_TAB, this, StyleSheet.forcastscreenStyle);
            new GetCityDetailThread(this.cityDetailUI, GeneralConstants.FORECAST_URL, this.getCurrentIndex()).start();
        }
        catch (IOException ioe) {
            ioe.printStackTrace();
        }
    }

    public void paint(Graphics g) {
        super.paint(g);
    }

    public void commandAction(Command command, Displayable disp) {
        if (command == CommandConstants.EXIT) {
            MyWeatherMidlet.getInstance().midletControl.exitAlert((Displayable)this);
        }
        if (command == CommandConstants.SET) {
            SettingUI settingUI = new SettingUI(this, StyleSheet.mainscreenStyle);
            MasterCanvas.setCurrent(MyWeatherMidlet.getInstance().display, (Displayable)settingUI);
        }
        if (command == CommandConstants.OPEN && this.getCurrentIndex() != -1) {
            this.openDetailUI();
        }
        if (command == CommandConstants.ADD) {
            int[] customizeCityIds = BasicFunction.getCustomizeCityIds();
            if (GeneralConstants.IS_FREE && customizeCityIds.length > 2) {
                ChargeUI chargeUI = new ChargeUI((Displayable)this, StyleSheet.addcityscreenStyle);
                MasterCanvas.setCurrent(MyWeatherMidlet.getInstance().display, (Displayable)chargeUI);
            } else {
                AddCityUI addUI = new AddCityUI(this, StyleSheet.addcityscreenStyle);
                MasterCanvas.setCurrent(MyWeatherMidlet.getInstance().display, (Displayable)addUI);
            }
        }
        if (command == CommandConstants.ABOUT) {
            AboutUI about = new AboutUI(this, StyleSheet.addcityscreenStyle);
            MasterCanvas.setCurrent(MyWeatherMidlet.getInstance().display, (Displayable)about);
        }
        if (command == CommandConstants.HELP) {
            HelpUI help = new HelpUI(this, StyleSheet.addcityscreenStyle);
            MasterCanvas.setCurrent(MyWeatherMidlet.getInstance().display, (Displayable)help);
        }
        if (command == CommandConstants.SET_TEMP) {
            TemperatureSettingUI temperatureSettingUI = new TemperatureSettingUI(this, StyleSheet.mainscreenStyle);
            MasterCanvas.setCurrent(MyWeatherMidlet.getInstance().display, (Displayable)temperatureSettingUI);
        }
    }

    public void commandAction(Command command, Item arg1) {
        if (command == CommandConstants.ENTER_AD) {
            try {
                MyWeatherMidlet.getInstance().platformRequest("http://www.myweather.com/");
            }
            catch (Exception e) {
                System.out.println(e.toString());
            }
        }
    }
}

