/*
 * Decompiled with CFR 0.152.
 */
package com.myweather.ui;

import com.myweather.constants.CommandConstants;
import com.myweather.constants.GeneralConstants;
import com.myweather.midlet.MyWeatherMidlet;
import com.myweather.ui.CityDetailUI;
import de.enough.polish.ui.ImageItem;
import de.enough.polish.ui.MasterCanvas;
import de.enough.polish.ui.StringItem;
import de.enough.polish.ui.Style;
import de.enough.polish.ui.TabbedForm;
import javax.microedition.lcdui.Command;
import javax.microedition.lcdui.CommandListener;
import javax.microedition.lcdui.Displayable;
import javax.microedition.lcdui.Font;
import javax.microedition.lcdui.Graphics;
import javax.microedition.lcdui.Image;

public class WaitingDetailForm
extends TabbedForm
implements CommandListener,
Runnable {
    public Object SYNC_OBJ = new Object();
    public Thread waitingThread;
    public boolean stopped = false;
    public int progressX;
    public int progressY;
    public int tickerIndex = 1;
    public String domain = "myweather.com";
    public int domainX;
    public int domainY;
    public int dataLoadX;
    public int dataLoadY;
    public boolean drawProgress = true;
    public boolean drawDomain = true;
    public CityDetailUI parent;
    public int gaugeItemNum = -1;
    public int waitingInfoItemNum = -1;
    public int resultInfoItemNum = -1;
    public StringItem waitingInfoItem;
    public StringItem resultInfoItem;
    Image ticker = null;
    public boolean cancel = false;

    private WaitingDetailForm(String[] headings, Style style) {
        super("", headings, null, style);
    }

    public WaitingDetailForm(String[] headings, Displayable parent, boolean addOKCmd, boolean addCancelCmd) {
        this(headings, null);
    }

    public WaitingDetailForm(String[] headings, CityDetailUI parent, boolean addOKCmd, boolean addCancelCmd, Style style) {
        this(headings, style);
        if (parent != null) {
            this.parent = parent;
        }
        if (addOKCmd) {
            this.addCommand(CommandConstants.OK);
            this.setCommandListener(this);
        }
        if (addCancelCmd) {
            this.addCommand(CommandConstants.CANCEL);
            this.setCommandListener(this);
        }
        try {
            ImageItem imgSatelliteItem = new ImageItem(null, GeneralConstants.RADAR_BASE_MAP, 512, null);
            this.append(2, imgSatelliteItem);
        }
        catch (Exception e) {
            System.out.println(e);
        }
    }

    public void addCommand(Command command) {
        super.addCommand(command);
        if (command == CommandConstants.OK) {
            this.removeCommand(CommandConstants.CANCEL);
        }
    }

    public void showJustDataLoadding(String info) {
        this.drawProgress = true;
        this.resume();
        info = info + "\n\n" + "\u6570\u636e\u52a0\u8f7d\u4e2d...";
    }

    public void showResultInfo(String info) {
        this.deleteAll();
        this.drawProgress = false;
        this.resultInfoItem = new StringItem(null, info);
        this.resultInfoItemNum = this.append(this.resultInfoItem);
    }

    public void paint(Graphics g) {
        super.paint(g);
        if (this.drawProgress) {
            this.drawProgressImage(g);
        }
        if (this.drawDomain) {
            // empty if block
        }
    }

    public void drawProgressImage(Graphics g) {
        try {
            this.ticker = Image.createImage((String)("/ticker" + this.tickerIndex + ".png"));
        }
        catch (Exception e) {
            System.out.println(e.getMessage());
        }
        this.progressY = this.getHeight() - 10;
        g.drawImage(this.ticker, 97, 150, 20);
    }

    public void drawDataLoad(Graphics g) {
        Font font = Font.getFont((int)0, (int)1, (int)16);
        this.dataLoadY = this.titleHeight + this.subTitleHeight + (this.getHeight() - this.titleHeight - this.subTitleHeight) * 2 / 3;
        g.setFont(font);
        g.setColor(255, 255, 255);
        g.drawString("\u6570\u636e\u52a0\u8f7d\u4e2d...", this.dataLoadX, this.dataLoadY, 20);
    }

    public void drawDomain(Graphics g) {
        Font font = Font.getFont((int)0, (int)0, (int)0);
        this.domainY = this.getHeight() - font.getHeight();
        g.setFont(font);
        g.setColor(0, 0, 0);
        g.drawString(this.domain, this.domainX, this.domainY, 20);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void run() {
        while (!this.stopped) {
            ++this.tickerIndex;
            if (this.tickerIndex > 8) {
                this.tickerIndex = 1;
            }
            MasterCanvas.repaintCanvas(this);
            Object object = this.SYNC_OBJ;
            synchronized (object) {
                try {
                    this.SYNC_OBJ.wait(100L);
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
            if (!this.stopped) continue;
            break;
        }
    }

    public void resume() {
        this.stopped = false;
        if (this.waitingThread != null && this.waitingThread.isAlive()) {
            this.forceNotify();
        } else {
            this.waitingThread = new Thread(this);
            this.waitingThread.start();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void forceNotify() {
        Object object = this.SYNC_OBJ;
        synchronized (object) {
            try {
                this.SYNC_OBJ.notifyAll();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void forceWait() {
        Object object = this.SYNC_OBJ;
        synchronized (object) {
            try {
                this.SYNC_OBJ.wait();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    public void commandAction(Command command, Displayable disp) {
        this.stopped = true;
        if (command == CommandConstants.OK) {
            MasterCanvas.setCurrent(MyWeatherMidlet.getInstance().display, (Displayable)this.parent);
        } else if (command == CommandConstants.CANCEL && this.parent != null) {
            this.cancel = true;
            MasterCanvas.setCurrent(MyWeatherMidlet.getInstance().display, (Displayable)this.parent.mainUI);
        }
    }
}

