/*
 * Decompiled with CFR 0.152.
 */
package com.myweather.ui;

import com.myweather.constants.CommandConstants;
import com.myweather.constants.GeneralConstants;
import com.myweather.midlet.MyWeatherMidlet;
import com.myweather.ui.MainUI;
import com.myweather.util.BasicFunction;
import com.myweather.valueobject.CityInfo;
import de.enough.polish.ui.Form;
import de.enough.polish.ui.ImageItem;
import de.enough.polish.ui.MasterCanvas;
import de.enough.polish.ui.StringItem;
import de.enough.polish.ui.Style;
import de.enough.polish.ui.StyleSheet;
import de.enough.polish.ui.TableItem;
import de.enough.polish.util.Debug;
import javax.microedition.lcdui.Command;
import javax.microedition.lcdui.CommandListener;
import javax.microedition.lcdui.Displayable;
import javax.microedition.lcdui.Font;
import javax.microedition.lcdui.Graphics;
import javax.microedition.lcdui.Image;

public class WaitingForm
extends Form
implements CommandListener,
Runnable {
    public Object SYNC_OBJ = new Object();
    public Thread waitingThread;
    public boolean stopped = false;
    public int progressX;
    public int progressY;
    public int tickerIndex = 1;
    public String domain = "myweather.com";
    public int domainX;
    public int domainY;
    public int dataLoadX;
    public int dataLoadY;
    public boolean drawProgress = true;
    public boolean drawDomain = true;
    public MainUI parent;
    public int gaugeItemNum = -1;
    public int waitingInfoItemNum = -1;
    public int resultInfoItemNum = -1;
    public StringItem waitingInfoItem;
    public StringItem resultInfoItem;
    Image ticker = null;
    public boolean cancel = false;

    private WaitingForm(String title, Style style) {
        super("", style);
    }

    public WaitingForm(String title, Displayable parent, boolean addOKCmd, boolean addCancelCmd) {
        this("", (Style)null);
    }

    public WaitingForm(String title, Displayable parent, boolean addOKCmd, boolean addCancelCmd, Style style) {
        this("", style);
        this.parent = parent != null ? (MainUI)parent : (MainUI)MasterCanvas.getCurrent(MyWeatherMidlet.getInstance().display);
        if (addOKCmd) {
            this.addCommand(CommandConstants.OK);
            this.setCommandListener(this);
        }
        if (addCancelCmd) {
            this.addCommand(CommandConstants.CANCEL);
            this.setCommandListener(this);
        }
    }

    public void addCommand(Command command) {
        super.addCommand(command);
        if (command == CommandConstants.OK) {
            this.removeCommand(CommandConstants.CANCEL);
        }
    }

    public void showWaitingInfo(String info) {
        try {
            int[] customizeCityIds = BasicFunction.getCustomizeCityIds();
            int customizeCitySize = customizeCityIds.length;
            if (GeneralConstants.IS_FREE && customizeCitySize > 3) {
                customizeCitySize = 3;
            }
            CityInfo cityInfo = null;
            String tempture = "";
            for (int i = 0; i < customizeCitySize; ++i) {
                Image skyConditionIcon = null;
                cityInfo = (CityInfo)GeneralConstants.cityIdsMap.get(String.valueOf(customizeCityIds[i]));
                if (cityInfo != null) {
                    skyConditionIcon = GeneralConstants.NA;
                    tempture = BasicFunction.temperatureConverter(cityInfo.temperature);
                    for (int j = 0; j < GeneralConstants.SKY_CONDITIONS.length; ++j) {
                        if (!GeneralConstants.SKY_CONDITIONS[j][0].equals(cityInfo.skyConditions)) continue;
                        skyConditionIcon = Image.createImage((String)GeneralConstants.SKY_CONDITIONS[j][1]);
                    }
                } else {
                    tempture = "";
                    skyConditionIcon = GeneralConstants.NAWEATHER_IMAGE_L;
                }
                TableItem table = new TableItem(3, 1, StyleSheet.defaulttableStyle);
                table.set(0, 0, GeneralConstants.cityList[customizeCityIds[i]][1], StyleSheet.citynametablecellStyle);
                ImageItem imgItem = new ImageItem(null, skyConditionIcon, 0, null);
                table.set(1, 0, imgItem);
                table.set(2, 0, tempture, StyleSheet.citytablecellStyle);
                table.setSelectionMode(16);
                table.setLineStyle(TableItem.LINE_STYLE_INVISIBLE, 0);
                this.append(table);
            }
            if (GeneralConstants.AD_IMAGE != null && GeneralConstants.IS_FREE) {
                ImageItem adItem = new ImageItem(null, GeneralConstants.AD_IMAGE, 0, null, StyleSheet.titlecenterStyle);
                this.append(adItem);
            }
            ImageItem adItem = new ImageItem(null, GeneralConstants.HUAFENG, 0, null, StyleSheet.titlecenterStyle);
            this.append(adItem);
        }
        catch (Exception e) {
            Debug.debug("error", "com.myweather.ui.WaitingForm", 187, e.getMessage());
        }
        this.drawProgress = true;
        this.resume();
        info = info + "\n\n" + "\u6570\u636e\u52a0\u8f7d\u4e2d...";
    }

    public void showJustDataLoadding(String info) {
        this.drawProgress = true;
        this.resume();
        info = info + "\n\n" + "\u6570\u636e\u52a0\u8f7d\u4e2d...";
    }

    public void showResultInfo(String info) {
        this.deleteAll();
        this.drawProgress = false;
        this.resultInfoItem = new StringItem(null, info, StyleSheet.waitingstringitemStyle);
        this.resultInfoItemNum = this.append(this.resultInfoItem);
    }

    public void paint(Graphics g) {
        super.paint(g);
        if (this.drawProgress) {
            this.drawProgressImage(g);
        }
        if (this.drawDomain) {
            // empty if block
        }
    }

    public void drawProgressImage(Graphics g) {
        try {
            this.ticker = Image.createImage((String)("/ticker" + this.tickerIndex + ".png"));
        }
        catch (Exception e) {
            System.out.println(e.getMessage());
        }
        this.progressY = this.getHeight() - 10;
        g.drawImage(this.ticker, 97, 250, 20);
    }

    public void drawDataLoad(Graphics g) {
        Font font = Font.getFont((int)0, (int)1, (int)16);
        this.dataLoadY = this.titleHeight + this.subTitleHeight + (this.getHeight() - this.titleHeight - this.subTitleHeight) * 2 / 3;
        g.setFont(font);
        g.setColor(255, 255, 255);
        g.drawString("\u6570\u636e\u52a0\u8f7d\u4e2d...", this.dataLoadX, this.dataLoadY, 20);
    }

    public void drawDomain(Graphics g) {
        Font font = Font.getFont((int)0, (int)0, (int)0);
        this.domainY = this.getHeight() - font.getHeight();
        g.setFont(font);
        g.setColor(0, 0, 0);
        g.drawString(this.domain, this.domainX, this.domainY, 20);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void run() {
        while (!this.stopped) {
            ++this.tickerIndex;
            if (this.tickerIndex > 8) {
                this.tickerIndex = 1;
            }
            MasterCanvas.repaintCanvas(this);
            Object object = this.SYNC_OBJ;
            synchronized (object) {
                try {
                    this.SYNC_OBJ.wait(100L);
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
            if (!this.stopped) continue;
            break;
        }
    }

    public void resume() {
        this.stopped = false;
        if (this.waitingThread != null && this.waitingThread.isAlive()) {
            this.forceNotify();
        } else {
            this.waitingThread = new Thread(this);
            this.waitingThread.start();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void forceNotify() {
        Object object = this.SYNC_OBJ;
        synchronized (object) {
            try {
                this.SYNC_OBJ.notifyAll();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void forceWait() {
        Object object = this.SYNC_OBJ;
        synchronized (object) {
            try {
                this.SYNC_OBJ.wait();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    public void commandAction(Command command, Displayable disp) {
        this.stopped = true;
        if (command == CommandConstants.OK) {
            MasterCanvas.setCurrent(MyWeatherMidlet.getInstance().display, (Displayable)this.parent);
        } else if (command == CommandConstants.CANCEL) {
            try {
                if (this.parent != null) {
                    this.cancel = true;
                    this.parent.showCityListFromMap();
                    MasterCanvas.setCurrent(MyWeatherMidlet.getInstance().display, (Displayable)this.parent);
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }
}

