/*
 * Decompiled with CFR 0.152.
 */
package com.myweather.util;

import com.myweather.constants.GeneralConstants;
import com.myweather.util.ConnectionUtil;
import com.myweather.util.RmsUtility;
import com.myweather.valueobject.ChargeInfo;
import de.enough.polish.util.HashMap;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.InputStream;
import java.util.Calendar;
import java.util.Date;
import java.util.Vector;
import javax.microedition.io.HttpConnection;
import javax.microedition.lcdui.Image;
import javax.microedition.rms.RecordEnumeration;
import javax.microedition.rms.RecordStore;

public class BasicFunction {
    private static int recordIdOfCity = -1;
    private static int recordIdOfTemp = -1;
    private static int recordIdOfCharte = -1;
    private static int recordIdOfAggree = -1;
    public static HashMap cityIdsMap = new HashMap();

    public static String convertUrl(String url, int i) {
        String convertedUrl = "";
        convertedUrl = url + "&lat=" + GeneralConstants.cityList[i][3] + "&lon=" + GeneralConstants.cityList[i][4];
        return convertedUrl;
    }

    public static int[] getCustomizeCityIds() {
        Vector customizeCityIds = BasicFunction.getCityFromRms();
        int[] cityIds = new int[customizeCityIds.size()];
        for (int i = 0; i < customizeCityIds.size(); ++i) {
            cityIds[i] = Integer.parseInt(customizeCityIds.elementAt(i).toString());
        }
        return cityIds;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Vector getCityFromRms() {
        RecordStore cityRms = null;
        Vector<Integer> customizeCityIds = new Vector<Integer>();
        try {
            cityRms = RmsUtility.openRms("CITY_LIST", true);
            RecordEnumeration recordEnu = cityRms.enumerateRecords(null, null, false);
            while (recordEnu.hasPreviousElement()) {
                recordIdOfCity = recordEnu.previousRecordId();
                customizeCityIds.addElement(new Integer(BasicFunction.deserialize(cityRms.getRecord(recordIdOfCity))));
            }
        }
        catch (Exception e) {
            System.out.println(e.getMessage());
        }
        finally {
            RmsUtility.closeRmsQuietly(cityRms);
        }
        return customizeCityIds;
    }

    public static int[] getNewCityIds() {
        Vector customizeCityIds = BasicFunction.getNewCityFromRms();
        int[] cityIds = new int[customizeCityIds.size()];
        for (int i = 0; i < customizeCityIds.size(); ++i) {
            cityIds[i] = Integer.parseInt(customizeCityIds.elementAt(i).toString());
        }
        return cityIds;
    }

    public static void loadRadaImage() {
        if (GeneralConstants.RADAR_IMAGE1 == null) {
            Image image1;
            GeneralConstants.RADAR_IMAGE1 = image1 = BasicFunction.getImageFromStream("http://china.iphone.wp.myweather.net/weatherwidget/images/gif/radar1.png");
        }
        if (GeneralConstants.RADAR_IMAGE2 == null) {
            Image image2;
            GeneralConstants.RADAR_IMAGE2 = image2 = BasicFunction.getImageFromStream("http://china.iphone.wp.myweather.net/weatherwidget/images/gif/radar2.png");
        }
        if (GeneralConstants.RADAR_IMAGE3 == null) {
            Image image3;
            GeneralConstants.RADAR_IMAGE3 = image3 = BasicFunction.getImageFromStream("http://china.iphone.wp.myweather.net/weatherwidget/images/gif/radar3.png");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void saveCity(int index) {
        RecordStore cityRms = null;
        try {
            cityRms = RmsUtility.openRms("CITY_LIST", true);
            byte[] data = BasicFunction.serialize(index);
            recordIdOfCity = cityRms.addRecord(data, 0, data.length);
        }
        catch (Exception e) {
            System.out.println("save city:" + e.getMessage());
        }
        finally {
            RmsUtility.closeRmsQuietly(cityRms);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Vector getNewCityFromRms() {
        RecordStore cityRms = null;
        Vector<Integer> customizeCityIds = new Vector<Integer>();
        try {
            cityRms = RmsUtility.openRms("CITY_NEW_LIST", true);
            RecordEnumeration recordEnu = cityRms.enumerateRecords(null, null, false);
            while (recordEnu.hasNextElement()) {
                recordIdOfCity = recordEnu.nextRecordId();
                System.out.println("recordIdOfUserProfile = " + recordIdOfCity + ";name=" + BasicFunction.deserialize(cityRms.getRecord(recordIdOfCity)));
                customizeCityIds.addElement(new Integer(BasicFunction.deserialize(cityRms.getRecord(recordIdOfCity))));
            }
        }
        catch (Exception e) {
            System.out.println(e.getMessage());
        }
        finally {
            RmsUtility.closeRmsQuietly(cityRms);
        }
        return customizeCityIds;
    }

    public static byte[] serialize(int index) throws Exception {
        ByteArrayOutputStream bos = new ByteArrayOutputStream();
        DataOutputStream dos = new DataOutputStream(bos);
        dos.writeInt(index);
        dos.flush();
        return bos.toByteArray();
    }

    public static int deserialize(byte[] data) throws Exception {
        int index = -1;
        try {
            ByteArrayInputStream byteIn = new ByteArrayInputStream(data);
            DataInputStream dis = new DataInputStream(byteIn);
            index = dis.readInt();
        }
        catch (Exception e) {
            System.out.println(e.getMessage());
        }
        return index;
    }

    public static byte[] serializeLong(long index) throws Exception {
        ByteArrayOutputStream bos = new ByteArrayOutputStream();
        DataOutputStream dos = new DataOutputStream(bos);
        dos.writeLong(index);
        dos.flush();
        return bos.toByteArray();
    }

    public static long deserializeLong(byte[] data) throws Exception {
        long index = -1L;
        try {
            ByteArrayInputStream byteIn = new ByteArrayInputStream(data);
            DataInputStream dis = new DataInputStream(byteIn);
            index = dis.readLong();
        }
        catch (Exception e) {
            System.out.println(e.getMessage());
        }
        return index;
    }

    public static byte[] serialize(String src) throws Exception {
        ByteArrayOutputStream bos = new ByteArrayOutputStream();
        DataOutputStream dos = new DataOutputStream(bos);
        dos.writeUTF(src);
        dos.flush();
        return bos.toByteArray();
    }

    public static String deserializeString(byte[] data) throws Exception {
        String src = "";
        try {
            ByteArrayInputStream byteIn = new ByteArrayInputStream(data);
            DataInputStream dis = new DataInputStream(byteIn);
            src = dis.readUTF();
        }
        catch (Exception e) {
            System.out.println(e.getMessage());
        }
        return src;
    }

    public static String temperatureConverter(Object num) {
        String unit = "\u00b0C";
        String temperature = "-";
        int type = BasicFunction.getTemperatureType();
        if (num != null && !"".equals(num.toString())) {
            if (type == 2) {
                unit = "\u00b0F";
                int tempNum = Integer.parseInt(num.toString());
                double tmpDouble = 1.8 * (double)tempNum + 32.0;
                temperature = String.valueOf((int)tmpDouble);
            } else {
                temperature = num.toString();
            }
        } else {
            unit = "";
        }
        return temperature + unit;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static int getTemperatureType() {
        RecordStore cityRms = null;
        int type = 1;
        try {
            cityRms = RmsUtility.openRms("TEMPERATURE_TYPE", true);
            RecordEnumeration recordEnu = cityRms.enumerateRecords(null, null, false);
            while (recordEnu.hasNextElement()) {
                recordIdOfTemp = recordEnu.nextRecordId();
                type = BasicFunction.deserialize(cityRms.getRecord(recordIdOfTemp));
            }
        }
        catch (Exception e) {
            System.out.println(e.getMessage());
        }
        finally {
            RmsUtility.closeRmsQuietly(cityRms);
        }
        return type;
    }

    public static String getUnit() {
        String unit = "\u00b0C";
        int type = BasicFunction.getTemperatureType();
        if (type == 2) {
            unit = "\u00b0F";
        }
        return unit;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static int getChargeType() {
        RecordStore chargeRms = null;
        int type = 0;
        String currDate = "";
        try {
            chargeRms = RmsUtility.openRms("CHARGE_TYPE", true);
            RecordEnumeration recordEnu = chargeRms.enumerateRecords(null, null, false);
            while (recordEnu.hasNextElement()) {
                recordIdOfCharte = recordEnu.nextRecordId();
                if (recordIdOfCharte == 1) {
                    GeneralConstants.CHARGE_DATE = currDate = BasicFunction.deserializeString(chargeRms.getRecord(recordIdOfCharte));
                }
                if (recordIdOfCharte != 2) continue;
                type = BasicFunction.deserialize(chargeRms.getRecord(recordIdOfCharte));
            }
            System.out.println("charge type:" + type);
        }
        catch (Exception e) {
            System.out.println(e.getMessage());
        }
        finally {
            RmsUtility.closeRmsQuietly(chargeRms);
        }
        return type;
    }

    public static boolean getValidOfDay(String currDate, String chargeDate) {
        boolean validOfDay = false;
        long diferenceDay = -1L;
        System.out.println("currDate:" + currDate);
        try {
            if (!"".equals(currDate) && currDate != null) {
                String[] currDates = BasicFunction.split(currDate, "/");
                int currYear = Integer.parseInt(currDates[2].trim());
                int currMonth = Integer.parseInt(currDates[0].trim()) - 1;
                int currDay = Integer.parseInt(currDates[1].trim());
                String[] chargeDates = BasicFunction.split(chargeDate, "/");
                int chargeYear = Integer.parseInt(chargeDates[2].trim());
                int chargeMonth = Integer.parseInt(chargeDates[0].trim()) - 1;
                int chargeDay = Integer.parseInt(chargeDates[1].trim());
                Calendar currCalendar = Calendar.getInstance();
                Calendar chargeCalendar = Calendar.getInstance();
                currCalendar.set(5, currDay);
                currCalendar.set(2, currMonth);
                currCalendar.set(1, currYear);
                chargeCalendar.set(5, chargeDay);
                chargeCalendar.set(2, chargeMonth);
                chargeCalendar.set(1, chargeYear);
                diferenceDay = (currCalendar.getTime().getTime() - chargeCalendar.getTime().getTime()) / 86400000L;
            } else {
                diferenceDay = 0L;
            }
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
        if (diferenceDay >= 0L && diferenceDay <= 30L) {
            validOfDay = true;
        }
        System.out.println("diferenceDay:" + diferenceDay);
        return validOfDay;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static ChargeInfo getChargeCode() {
        RecordStore chargeRms = null;
        ChargeInfo chargeInfo = new ChargeInfo();
        try {
            chargeRms = RmsUtility.openRms("CHARGE_TYPE", true);
            RecordEnumeration recordEnu = chargeRms.enumerateRecords(null, null, false);
            while (recordEnu.hasNextElement()) {
                recordIdOfCharte = recordEnu.nextRecordId();
                if (recordIdOfCharte == 1) {
                    chargeInfo.code = BasicFunction.deserializeString(chargeRms.getRecord(recordIdOfCharte));
                }
                if (recordIdOfCharte != 2) continue;
                chargeInfo.addressCode = BasicFunction.deserializeString(chargeRms.getRecord(recordIdOfCharte));
            }
        }
        catch (Exception e) {
            System.out.println(e.getMessage());
        }
        finally {
            RmsUtility.closeRmsQuietly(chargeRms);
        }
        return chargeInfo;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static int initChargeInfo() {
        RecordStore chargeRms = null;
        int type = 0;
        try {
            chargeRms = RmsUtility.openRms("CHARGE_TYPE", true);
            RecordEnumeration recordEnu = chargeRms.enumerateRecords(null, null, false);
            byte[] chargeDate = BasicFunction.serialize("2009-01-01");
            byte[] chargeType = BasicFunction.serialize(0);
            if (recordEnu.numRecords() == 0) {
                chargeRms.addRecord(chargeDate, 0, chargeDate.length);
                chargeRms.addRecord(chargeType, 0, chargeType.length);
            }
        }
        catch (Exception e) {
            System.out.println("charge set exception" + e.getMessage());
        }
        finally {
            RmsUtility.closeRmsQuietly(chargeRms);
        }
        return type;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static int getAggreement() {
        RecordStore aggreementRms = null;
        int type = 0;
        try {
            aggreementRms = RmsUtility.openRms("AGGREEMENT", true);
            RecordEnumeration recordEnu = aggreementRms.enumerateRecords(null, null, false);
            while (recordEnu.hasNextElement()) {
                recordIdOfAggree = recordEnu.nextRecordId();
                System.out.println("recordIdOfAggree = " + recordIdOfAggree + ";aggreement name=" + BasicFunction.deserialize(aggreementRms.getRecord(recordIdOfAggree)));
                type = BasicFunction.deserialize(aggreementRms.getRecord(recordIdOfAggree));
            }
        }
        catch (Exception e) {
            System.out.println(e.getMessage());
        }
        finally {
            RmsUtility.closeRmsQuietly(aggreementRms);
        }
        return type;
    }

    public static boolean isValidHttpUrl(String url) {
        return url != null && url.startsWith("http://");
    }

    public static Image getImageFromStream(String url) {
        Image gotImage = null;
        try {
            if (BasicFunction.isValidHttpUrl(url)) {
                HttpConnection httpConn = ConnectionUtil.getHttpConnection(url, "GET", null);
                gotImage = Image.createImage((InputStream)httpConn.openInputStream());
            }
        }
        catch (Exception e) {
            System.out.println(e);
        }
        return gotImage;
    }

    public static String transformWeekday(String weekday) {
        String chinaWeek = "";
        if ("Tonight".equals(weekday)) {
            chinaWeek = "\u4eca\u5929";
        } else if ("Monday".equals(weekday)) {
            chinaWeek = "\u661f\u671f\u4e00";
        } else if ("Tuesday".equals(weekday)) {
            chinaWeek = "\u661f\u671f\u4e8c";
        } else if ("Wednesday".equals(weekday)) {
            chinaWeek = "\u661f\u671f\u4e09";
        } else if ("Thursday".equals(weekday)) {
            chinaWeek = "\u661f\u671f\u56db";
        } else if ("Friday".equals(weekday)) {
            chinaWeek = "\u661f\u671f\u4e94";
        } else if ("Saturday".equals(weekday)) {
            chinaWeek = "\u661f\u671f\u516d";
        } else if ("Sunday".equals(weekday)) {
            chinaWeek = "\u661f\u671f\u65e5";
        }
        return chinaWeek;
    }

    public static String getScope(String name) {
        String scope = "";
        if ("clothes".equals(name)) {
            scope = "1-8";
        } else if ("comfort".equals(name)) {
            scope = "0-8";
        } else if ("morningexercise".equals(name)) {
            scope = "1-4";
        } else if ("carwashing".equals(name)) {
            scope = "1-4";
        } else if ("coldcatching".equals(name)) {
            scope = "1-4";
        } else if ("airdrying".equals(name)) {
            scope = "1-5";
        }
        return scope;
    }

    public static String getLifeStyleTitle(String name) {
        String title = "";
        if ("clothes".equals(name)) {
            title = "\u7a7f\u8863";
        } else if ("comfort".equals(name)) {
            title = "\u8212\u9002";
        } else if ("morningexercise".equals(name)) {
            title = "\u6668\u7ec3";
        } else if ("carwashing".equals(name)) {
            title = "\u6d17\u8f66";
        } else if ("coldcatching".equals(name)) {
            title = "\u611f\u5192";
        } else if ("airdrying".equals(name)) {
            title = "\u667e\u6652";
        }
        return title;
    }

    public static String formatDate(int plusNum) {
        Calendar calendar = Calendar.getInstance();
        Date currDate = new Date();
        currDate.setTime(currDate.getTime() + (long)(86400000 * plusNum));
        calendar.setTime(currDate);
        int plusDay = calendar.get(5);
        int plusMonth = calendar.get(2) + 1;
        return plusMonth + "/" + plusDay;
    }

    public static String cutString(String original, int maxLength) {
        if (original == null) {
            return "";
        }
        int length = 0;
        StringBuffer strBuffer = new StringBuffer();
        char[] charArray = original.toCharArray();
        for (int i = 0; i < charArray.length; ++i) {
            if (length >= maxLength) {
                strBuffer.append("...");
                break;
            }
            strBuffer.append(charArray[i]);
            ++length;
        }
        return strBuffer.toString();
    }

    public static Vector splitToVector(String original, String regex) {
        if (original == null || regex == null) {
            return new Vector();
        }
        int startIndex = 0;
        Vector<String> v = new Vector<String>();
        int index = 0;
        startIndex = original.indexOf(regex);
        while (startIndex < original.length() && startIndex != -1) {
            String temp = original.substring(index, startIndex);
            v.addElement(temp);
            index = startIndex + regex.length();
            startIndex = original.indexOf(regex, startIndex + regex.length());
        }
        v.addElement(original.substring(index));
        return v;
    }

    public static String[] split(String original, String regex) {
        Vector v = BasicFunction.splitToVector(original, regex);
        String[] str = new String[v.size()];
        for (int i = 0; i < v.size(); ++i) {
            str[i] = (String)v.elementAt(i);
        }
        return str;
    }

    public static String getSMSText() {
        String SMSText = "";
        String platform = System.getProperty("microedition.platform");
        String[] platforms = BasicFunction.split(platform, "/");
        if (platforms.length > 0) {
            SMSText = platforms[0].equals("SonyEricssonU100") ? "99SEPH7001" : (platforms[0].equals("SonyEricssonT715") ? "99SEPH7003" : "99SEPH7002");
        }
        return SMSText;
    }

    public static void main(String[] args) {
        try {
            Calendar calendar = Calendar.getInstance();
            String[] mmsDate = BasicFunction.split("07/30/09", "/");
            int year = Integer.parseInt(mmsDate[2]);
            int month = Integer.parseInt(mmsDate[0]);
            int day = Integer.parseInt(mmsDate[1]);
            calendar.set(5, day);
            calendar.set(2, month);
            calendar.set(1, year);
            Calendar calendar1 = Calendar.getInstance();
            String[] mmsDate1 = BasicFunction.split("07/31/09", "/");
            int year1 = Integer.parseInt(mmsDate1[2]);
            int month1 = Integer.parseInt(mmsDate1[0]);
            int day1 = Integer.parseInt(mmsDate1[1]);
            calendar1.set(5, day1);
            calendar1.set(2, month1);
            calendar1.set(1, year1);
            Date currDate = calendar.getTime();
            Date currDate1 = calendar1.getTime();
            System.out.println("dd:" + calendar1.getTime());
            long diferenceDay = (calendar1.getTime().getTime() - calendar.getTime().getTime()) / 86400000L;
            System.out.println(diferenceDay);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }
}

