/*
 * Decompiled with CFR 0.152.
 */
package com.myweather.util;

import javax.microedition.lcdui.Graphics;
import javax.microedition.lcdui.Image;

public class ImageUtil {
    public static final Image scale(Image srcImage, int newDW, int newDH) {
        int srcW = srcImage.getWidth();
        int srcH = srcImage.getHeight();
        System.gc();
        int newW = newDW;
        int newH = newDH;
        if (srcW / newW > srcH / newH) {
            newH = srcH / (srcW / newW);
        }
        Image tmp = Image.createImage((int)newW, (int)srcH);
        Graphics g = tmp.getGraphics();
        for (int x = 0; x < newW; ++x) {
            g.setClip(x, 0, 1, srcH);
            g.drawImage(srcImage, x - x * srcW / newW, 0, 20);
        }
        System.gc();
        Image dst = Image.createImage((int)newW, (int)newH);
        g = dst.getGraphics();
        for (int y = 0; y < newH; ++y) {
            g.setClip(0, y, newW, 1);
            g.drawImage(tmp, 0, y - y * srcH / newH, 20);
        }
        System.gc();
        return dst;
    }

    public static Image[] splitImage(Image img, int rows, int cols) {
        if (img == null) {
            return null;
        }
        Image[] result = new Image[rows * cols];
        int w = img.getWidth() / cols;
        int h = img.getHeight() / rows;
        for (int i = 0; i < result.length; ++i) {
            result[i] = Image.createImage((Image)img, (int)(i % cols * w), (int)(i / cols * h), (int)w, (int)h, (int)0);
        }
        return result;
    }

    public static Image splitImage(Image img, int rows, int cols, int index) {
        if (img == null) {
            return null;
        }
        Image result = null;
        int w = img.getWidth() / cols;
        int h = img.getHeight() / rows;
        result = Image.createImage((Image)img, (int)(index % cols * w), (int)(index / cols * h), (int)w, (int)h, (int)0);
        return result;
    }

    public static Image resize(Image src, int expectWidth, int expectHeight) {
        int originalHeight;
        Image newImage = null;
        int originalWideth = src.getWidth();
        int rateInt = Math.min(expectWidth * 100 / originalWideth, expectHeight * 100 / (originalHeight = src.getHeight()));
        newImage = rateInt < 100 ? ImageUtil.scale(src, originalWideth * rateInt / 100, originalHeight * rateInt / 100) : src;
        return newImage;
    }
}

