/*
 * Decompiled with CFR 0.152.
 */
package de.enough.polish.browser;

import de.enough.polish.browser.BrowserListener;
import de.enough.polish.browser.HistoryEntry;
import de.enough.polish.browser.ProtocolHandler;
import de.enough.polish.browser.TagHandler;
import de.enough.polish.browser.TagHandlerKey;
import de.enough.polish.browser.protocols.HttpProtocolHandler;
import de.enough.polish.browser.protocols.ResourceProtocolHandler;
import de.enough.polish.io.StringReader;
import de.enough.polish.ui.Container;
import de.enough.polish.ui.Item;
import de.enough.polish.ui.StringItem;
import de.enough.polish.ui.Style;
import de.enough.polish.ui.StyleSheet;
import de.enough.polish.ui.UiAccess;
import de.enough.polish.util.ArrayList;
import de.enough.polish.util.Debug;
import de.enough.polish.util.HashMap;
import de.enough.polish.xml.SimplePullParser;
import de.enough.polish.xml.XmlPullParser;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.Reader;
import java.util.Stack;
import javax.microedition.io.HttpConnection;
import javax.microedition.io.StreamConnection;
import javax.microedition.lcdui.Command;
import javax.microedition.lcdui.Graphics;
import javax.microedition.lcdui.Image;

public abstract class Browser
extends Container
implements Runnable {
    private static final String BROKEN_IMAGE = "resource://broken.png";
    private HashMap imageCache = new HashMap();
    protected String currentDocumentBase = null;
    protected HashMap protocolHandlersByProtocol = new HashMap();
    protected HashMap tagHandlersByTag = new HashMap();
    protected ArrayList tagHandlers = new ArrayList();
    protected Stack history = new Stack();
    private Thread loadingThread;
    private boolean isRunning;
    private boolean isWorking;
    private boolean isCancelRequested;
    private String nextUrl;
    private String nextPostData;
    protected BrowserListener browserListener;
    protected Container currentContainer;
    private Command cmdBack;
    private HistoryEntry scheduledHistoryEntry;
    private String cookie;

    public Browser() {
        this((String[])null, null, (ProtocolHandler[])null, StyleSheet.browserStyle);
    }

    public Browser(Style style) {
        this((String[])null, null, (ProtocolHandler[])null, style);
    }

    public Browser(ProtocolHandler[] protocolHandlers) {
        this(protocolHandlers, StyleSheet.browserStyle);
    }

    public Browser(ProtocolHandler[] protocolHandlers, Style style) {
        this((String[])null, null, protocolHandlers, style);
    }

    public Browser(String[] tagNames, TagHandler[] tagHandlers, ProtocolHandler[] protocolHandlers) {
        this(tagNames, tagHandlers, protocolHandlers, StyleSheet.browserStyle);
    }

    public Browser(String[] tagNames, TagHandler[] tagHandlers, ProtocolHandler[] protocolHandlers, Style style) {
        super(true, style);
        Object handler;
        int i;
        if (tagHandlers != null && tagNames != null && tagNames.length == tagHandlers.length) {
            for (i = 0; i < tagHandlers.length; ++i) {
                handler = tagHandlers[i];
                this.addTagHandler(tagNames[i], (TagHandler)handler);
            }
        }
        if (protocolHandlers != null) {
            for (i = 0; i < protocolHandlers.length; ++i) {
                handler = protocolHandlers[i];
                this.addProtocolHandler((ProtocolHandler)handler);
            }
        }
        this.loadingThread = new Thread(this);
        this.loadingThread.start();
    }

    protected static ProtocolHandler[] getDefaultProtocolHandlers() {
        HashMap httpRequestProperties = new HashMap();
        return new ProtocolHandler[]{new HttpProtocolHandler("http", httpRequestProperties), new HttpProtocolHandler("https", httpRequestProperties), new ResourceProtocolHandler("resource")};
    }

    public void addTagCommand(String tagName, Command command) {
        TagHandler handler = this.getTagHandler(tagName);
        if (handler != null) {
            handler.addTagCommand(tagName, command);
        }
    }

    public void addAttributeCommand(String attributeName, String attributeValue, Command command) {
        this.addAttributeCommand(null, attributeName, attributeValue, command);
    }

    public void addAttributeCommand(String tagName, String attributeName, String attributeValue, Command command) {
        TagHandler handler = this.getTagHandler(tagName);
        if (handler != null) {
            handler.addAttributeCommand(tagName, attributeName, attributeValue, command);
        }
    }

    public void addProtocolHandler(ProtocolHandler handler) {
        this.protocolHandlersByProtocol.put(handler.getProtocolName(), handler);
    }

    public void addProtocolHandler(String protocolName, ProtocolHandler handler) {
        this.protocolHandlersByProtocol.put(protocolName, handler);
    }

    protected ProtocolHandler getProtocolHandler(String protocolName) {
        return (ProtocolHandler)this.protocolHandlersByProtocol.get(protocolName);
    }

    protected ProtocolHandler getProtocolHandlerForURL(String url) throws IOException {
        int pos;
        if (url.length() > 1 && url.charAt(0) == '/') {
            url = this.protocolAndHostOf(this.currentDocumentBase) + url;
        }
        if ((pos = url.indexOf(58)) == -1) {
            throw new IOException("malformed url");
        }
        String protocol = url.substring(0, pos);
        ProtocolHandler handler = (ProtocolHandler)this.protocolHandlersByProtocol.get(protocol);
        if (handler == null) {
            throw new IOException("protocol handler not found");
        }
        return handler;
    }

    public void addTagHandler(String tagName, TagHandler handler) {
        this.tagHandlersByTag.put(new TagHandlerKey(tagName.toLowerCase()), handler);
        if (!this.tagHandlers.contains(handler)) {
            this.tagHandlers.add(handler);
        }
    }

    public void addTagHandler(String tagName, String attributeName, String attributeValue, TagHandler handler) {
        TagHandlerKey key = new TagHandlerKey(tagName, attributeName, attributeValue);
        this.tagHandlersByTag.put(key, handler);
        if (!this.tagHandlers.contains(handler)) {
            this.tagHandlers.add(handler);
        }
    }

    public TagHandler getTagHandler(String tagName) {
        TagHandlerKey key = new TagHandlerKey(tagName);
        return (TagHandler)this.tagHandlersByTag.get(key);
    }

    public TagHandler getTagHandler(String tagName, String attributeName, String attributeValue) {
        TagHandlerKey key = new TagHandlerKey(tagName, attributeName, attributeValue);
        return (TagHandler)this.tagHandlersByTag.get(key);
    }

    public void openContainer(Style containerStyle) {
        Container previousContainer = this.currentContainer;
        if (containerStyle == null) {
            containerStyle = previousContainer != null ? previousContainer.getStyle() : this.getStyle();
        }
        this.openContainer(new Container(false, containerStyle));
    }

    public void openContainer(Container container) {
        Container previousContainer = this.currentContainer;
        if (previousContainer != null) {
            container.setParent(previousContainer);
        } else {
            container.setParent(this);
        }
        this.currentContainer = container;
    }

    public Container closeContainer() {
        if (this.currentContainer == null) {
            return null;
        }
        Container current = this.currentContainer;
        Container previousContainer = (Container)current.getParent();
        this.currentContainer = previousContainer == UiAccess.cast(this) ? null : previousContainer;
        if (current.size() == 1) {
            Item item = current.get(0);
            if (item != null) {
                if (current.getStyle() != null) {
                    item.setStyle(current.getStyle());
                }
                this.add(item);
            }
        } else {
            this.add(current);
        }
        return previousContainer;
    }

    private void closeContainers() {
        while (this.currentContainer != null) {
            this.closeContainer();
        }
    }

    private void parsePage(SimplePullParser parser) {
        this.clear();
        this.imageCache.clear();
        System.gc();
        this.parsePartialPage(parser);
        Container o = this.currentContainer;
        while (o != null && o != this) {
            this.closeContainer();
            o = this.currentContainer;
        }
    }

    private void parsePartialPage(SimplePullParser parser) {
        HashMap attributeMap = new HashMap();
        while (parser.next() != 1) {
            int type = parser.getType();
            if (type == 2 || type == 3) {
                Container container;
                boolean openingTag = type == 2;
                attributeMap.clear();
                TagHandler handler = this.getTagHandler(parser, attributeMap);
                if (handler == null) continue;
                String styleName = (String)attributeMap.get("class");
                Style tagStyle = null;
                if (styleName != null) {
                    tagStyle = StyleSheet.getStyle(styleName);
                }
                if (tagStyle == null || styleName == null) {
                    styleName = (String)attributeMap.get("id");
                }
                if (styleName != null) {
                    tagStyle = StyleSheet.getStyle(styleName);
                }
                if ((container = this.currentContainer) == null) {
                    container = this;
                }
                handler.handleTag(container, parser, parser.getName(), openingTag, attributeMap, tagStyle);
                continue;
            }
            if (type == 4) {
                if ("http://digg.com/general_sciences/Rational_or_Random_Model_Shows_How_People_Send_E_Mail".equals(parser.getText().trim())) {
                    try {
                        throw new RuntimeException();
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                        System.out.println("name: " + parser.getName());
                        System.out.println("type: " + type);
                        System.out.println("start=2, end=3");
                    }
                }
                this.handleText(parser.getText().trim());
                continue;
            }
            Debug.debug("error", "de.enough.polish.browser.Browser", 533, (Object)("unknown type: " + type + ", name="), parser.getName());
        }
    }

    private TagHandler getTagHandler(SimplePullParser parser, HashMap attributeMap) {
        TagHandlerKey key;
        TagHandler handler = null;
        String name = parser.getName().toLowerCase();
        for (int i = 0; i < parser.getAttributeCount(); ++i) {
            String attributeName = parser.getAttributeName(i).toLowerCase();
            String attributeValue = parser.getAttributeValue(i);
            attributeMap.put(attributeName, attributeValue);
            key = new TagHandlerKey(name, attributeName, attributeValue);
            handler = (TagHandler)this.tagHandlersByTag.get(key);
            if (handler != null) break;
        }
        if (handler == null) {
            key = new TagHandlerKey(name);
            handler = (TagHandler)this.tagHandlersByTag.get(key);
        }
        return handler;
    }

    protected abstract void handleText(String var1);

    public void add(Item item) {
        if (this.currentContainer != null) {
            this.currentContainer.add(item);
        } else {
            super.add(item);
        }
    }

    public void loadPage(Reader reader) throws IOException {
        XmlPullParser xmlReader = new XmlPullParser(reader, false);
        xmlReader.relaxed = true;
        this.parsePage(xmlReader);
    }

    public void loadPartialPage(Reader reader) throws IOException {
        XmlPullParser xmlReader = new XmlPullParser(reader, false);
        xmlReader.relaxed = true;
        this.parsePartialPage(xmlReader);
    }

    protected String protocolAndHostOf(String url) {
        if ("resource://".regionMatches(true, 0, url, 0, 11)) {
            return "resource://";
        }
        if ("http://".regionMatches(true, 0, url, 0, 7)) {
            int hostStart = url.indexOf("//");
            int hostEnd = url.indexOf("/", hostStart += 2);
            if (hostEnd != -1) {
                return url.substring(0, hostEnd);
            }
            return url;
        }
        return url;
    }

    public String makeAbsoluteURL(String url) {
        if (url.indexOf("://") != -1) {
            return url;
        }
        if (url.startsWith("/")) {
            if ("resource://".regionMatches(true, 0, this.currentDocumentBase, 0, 11)) {
                return this.protocolAndHostOf(this.currentDocumentBase) + url.substring(1);
            }
            return this.protocolAndHostOf(this.currentDocumentBase) + url;
        }
        String baseUrl = this.currentDocumentBase;
        if (baseUrl == null) {
            return url;
        }
        String prefix = this.protocolAndPathOf(baseUrl);
        if (prefix.endsWith("/")) {
            return prefix + url;
        }
        return prefix + "/" + url;
    }

    public void loadPage(String document) {
        try {
            this.loadPage(new StringReader(document));
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    public void loadPage(InputStream in) throws IOException {
        this.loadPage(in, null);
    }

    public void loadPage(InputStream in, String encoding) throws IOException {
        if (in == null) {
            throw new IOException("no input stream");
        }
        InputStreamReader reader = encoding == null ? new InputStreamReader(in) : new InputStreamReader(in, encoding);
        this.loadPage(reader);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Image loadImageInternal(String url) {
        Image image = (Image)this.imageCache.get(url);
        if (image == null) {
            StreamConnection connection = null;
            InputStream is = null;
            try {
                int bytesRead;
                this.notifyDownloadStart(url);
                ProtocolHandler handler = this.getProtocolHandlerForURL(url);
                connection = handler.getConnection(url);
                is = connection.openInputStream();
                if (is == null) {
                    Image image2 = null;
                    return image2;
                }
                ByteArrayOutputStream bos = new ByteArrayOutputStream();
                byte[] buf = new byte[1024];
                do {
                    if ((bytesRead = is.read(buf)) <= 0) continue;
                    bos.write(buf, 0, bytesRead);
                } while (bytesRead >= 0);
                this.notifyDownloadEnd();
                buf = bos.toByteArray();
                image = Image.createImage((byte[])buf, (int)0, (int)buf.length);
                this.imageCache.put(url, image);
                Image image3 = image;
                return image3;
            }
            catch (Exception e) {
                Debug.debug("error", "de.enough.polish.browser.Browser", 823, (Object)("Unable to load image " + url), e);
                Image image4 = null;
                return image4;
            }
            finally {
                if (is != null) {
                    try {
                        is.close();
                    }
                    catch (Exception e) {
                        Debug.debug("error", "de.enough.polish.browser.Browser", 832, (Object)"unable to close inputstream ", e);
                    }
                }
                if (connection != null) {
                    try {
                        connection.close();
                        connection = null;
                    }
                    catch (Exception e) {
                        Debug.debug("error", "de.enough.polish.browser.Browser", 843, (Object)"unable to close connection ", e);
                    }
                }
            }
        }
        return image;
    }

    public Image loadImage(String url) {
        Image image = this.loadImageInternal(url);
        if (image == null) {
            image = this.loadImageInternal(BROKEN_IMAGE);
        }
        if (image == null) {
            image = Image.createImage((int)10, (int)10);
            Graphics g = image.getGraphics();
            g.setColor(0xFFFFFF);
            g.fillRect(0, 0, 10, 10);
            g.setColor(0xFF0000);
            g.drawLine(0, 0, 10, 10);
            g.drawLine(0, 10, 10, 0);
        }
        return image;
    }

    protected String protocolAndPathOf(String url) {
        int end = url.indexOf(63);
        if (end == -1) {
            end = url.length() - 1;
        }
        int hostStart = url.indexOf("//");
        hostStart += 2;
        int lastSlash = url.lastIndexOf(47, end);
        if ("resource://".regionMatches(true, 0, url, 0, 11)) {
            if (lastSlash == -1 || lastSlash <= hostStart) {
                return "resource://";
            }
            return url.substring(0, lastSlash);
        }
        if (lastSlash == -1 || lastSlash <= hostStart) {
            return url;
        }
        return url.substring(0, lastSlash);
    }

    public boolean handleCommand(Command command) {
        TagHandler handler;
        Object[] handlers = this.tagHandlers.getInternalArray();
        for (int i = 0; i < handlers.length && (handler = (TagHandler)handlers[i]) != null; ++i) {
            if (!handler.handleCommand(command)) continue;
            return true;
        }
        return super.handleCommand(command);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void goImpl(String url, String postData) {
        String previousDocumentBase = this.currentDocumentBase;
        StreamConnection connection = null;
        InputStream is = null;
        try {
            ProtocolHandler handler = this.getProtocolHandlerForURL(url);
            this.currentDocumentBase = url;
            connection = handler.getConnection(url);
            if (connection != null) {
                boolean isHttpConnection = connection instanceof HttpConnection;
                HttpConnection httpConnection = null;
                if (isHttpConnection) {
                    httpConnection = (HttpConnection)connection;
                    if (this.cookie != null) {
                        httpConnection.setRequestProperty("cookie", this.cookie);
                    }
                }
                if (postData != null && isHttpConnection) {
                    httpConnection.setRequestMethod("POST");
                    httpConnection.setRequestProperty("Content-Type", "application/x-www-form-urlencoded");
                    OutputStream os = connection.openOutputStream();
                    os.write(postData.getBytes());
                    os.close();
                }
                is = connection.openInputStream();
                this.notifyPageStart(url);
                String contentEncoding = null;
                if (isHttpConnection) {
                    String newCookie;
                    contentEncoding = httpConnection.getEncoding();
                    if (contentEncoding == null) {
                        contentEncoding = httpConnection.getHeaderField("Content-Encoding");
                    }
                    if ((newCookie = httpConnection.getHeaderField("Set-cookie")) != null) {
                        int semicolonPos = newCookie.indexOf(59);
                        if (semicolonPos != -1) {
                            newCookie = newCookie.substring(0, semicolonPos);
                        }
                        this.cookie = newCookie;
                    }
                }
                if (contentEncoding == null) {
                    contentEncoding = "UTF-8";
                }
                this.loadPage(is, contentEncoding);
                this.notifyPageEnd();
            }
        }
        catch (Exception e) {
            Debug.debug("error", "de.enough.polish.browser.Browser", 1020, (Object)("Unable to load page " + url), e);
            this.currentDocumentBase = previousDocumentBase;
            this.notifyPageError(url, e);
            this.closeContainers();
        }
        finally {
            HistoryEntry entry;
            if (is != null) {
                try {
                    is.close();
                }
                catch (Exception e) {
                    Debug.debug("error", "de.enough.polish.browser.Browser", 1030, (Object)"unable to close inputstream ", e);
                }
            }
            if (connection != null) {
                try {
                    connection.close();
                }
                catch (Exception e) {
                    Debug.debug("error", "de.enough.polish.browser.Browser", 1038, (Object)"Unable to close connection ", e);
                }
            }
            if ((entry = this.scheduledHistoryEntry) != null) {
                this.focus(entry.getFocusedIndex());
                this.setScrollYOffset(entry.getScrollOffset(), false);
                this.scheduledHistoryEntry = null;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void run() {
        try {
            Thread.sleep(100L);
        }
        catch (InterruptedException e) {
            // empty catch block
        }
        this.isRunning = true;
        while (this.isRunning) {
            block16: {
                try {
                    if (!this.isRunning || this.nextUrl == null) break block16;
                    this.isWorking = true;
                    String url = this.nextUrl;
                    String postData = this.nextPostData;
                    this.nextUrl = null;
                    this.nextPostData = null;
                    if (!this.isCancelRequested) {
                        try {
                            this.goImpl(url, postData);
                        }
                        catch (OutOfMemoryError e) {
                            StringItem item = new StringItem(null, "parsing stopped", StyleSheet.browsertextStyle);
                            this.add(item);
                        }
                    }
                    this.isWorking = false;
                    this.repaint();
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
            if (this.isCancelRequested) {
                this.isWorking = false;
                this.repaint();
                this.isCancelRequested = false;
                this.nextUrl = null;
                this.nextPostData = null;
                this.loadPage("Request canceled");
            }
            try {
                this.isWorking = false;
                Thread e = this.loadingThread;
                synchronized (e) {
                    this.loadingThread.wait();
                }
            }
            catch (InterruptedException interruptedException) {
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void schedule(String url, String postData) {
        this.nextUrl = url;
        this.nextPostData = postData;
        Thread thread = this.loadingThread;
        synchronized (thread) {
            this.loadingThread.notify();
        }
    }

    public void cancel() {
        this.isCancelRequested = true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void requestStop() {
        this.isRunning = false;
        Thread thread = this.loadingThread;
        synchronized (thread) {
            this.loadingThread.notify();
        }
    }

    public boolean isRunning() {
        return this.isRunning;
    }

    public boolean isCanceled() {
        return this.isCancelRequested;
    }

    public boolean isWorking() {
        return this.isWorking;
    }

    public void go(String url) {
        if (this.currentDocumentBase != null) {
            this.history.push(new HistoryEntry(this.currentDocumentBase, this.getFocusedIndex(), this.getScrollYOffset()));
            if (this.cmdBack != null && this.history.size() == 1 && this.getScreen() != null) {
                this.getScreen().addCommand(this.cmdBack);
            }
        }
        this.schedule(url, null);
    }

    public void go(String url, String postData) {
        if (this.currentDocumentBase != null) {
            this.history.push(this.currentDocumentBase);
            if (this.cmdBack != null && this.history.size() == 1 && this.getScreen() != null) {
                this.getScreen().addCommand(this.cmdBack);
            }
        }
        this.schedule(url, postData);
    }

    public void go(int historySteps) {
        HistoryEntry entry = null;
        while (historySteps > 0 && this.history.size() > 0) {
            entry = (HistoryEntry)this.history.pop();
            --historySteps;
        }
        if (entry != null) {
            this.scheduledHistoryEntry = entry;
            this.schedule(entry.getUrl(), null);
            if (this.history.size() == 0 && this.cmdBack != null && this.getScreen() != null) {
                this.getScreen().removeCommand(this.cmdBack);
            }
        }
    }

    public void followLink() {
        Item item = this.getFocusedItem();
        String href = (String)item.getAttribute("href");
        if (href != null) {
            this.go(this.makeAbsoluteURL(href));
        }
    }

    public void setBackCommand(Command cmdBack) {
        if (this.cmdBack != null && this.getScreen() != null) {
            this.getScreen().removeCommand(this.cmdBack);
        }
        this.cmdBack = cmdBack;
    }

    public boolean goBack() {
        if (this.history.size() > 0) {
            this.go(1);
            return true;
        }
        return false;
    }

    public boolean canGoBack() {
        return this.history.size() > 0;
    }

    public void clearHistory() {
        this.history.removeAllElements();
        this.imageCache.clear();
        this.currentDocumentBase = null;
        if (this.cmdBack != null && this.getScreen() != null) {
            this.getScreen().removeCommand(this.cmdBack);
        }
    }

    protected void notifyPageError(String url, Exception e) {
        if (this.browserListener != null) {
            this.browserListener.notifyPageError(url, e);
        }
    }

    protected void notifyPageStart(String url) {
        if (this.browserListener != null) {
            this.browserListener.notifyPageStart(url);
        }
    }

    protected void notifyPageEnd() {
        if (this.browserListener != null) {
            this.browserListener.notifyPageEnd();
        }
    }

    protected void notifyDownloadStart(String url) {
        if (this.browserListener != null) {
            this.browserListener.notifyDownloadStart(url);
        }
    }

    protected void notifyDownloadEnd() {
        if (this.browserListener != null) {
            this.browserListener.notifyDownloadEnd();
        }
    }

    public BrowserListener getBrowserListener() {
        return this.browserListener;
    }

    public void setBrowserListener(BrowserListener browserListener) {
        this.browserListener = browserListener;
    }
}

