/*
 * Decompiled with CFR 0.152.
 */
package de.enough.polish.browser;

import de.enough.polish.browser.Browser;
import de.enough.polish.ui.Container;
import de.enough.polish.ui.Item;
import de.enough.polish.ui.Style;
import de.enough.polish.util.HashMap;
import de.enough.polish.xml.SimplePullParser;
import javax.microedition.lcdui.Command;

public abstract class TagHandler {
    private HashMap commandsByKey;

    public abstract void register(Browser var1);

    public abstract boolean handleTag(Container var1, SimplePullParser var2, String var3, boolean var4, HashMap var5, Style var6);

    public boolean handleCommand(Command command) {
        return false;
    }

    public void addTagCommand(String tagName, Command command) {
        this.addCommandImpl(tagName, command);
    }

    public void addAttributeCommand(String tagName, String attributeName, String attributeValue, Command command) {
        if (tagName != null && attributeName != null && attributeValue != null) {
            this.addCommandImpl(tagName + attributeName + attributeValue, command);
        } else if (attributeName != null && attributeValue != null) {
            this.addCommandImpl(tagName + attributeName + attributeValue, command);
        }
    }

    private void addCommandImpl(String key, Command command) {
        Command[] newValue;
        Command[] existing = null;
        if (this.commandsByKey == null) {
            this.commandsByKey = new HashMap();
        } else {
            existing = (Command[])this.commandsByKey.get(key);
        }
        if (existing == null) {
            newValue = new Command[]{command};
        } else {
            newValue = new Command[existing.length + 1];
            System.arraycopy(existing, 0, newValue, 0, existing.length);
            newValue[existing.length] = command;
        }
        this.commandsByKey.put(key, newValue);
    }

    protected void addCommands(String tagName, Item item) {
        this.addCommandsImpl(tagName, item);
    }

    protected void addCommands(String tagName, String attributeName, String attributeValue, Item item) {
        if (tagName != null) {
            this.addCommandsImpl(tagName, item);
        }
        if (tagName != null && attributeName != null && attributeValue != null) {
            this.addCommandsImpl(tagName + attributeName + attributeValue, item);
        } else if (attributeName != null && attributeValue != null) {
            this.addCommandsImpl(tagName + attributeName + attributeValue, item);
        }
    }

    private void addCommandsImpl(String key, Item item) {
        if (this.commandsByKey == null) {
            return;
        }
        Command[] commands = (Command[])this.commandsByKey.get(key);
        if (commands != null) {
            for (int i = 0; i < commands.length; ++i) {
                Command command = commands[i];
                item.addCommand(command);
            }
        }
    }

    protected Command[] getCommandsForTag(String tag) {
        return (Command[])this.commandsByKey.get(tag);
    }
}

