/*
 * Decompiled with CFR 0.152.
 */
package de.enough.polish.browser.html;

import de.enough.polish.browser.Browser;
import de.enough.polish.browser.ProtocolHandler;
import de.enough.polish.browser.html.FormListener;
import de.enough.polish.browser.html.HtmlTagHandler;
import de.enough.polish.ui.StringItem;
import de.enough.polish.ui.Style;
import de.enough.polish.ui.StyleSheet;
import de.enough.polish.util.StringTokenizer;
import de.enough.polish.util.TextUtil;

public class HtmlBrowser
extends Browser {
    private HtmlTagHandler htmlTagHandler;

    public HtmlBrowser() {
        this(StyleSheet.browserStyle);
    }

    public HtmlBrowser(Style style) {
        this(new HtmlTagHandler(), HtmlBrowser.getDefaultProtocolHandlers(), style);
    }

    public HtmlBrowser(HtmlTagHandler tagHandler, ProtocolHandler[] protocolHandlers) {
        this(tagHandler, protocolHandlers, StyleSheet.browserStyle);
    }

    public HtmlBrowser(HtmlTagHandler tagHandler, ProtocolHandler[] protocolHandlers, Style style) {
        super(protocolHandlers, style);
        tagHandler.register(this);
        this.htmlTagHandler = tagHandler;
    }

    public void setFormListener(FormListener listener) {
        this.htmlTagHandler.setFormListener(listener);
    }

    protected void handleText(String text) {
        if (text.length() > 0) {
            StringTokenizer st = new StringTokenizer(text, " \n\t");
            while (st.hasMoreTokens()) {
                String str = st.nextToken();
                str = TextUtil.replace(str, "&nbsp;", " ");
                StringItem stringItem = null;
                stringItem = this.htmlTagHandler.textStyle != null ? new StringItem(null, str, this.htmlTagHandler.textStyle) : (this.htmlTagHandler.textBold && this.htmlTagHandler.textItalic ? new StringItem(null, str, StyleSheet.browsertextbolditalicStyle) : (this.htmlTagHandler.textBold ? new StringItem(null, str, StyleSheet.browsertextboldStyle) : (this.htmlTagHandler.textItalic ? new StringItem(null, str, StyleSheet.browsertextitalicStyle) : new StringItem(null, str, StyleSheet.browsertextStyle))));
                this.add(stringItem);
            }
        }
    }
}

