/*
 * Decompiled with CFR 0.152.
 */
package de.enough.polish.browser.rss;

import de.enough.polish.browser.html.HtmlTagHandler;
import de.enough.polish.browser.rss.RssBrowser;
import de.enough.polish.browser.rss.RssItem;
import de.enough.polish.browser.rss.RssTagHandler;
import de.enough.polish.ui.Alert;
import de.enough.polish.ui.Item;
import de.enough.polish.ui.ItemCommandListener;
import de.enough.polish.ui.MasterCanvas;
import de.enough.polish.ui.StyleSheet;
import de.enough.polish.ui.UiAccess;
import javax.microedition.lcdui.AlertType;
import javax.microedition.lcdui.Command;
import javax.microedition.lcdui.CommandListener;
import javax.microedition.lcdui.Displayable;

public class DefaultRssItemCommandListener
implements CommandListener,
ItemCommandListener {
    private RssBrowser rssBrowser;
    private CommandListener commandListener;
    private String url;

    public void setRssBrowser(RssBrowser rssBrowser) {
        this.rssBrowser = rssBrowser;
    }

    public void setCommandListener(CommandListener commandListener) {
        this.commandListener = commandListener;
    }

    public void commandAction(Command command, Displayable displayable) {
        if (command == RssTagHandler.CMD_GO_TO_ARTICLE) {
            this.rssBrowser.go(this.url);
            this.url = null;
            MasterCanvas.setCurrent(StyleSheet.display, (Displayable)this.rssBrowser.getScreen());
        } else if (command == HtmlTagHandler.CMD_BACK) {
            this.rssBrowser.goBack();
            MasterCanvas.setCurrent(StyleSheet.display, (Displayable)this.rssBrowser.getScreen());
        }
    }

    public void commandAction(Command command, Item item) {
        if (command == RssTagHandler.CMD_RSS_ITEM_SELECT) {
            RssItem rssItem = (RssItem)UiAccess.getAttribute(item, (Object)"RSS_ITEM");
            if (rssItem != null && StyleSheet.display != null) {
                Alert alert = new Alert(rssItem.getTitle(), rssItem.getDescription(), null, AlertType.INFO, StyleSheet.rssdescriptionalertStyle);
                alert.setTimeout(-2);
                alert.addCommand(RssTagHandler.CMD_GO_TO_ARTICLE);
                alert.addCommand(HtmlTagHandler.CMD_BACK);
                alert.setCommandListener(this);
                MasterCanvas.setCurrent(StyleSheet.display, (Displayable)alert);
                this.url = rssItem.getLink();
            }
        } else {
            this.rssBrowser.handleCommand(command);
        }
    }
}

