/*
 * Decompiled with CFR 0.152.
 */
package de.enough.polish.event;

import de.enough.polish.ui.Item;
import de.enough.polish.ui.ItemCommandListener;
import de.enough.polish.util.ArrayList;
import de.enough.polish.util.Debug;
import javax.microedition.lcdui.Command;

public class AsynchronousItemCommandListener
implements Runnable,
ItemCommandListener {
    private final ItemCommandListener parent;
    private final ArrayList commands;
    private final ArrayList items;
    private boolean isStopRequested;
    private boolean isWorking;

    public AsynchronousItemCommandListener(ItemCommandListener parent) {
        if (parent == null) {
            throw new IllegalArgumentException();
        }
        this.parent = parent;
        this.commands = new ArrayList();
        this.items = new ArrayList();
        Thread thread = new Thread(this);
        thread.start();
    }

    public void requestStop() {
        this.isStopRequested = true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void run() {
        while (!this.isStopRequested) {
            AsynchronousItemCommandListener asynchronousItemCommandListener = this;
            synchronized (asynchronousItemCommandListener) {
                if (this.commands.size() == 0) {
                    this.isWorking = false;
                    try {
                        this.wait();
                    }
                    catch (InterruptedException e) {
                        // empty catch block
                    }
                }
                this.isWorking = true;
            }
            while (this.commands.size() > 0) {
                Command cmd = null;
                Item item = null;
                AsynchronousItemCommandListener asynchronousItemCommandListener2 = this;
                synchronized (asynchronousItemCommandListener2) {
                    cmd = (Command)this.commands.remove(0);
                    item = (Item)this.items.remove(0);
                }
                try {
                    this.parent.commandAction(cmd, item);
                }
                catch (Throwable e) {
                    Debug.debug("error", "de.enough.polish.event.AsynchronousItemCommandListener", 111, (Object)("Unable to process cmd " + cmd.getLabel() + " for item " + item), e);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void commandAction(Command cmd, Item item) {
        AsynchronousItemCommandListener asynchronousItemCommandListener = this;
        synchronized (asynchronousItemCommandListener) {
            if (this.isWorking) {
                WorkerThread thread = new WorkerThread(cmd, item);
                thread.start();
            } else {
                this.commands.add(cmd);
                this.items.add(item);
                this.notify();
            }
        }
    }

    class WorkerThread
    extends Thread {
        private Command command;
        private Item item;

        public WorkerThread(Command command, Item item) {
            this.command = command;
            this.item = item;
        }

        public void run() {
            AsynchronousItemCommandListener.this.parent.commandAction(this.command, this.item);
        }
    }
}

