/*
 * Decompiled with CFR 0.152.
 */
package de.enough.polish.event;

import de.enough.polish.event.EventListener;
import de.enough.polish.util.Debug;
import java.util.Hashtable;

public class EventManager {
    public static final String EVENT_PRESSED = "pressed";
    private static EventManager INSTANCE = new EventManager();
    private final Hashtable eventListenersByEvent = new Hashtable();

    private EventManager() {
    }

    public static EventManager getInstance() {
        return INSTANCE;
    }

    public void triggerEventStart(String name, Object source, Object data) {
        EventListener[] listeners = (EventListener[])this.eventListenersByEvent.get(name);
        if (listeners != null) {
            for (int i = 0; i < listeners.length; ++i) {
                EventListener listener = listeners[i];
                try {
                    listener.handleEventStart(name, source, data);
                    continue;
                }
                catch (Exception e) {
                    Debug.debug("error", "de.enough.polish.event.EventManager", 77, (Object)("Unable to forward event " + name + " to " + listener), e);
                }
            }
        }
    }

    public void triggerEventEnd(String name, Object source, Object data) {
        EventListener[] listeners = (EventListener[])this.eventListenersByEvent.get(name);
        if (listeners != null) {
            for (int i = 0; i < listeners.length; ++i) {
                EventListener listener = listeners[i];
                try {
                    listener.handleEventEnd(name, source, data);
                    continue;
                }
                catch (Exception e) {
                    Debug.debug("error", "de.enough.polish.event.EventManager", 98, (Object)("Unable to forward event " + name + " to " + listener), e);
                }
            }
        }
    }

    public void addEventListener(String eventName, EventListener listener) {
        EventListener[] listeners = (EventListener[])this.eventListenersByEvent.get(eventName);
        if (listeners == null) {
            this.eventListenersByEvent.put(eventName, new EventListener[]{listener});
        } else {
            EventListener[] newListeners = new EventListener[listeners.length + 1];
            System.arraycopy(listeners, 0, newListeners, 0, listeners.length);
            newListeners[listeners.length] = listener;
            this.eventListenersByEvent.put(eventName, newListeners);
        }
    }
}

