/*
 * Decompiled with CFR 0.152.
 */
package de.enough.polish.log;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;

public class LogEntry {
    static final int VERSION = 100;
    public final String className;
    public final long time;
    public final String level;
    public final String message;
    public final int lineNumber;
    public final String exception;
    public final String thread;
    private byte[] data;

    public LogEntry(String className, int lineNumber, long time, String level, String message, String exception) {
        this(className, lineNumber, time, level, message, exception, Thread.currentThread().getName());
    }

    protected LogEntry(String className, int lineNumber, long time, String level, String message, String exception, String threadName) {
        if (className == null) {
            className = "";
        }
        if (level == null) {
            level = "";
        }
        if (message == null) {
            message = "";
        }
        if (exception == null) {
            exception = "";
        }
        if (threadName == null) {
            threadName = Thread.currentThread().toString();
        }
        this.className = className;
        this.lineNumber = lineNumber;
        this.time = time;
        this.level = level;
        this.message = message;
        this.exception = exception;
        this.thread = threadName;
    }

    public byte[] toByteArray() throws IOException {
        if (this.data == null) {
            ByteArrayOutputStream byteOut = new ByteArrayOutputStream();
            DataOutputStream out = new DataOutputStream(byteOut);
            this.write(out);
            out.close();
            byteOut.close();
            this.data = byteOut.toByteArray();
        }
        return this.data;
    }

    public String toString() {
        StringBuffer buffer = new StringBuffer();
        buffer.append("[").append(this.level).append("] ");
        buffer.append("{").append(this.thread).append("} ");
        buffer.append("<").append(this.time).append(" ms> ");
        buffer.append(this.className).append(" (").append(this.lineNumber).append("): ");
        buffer.append(this.message);
        if (this.exception.length() > 0) {
            buffer.append("/").append(this.exception);
        }
        return buffer.toString();
    }

    public void write(DataOutputStream out) throws IOException {
        out.writeInt(100);
        out.writeUTF(this.level);
        out.writeLong(this.time);
        out.writeUTF(this.className);
        out.writeInt(this.lineNumber);
        out.writeUTF(this.message);
        out.writeUTF(this.exception);
        out.writeUTF(this.thread);
    }

    public static LogEntry newLogEntry(byte[] data) throws IOException {
        ByteArrayInputStream byteIn = new ByteArrayInputStream(data);
        DataInputStream in = new DataInputStream(byteIn);
        LogEntry entry = LogEntry.newLogEntry(in);
        in.close();
        return entry;
    }

    public static LogEntry newLogEntry(DataInputStream in) throws IOException {
        int version = in.readInt();
        if (version > 100) {
            throw new IOException("Unable to read new log entry format, supported version is [100], required version is [" + version + "].");
        }
        String level = in.readUTF();
        long time = in.readLong();
        String className = in.readUTF();
        int lineNumber = in.readInt();
        String message = in.readUTF();
        String exception = in.readUTF();
        String thread = in.readUTF();
        return new LogEntry(className, lineNumber, time, level, message, exception, thread);
    }
}

