/*
 * Decompiled with CFR 0.152.
 */
package de.enough.polish.ui;

import de.enough.polish.ui.ClippingRegion;
import de.enough.polish.ui.Item;
import de.enough.polish.ui.MasterCanvas;
import de.enough.polish.ui.Screen;
import de.enough.polish.ui.StyleSheet;
import de.enough.polish.util.ArrayList;
import de.enough.polish.util.Debug;
import javax.microedition.lcdui.Displayable;

public class AnimationThread
extends Thread {
    public static final int ANIMATION_INTERVAL = 100;
    private static final int SLEEP_INTERVAL = 300;
    protected static boolean releaseResourcesOnScreenChange;
    private static ArrayList animationList;
    private static final long ANIMATION_TIMEOUT = 180000L;

    public AnimationThread() {
        super("AnimationThread");
    }

    public void run() {
        long sleeptime = 100L;
        ClippingRegion repaintRegion = new ClippingRegion();
        while (true) {
            try {
                while (true) {
                    Thread.sleep(sleeptime);
                    Screen screen = StyleSheet.currentScreen;
                    if (screen != null && MasterCanvas.isDisplayableShown((Displayable)screen)) {
                        Displayable d;
                        long currentTime = System.currentTimeMillis();
                        if (currentTime - screen.lastInteractionTime < 180000L) {
                            screen.animate(currentTime, repaintRegion);
                            if (animationList != null) {
                                Item item;
                                Object[] animationItems = animationList.getInternalArray();
                                for (int i = 0; i < animationItems.length && (item = (Item)animationItems[i]) != null; ++i) {
                                    item.animate(currentTime, repaintRegion);
                                }
                            }
                            if (repaintRegion.containsRegion()) {
                                screen.requestRepaint(repaintRegion.getX(), repaintRegion.getY(), repaintRegion.getWidth(), repaintRegion.getHeight());
                                repaintRegion.reset();
                                sleeptime = 100L;
                            }
                        }
                        if (!releaseResourcesOnScreenChange || (d = MasterCanvas.getCurrent(StyleSheet.display)) == screen) continue;
                        StyleSheet.currentScreen = null;
                        continue;
                    }
                    if (releaseResourcesOnScreenChange) {
                        StyleSheet.releaseResources();
                        releaseResourcesOnScreenChange = false;
                    }
                    sleeptime = 300L;
                }
            }
            catch (InterruptedException e) {
                continue;
            }
            catch (Throwable e) {
                Debug.debug("error", "de.enough.polish.ui.AnimationThread", 149, (Object)"unable to animate screen", e);
                continue;
            }
            break;
        }
    }

    public static void addAnimationItem(Item item) {
        if (animationList == null) {
            animationList = new ArrayList();
        }
        if (!animationList.contains(item)) {
            animationList.add(item);
        }
    }

    public static void removeAnimationItem(Item item) {
        if (animationList != null) {
            animationList.remove(item);
        }
    }
}

