/*
 * Decompiled with CFR 0.152.
 */
package de.enough.polish.ui;

import de.enough.polish.ui.Item;
import de.enough.polish.ui.Screen;
import de.enough.polish.ui.Style;
import de.enough.polish.ui.TextEffect;
import de.enough.polish.util.RgbImage;
import javax.microedition.lcdui.Font;
import javax.microedition.lcdui.Graphics;

public class ChartItem
extends Item {
    private int[][] dataSequences;
    private String[] labelsData;
    private int dataMaximum;
    private int dataMinimum;
    private String labelY;
    private String labelX;
    private int baseLine;
    private int divider;
    private int[] colors;
    private int axisColor;
    private int scaleFactorX;
    private int scaleFactorY;
    private Font font;
    private int fontColor;
    private RgbImage rotatedLabelY;

    public ChartItem(String label, int[][] dataSequences, int[] colors) {
        this(label, dataSequences, colors, null, null, null, 0, 0, null);
    }

    public ChartItem(String label, int[][] dataSequences, int[] colors, Style style) {
        this(label, dataSequences, colors, null, null, null, 0, 0, style);
    }

    public ChartItem(String label, int[][] dataSequences, int[] colors, String[] labelsData, String labelY, String labelX, int baseLine, int divider) {
        this(label, dataSequences, colors, labelsData, labelY, labelX, baseLine, divider, null);
    }

    public ChartItem(String label, int[][] dataSequences, int[] colors, String[] labelsData, String labelY, String labelX, int baseLine, int divider, Style style) {
        super(label, 0, 0, style);
        this.dataSequences = dataSequences;
        this.labelsData = labelsData;
        this.labelY = labelY;
        this.labelX = labelX;
        this.baseLine = baseLine;
        this.divider = divider;
        this.colors = colors;
        if (dataSequences != null) {
            this.setDataSequences(dataSequences);
        }
    }

    protected String createCssSelector() {
        return "chart";
    }

    protected void initContent(int firstLineWidth, int lineWidth) {
        boolean isHorizontalShrink;
        if (this.dataSequences == null || this.dataSequences.length == 0 || this.dataSequences[0].length == 0) {
            this.contentHeight = 0;
            this.contentWidth = 0;
            return;
        }
        if (this.font == null && (this.labelX != null || this.labelY != null)) {
            this.font = Font.getDefaultFont();
        }
        int labelWidth = 0;
        if (this.labelX != null) {
            labelWidth = this.font.getHeight() + this.paddingVertical;
            lineWidth -= labelWidth;
        }
        int length = this.dataSequences[0].length - 1;
        boolean bl = isHorizontalShrink = (this.layout & 0x400) == 1024;
        if (this.maximumWidth != 0 && this.maximumWidth < lineWidth) {
            lineWidth = this.maximumWidth;
        }
        if (isHorizontalShrink && length <= lineWidth) {
            this.contentWidth = lineWidth + labelWidth;
            this.scaleFactorX = 100;
        } else {
            this.scaleFactorX = lineWidth * 100 / length;
            this.contentWidth = this.scaleFactorX * length / 100 + labelWidth;
        }
        int maxHeight = 0;
        maxHeight = this.maximumHeight;
        if (maxHeight == 0) {
            Screen scr = this.getScreen();
            maxHeight = scr == null ? 100 : scr.contentHeight - 2;
        }
        int dataRange = this.dataMaximum > 0 ? (this.dataMinimum > 0 ? this.dataMaximum - this.baseLine : Math.abs(this.dataMaximum - this.dataMinimum)) : Math.abs(this.baseLine - this.dataMinimum);
        boolean isVerticalExpand = (this.layout & 0x2000) == 8192;
        int labelHeight = 0;
        if (this.labelX != null) {
            labelHeight = this.font.getHeight() + this.paddingVertical;
            maxHeight -= labelHeight;
        }
        if (!isVerticalExpand && dataRange <= maxHeight) {
            this.scaleFactorY = 100;
            this.contentHeight = dataRange + labelHeight;
        } else {
            this.scaleFactorY = maxHeight * 100 / dataRange;
            this.contentHeight = maxHeight + labelHeight;
        }
        if (this.labelY != null && this.rotatedLabelY == null) {
            int[] original = TextEffect.getRgbData(this.labelY, this.fontColor, this.font);
            int height = this.font.getHeight();
            int width = original.length / height;
            int[] rotated = new int[original.length];
            for (int col = 0; col < height; ++col) {
                for (int row = 0; row < width; ++row) {
                    rotated[row * height + (height - (col + 1))] = original[col * width + row];
                }
            }
            this.rotatedLabelY = new RgbImage(rotated, height, true);
        }
    }

    public int paintGrid(int x, int y, int leftBorder, int rightBorder, int[] inout_params, Graphics g) {
        if (this.dataSequences == null || this.dataSequences.length == 0) {
            return y;
        }
        int dataLength = this.dataSequences[0].length - 1;
        int xAxisWidth = dataLength * this.scaleFactorX / 100;
        int yAxisHeight = Math.abs(this.dataMaximum - this.dataMinimum) * this.scaleFactorY / 100;
        g.setColor(this.fontColor);
        g.setFont(this.font);
        if (this.labelX != null) {
            if (this.dataMaximum < 0) {
                g.drawString(this.labelX, x + xAxisWidth / 2, y, 17);
                inout_params[1] = y += this.font.getHeight() + this.paddingVertical;
            } else {
                g.drawString(this.labelX, x + xAxisWidth / 2, y + this.contentHeight, 33);
            }
        }
        if (this.labelY != null) {
            this.rotatedLabelY.paint(x, y + (yAxisHeight - this.rotatedLabelY.getHeight()) / 2, g);
            x += this.font.getHeight() + this.paddingHorizontal;
        }
        int baseLineY = this.dataMaximum > 0 ? y + (this.dataMaximum - this.baseLine) * this.scaleFactorY / 100 : y + this.baseLine * this.scaleFactorY / 100;
        g.setColor(this.axisColor);
        g.drawLine(x, baseLineY, x + xAxisWidth, baseLineY);
        g.drawLine(x, y, x, y + yAxisHeight);
        inout_params[0] = ++x;
        return baseLineY;
    }

    protected void paintContent(int x, int y, int leftBorder, int rightBorder, Graphics g) {
        int[][] sequences = this.dataSequences;
        if (sequences == null) {
            return;
        }
        int[] inout_params = new int[]{x, y};
        int baseLineY = this.paintGrid(x, y, leftBorder, rightBorder, inout_params, g);
        x = inout_params[0];
        y = inout_params[1];
        for (int i = 0; i < sequences.length; ++i) {
            g.setColor(this.colors[i]);
            int[] dataRow = sequences[i];
            if (dataRow == null || dataRow.length == 0) continue;
            int lastDatumX = x;
            int lastDatumY = baseLineY - dataRow[0] * this.scaleFactorY / 100;
            for (int j = 1; j < dataRow.length; ++j) {
                int datum = dataRow[j];
                int datumX = x + j * this.scaleFactorX / 100;
                int datumY = baseLineY - datum * this.scaleFactorY / 100;
                g.drawLine(lastDatumX, lastDatumY, datumX, datumY);
                lastDatumX = datumX;
                lastDatumY = datumY;
            }
        }
    }

    public void setStyle(Style style) {
        super.setStyle(style);
        this.font = style.font;
        this.fontColor = style.getFontColor();
    }

    public int getBaseLine() {
        return this.baseLine;
    }

    public void setBaseLine(int baseLine) {
        this.baseLine = baseLine;
    }

    public int getDataMaximum() {
        return this.dataMaximum;
    }

    public void setDataMaximum(int dataMaximum) {
        this.dataMaximum = dataMaximum;
    }

    public int getDataMinimum() {
        return this.dataMinimum;
    }

    public void setDataMinimum(int dataMinimum) {
        this.dataMinimum = dataMinimum;
    }

    public int[][] getDataSequences() {
        return this.dataSequences;
    }

    public void setDataSequences(int[][] dataSequences) {
        this.dataSequences = dataSequences;
        if (dataSequences == null || dataSequences.length == 0) {
            this.dataMinimum = 0;
            this.dataMaximum = 0;
        } else {
            int min = Integer.MAX_VALUE;
            int max = Integer.MIN_VALUE;
            for (int i = 0; i < dataSequences.length; ++i) {
                int[] dataRow = dataSequences[i];
                for (int j = 0; j < dataRow.length; ++j) {
                    int datum = dataRow[j];
                    if (datum < min) {
                        min = datum;
                    }
                    if (datum <= max) continue;
                    max = datum;
                }
            }
            this.dataMaximum = max;
            this.dataMinimum = min;
            if (this.colors == null) {
                this.colors = new int[this.dataSequences.length];
            }
        }
    }

    public int getDivider() {
        return this.divider;
    }

    public void setDivider(int divider) {
        this.divider = divider;
    }

    public String[] getLabelsData() {
        return this.labelsData;
    }

    public void setLabelsData(String[] labelsData) {
        this.labelsData = labelsData;
    }

    public String getLabelX() {
        return this.labelX;
    }

    public void setLabelX(String labelX) {
        this.labelX = labelX;
    }

    public String getLabelY() {
        return this.labelY;
    }

    public void setLabelY(String labelY) {
        this.rotatedLabelY = null;
        this.isInitialized = false;
        this.labelY = labelY;
    }

    public int getAxisColor() {
        return this.axisColor;
    }

    public void setAxisColor(int axisColor) {
        this.axisColor = axisColor;
    }

    public int[] getColors() {
        return this.colors;
    }

    public void setColors(int[] colors) {
        this.colors = colors;
    }

    public int getScaleFactorY() {
        return this.scaleFactorY;
    }

    public int getScaleFactorX() {
        return this.scaleFactorX;
    }
}

