/*
 * Decompiled with CFR 0.152.
 */
package de.enough.polish.ui;

import de.enough.polish.ui.MasterCanvas;
import de.enough.polish.ui.StringItem;
import de.enough.polish.ui.Style;
import de.enough.polish.ui.StyleSheet;
import java.util.Calendar;
import java.util.Date;
import java.util.TimeZone;
import javax.microedition.lcdui.Command;
import javax.microedition.lcdui.CommandListener;
import javax.microedition.lcdui.Displayable;
import javax.microedition.lcdui.Form;
import javax.microedition.lcdui.Graphics;
import javax.microedition.lcdui.Item;

public class DateField
extends StringItem
implements CommandListener {
    public static final int DATE = 1;
    public static final int TIME = 2;
    public static final int DATE_TIME = 3;
    private Date date;
    private int inputMode;
    private TimeZone timeZone;
    private boolean showCaret;
    private int originalWidth;
    private int originalHeight;
    private long lastCaretSwitch;
    private Calendar calendar;
    private javax.microedition.lcdui.DateField midpDateField;
    private Form form;

    public DateField(String label, int mode) {
        this(label, mode, null, null);
    }

    public DateField(String label, int mode, Style style) {
        this(label, mode, null, style);
    }

    public DateField(String label, int mode, TimeZone timeZone) {
        this(label, mode, timeZone, null);
    }

    public DateField(String label, int mode, TimeZone timeZone, Style style) {
        super(label, null, 3, style);
        this.inputMode = mode;
        this.timeZone = timeZone != null ? timeZone : TimeZone.getDefault();
        this.setDate(null);
    }

    public Date getDate() {
        return this.date;
    }

    public void setDate(Date date) {
        if (date != null && this.inputMode == 2 && date.getTime() > 86400000L) {
            if (this.calendar == null) {
                this.calendar = Calendar.getInstance();
                this.calendar.setTimeZone(this.timeZone);
            }
            this.calendar.setTime(date);
            long timeOnly = this.calendar.get(14) + this.calendar.get(13) * 1000 + this.calendar.get(12) * 60 * 1000 + this.calendar.get(11) * 60 * 60 * 1000;
            date.setTime(timeOnly);
        }
        this.date = date;
        if (this.midpDateField != null) {
            this.midpDateField.setDate(date);
        }
        if (date == null) {
            if (this.inputMode == 1 || this.inputMode == 3) {
                this.text = "YYYY-MM-DD";
                if (this.inputMode == 3) {
                    this.text = this.text + " hh:mm";
                }
            } else if (this.inputMode == 2) {
                this.text = "hh:mm";
            }
        } else {
            if (this.calendar == null) {
                this.calendar = Calendar.getInstance();
                this.calendar.setTimeZone(this.timeZone);
            }
            this.calendar.setTime(date);
            StringBuffer buffer = new StringBuffer(10);
            if (this.inputMode == 1 || this.inputMode == 3) {
                int year = this.calendar.get(1);
                int month = this.calendar.get(2);
                int day = this.calendar.get(5);
                if (year < 10) {
                    buffer.append("000");
                } else if (year < 100) {
                    buffer.append("00");
                } else if (year < 1000) {
                    buffer.append("0");
                }
                buffer.append(year).append("-");
                if (month < 9) {
                    buffer.append('0');
                }
                buffer.append(++month).append("-");
                if (day < 10) {
                    buffer.append('0');
                }
                buffer.append(day);
                if (this.inputMode == 3) {
                    buffer.append(' ');
                }
            }
            if (this.inputMode == 2 || this.inputMode == 3) {
                int hour = this.calendar.get(11);
                if (hour < 10) {
                    buffer.append('0');
                }
                buffer.append(hour).append(':');
                int minute = this.calendar.get(12);
                if (minute < 10) {
                    buffer.append('0');
                }
                buffer.append(minute);
            }
            this.text = buffer.toString();
        }
        if (this.isInitialized) {
            this.isInitialized = false;
            this.repaint();
        }
    }

    public int getInputMode() {
        return this.inputMode;
    }

    public void setInputMode(int mode) {
        this.inputMode = mode;
        if (this.midpDateField != null) {
            this.midpDateField.setInputMode(mode);
        }
        this.setDate(this.date);
    }

    public void paintContent(int x, int y, int leftBorder, int rightBorder, Graphics g) {
        super.paintContent(x, y, leftBorder, rightBorder, g);
        if (this.showCaret) {
            if (this.text == null) {
                g.setFont(this.font);
                g.setColor(this.textColor);
            }
            if (this.isLayoutCenter) {
                int centerX = leftBorder + (rightBorder - leftBorder) / 2 + this.originalWidth / 2 + 2;
                if (this.originalHeight > 0) {
                    y += this.originalHeight - this.font.getHeight();
                }
                g.drawChar('|', centerX, y, 20);
            } else {
                x += this.originalWidth + 2;
                if (this.originalHeight > 0) {
                    y += this.originalHeight - this.font.getHeight();
                }
                g.drawChar('|', x, y, 20);
            }
        }
    }

    protected void initContent(int firstLineWidth, int lineWidth) {
        if (this.date == null) {
            this.setDate(null);
        }
        super.initContent(firstLineWidth, lineWidth);
        this.originalWidth = this.contentWidth;
        this.originalHeight = this.contentHeight;
        if (this.contentWidth < this.minimumWidth) {
            this.contentWidth = this.minimumWidth;
        }
        if (this.contentHeight < this.minimumHeight) {
            this.contentHeight = this.minimumHeight;
        } else if (this.contentHeight < this.font.getHeight()) {
            this.originalHeight = this.contentHeight = this.font.getHeight();
        }
    }

    protected String createCssSelector() {
        return "datefield";
    }

    public void setStyle(Style style) {
        super.setStyle(style);
    }

    public boolean animate() {
        long currentTime = System.currentTimeMillis();
        if (currentTime - this.lastCaretSwitch > 500L) {
            this.lastCaretSwitch = currentTime;
            this.showCaret = !this.showCaret;
            return true;
        }
        return false;
    }

    protected void defocus(Style originalStyle) {
        super.defocus(originalStyle);
        this.showCaret = false;
    }

    protected synchronized boolean handleKeyPressed(int keyCode, int gameAction) {
        if (!(keyCode >= 48 && keyCode <= 57 || this.getScreen().isGameActionFire(keyCode, gameAction))) {
            return false;
        }
        this.showDateForm();
        return true;
    }

    private void showDateForm() {
        if (this.midpDateField == null) {
            this.midpDateField = new javax.microedition.lcdui.DateField(this.getLabel(), this.inputMode, this.timeZone);
            this.midpDateField.setDate(this.date);
            this.form = new Form(StyleSheet.currentScreen.getTitle());
            this.form.append((Item)this.midpDateField);
            this.form.addCommand(StyleSheet.OK_CMD);
            this.form.addCommand(StyleSheet.CANCEL_CMD);
            this.form.setCommandListener((CommandListener)this);
        }
        this.screen = StyleSheet.currentScreen;
        MasterCanvas.setCurrent(StyleSheet.display, (Displayable)this.form);
    }

    public void commandAction(Command cmd, Displayable box) {
        if (cmd == StyleSheet.CANCEL_CMD) {
            this.midpDateField.setDate(this.date);
        } else {
            this.setDate(this.midpDateField.getDate());
            this.notifyStateChanged();
        }
        MasterCanvas.setCurrent(StyleSheet.display, (Displayable)this.screen);
    }
}

