/*
 * Decompiled with CFR 0.152.
 */
package de.enough.polish.ui;

import de.enough.polish.ui.ChoiceGroup;
import de.enough.polish.ui.ChoiceItem;
import de.enough.polish.ui.ClippingRegion;
import de.enough.polish.ui.Item;
import de.enough.polish.ui.ItemStateListener;
import de.enough.polish.ui.List;
import de.enough.polish.ui.MasterCanvas;
import de.enough.polish.ui.Screen;
import de.enough.polish.ui.Style;
import de.enough.polish.ui.TextField;
import de.enough.polish.util.ArrayList;
import javax.microedition.lcdui.Command;
import javax.microedition.lcdui.Displayable;
import javax.microedition.lcdui.Graphics;
import javax.microedition.lcdui.Image;

public class FilteredList
extends List
implements ItemStateListener {
    private static final int FIELD_POSITION_TOP = 0;
    private static final int FIELD_POSITION_BOTTOM = 1;
    private static final int FILTER_STARTS_WITH = 0;
    private static final int FILTER_INDEX_OF = 1;
    protected int filterPosition = 1;
    protected int filterMode = 0;
    protected final TextField filterTextField = new TextField(null, "", 30, 0);
    private final ArrayList itemsList;
    private String lastFilterText;
    private int filterHeight;

    public FilteredList(String title, int listType) {
        this(title, listType, (ChoiceItem[])null, (Style)null);
    }

    public FilteredList(String title, int listType, Style style) {
        this(title, listType, (ChoiceItem[])null, style);
    }

    public FilteredList(String title, int listType, String[] stringElements, Image[] imageElements) {
        this(title, listType, stringElements, imageElements, null);
    }

    public FilteredList(String title, int listType, String[] stringElements, Image[] imageElements, Style style) {
        this(title, listType, ChoiceGroup.buildChoiceItems(stringElements, imageElements, listType, style), style);
    }

    public FilteredList(String title, int listType, ChoiceItem[] items) {
        this(title, listType, items, null);
    }

    public FilteredList(String title, int listType, ChoiceItem[] items, Style style) {
        super(title, listType, items, style);
        this.filterTextField.screen = this;
        this.setItemStateListener(this);
        this.itemsList = new ArrayList();
    }

    protected boolean handleKeyPressed(int keyCode, int gameAction) {
        int height;
        boolean handled = false;
        if (!this.isGameActionFire(keyCode, gameAction) && (handled = this.filterTextField.handleKeyPressed(keyCode, gameAction)) && (height = this.filterTextField.getItemHeight(this.contentWidth, this.contentWidth)) != this.filterHeight) {
            this.calculateContentArea(0, 0, this.screenWidth, this.screenHeight);
        }
        if (!handled) {
            handled = super.handleKeyPressed(keyCode, gameAction);
        }
        return handled;
    }

    protected boolean handleKeyReleased(int keyCode, int gameAction) {
        boolean handled = false;
        if (!this.isGameActionFire(keyCode, gameAction)) {
            handled = this.filterTextField.handleKeyReleased(keyCode, gameAction);
        }
        if (!handled) {
            handled = super.handleKeyReleased(keyCode, gameAction);
        }
        return handled;
    }

    protected boolean handleKeyRepeated(int keyCode, int gameAction) {
        boolean handled = false;
        if (!this.isGameActionFire(keyCode, gameAction)) {
            handled = this.filterTextField.handleKeyRepeated(keyCode, gameAction);
        }
        if (!handled) {
            handled = super.handleKeyRepeated(keyCode, gameAction);
        }
        return handled;
    }

    public void animate(long currentTime, ClippingRegion repaintRegion) {
        super.animate(currentTime, repaintRegion);
        this.filterTextField.animate(currentTime, repaintRegion);
    }

    protected void setItemCommands(ArrayList commandsList, Item item) {
        if (item != this.filterTextField) {
            this.filterTextField.addCommands(commandsList);
        } else {
            this.container.addCommands(commandsList);
        }
        super.setItemCommands(commandsList, item);
    }

    protected void calculateContentArea(int x, int y, int width, int height) {
        super.calculateContentArea(x, y, width, height);
        this.filterHeight = this.filterTextField.getItemHeight(this.contentWidth, this.contentWidth);
        this.contentHeight -= this.filterHeight;
        this.container.setScrollHeight(this.contentHeight);
        if (this.filterPosition == 0) {
            this.filterTextField.relativeY = this.contentY;
            this.contentY += this.filterHeight;
        } else {
            this.filterTextField.relativeY = this.contentY + this.contentHeight;
        }
    }

    public void showNotify() {
        if (!this.filterTextField.isFocused) {
            this.filterTextField.setShowInputInfo(false);
            this.filterTextField.focus(this.filterTextField.getFocusedStyle(), 0);
        }
        this.itemStateChanged(this.filterTextField);
        super.showNotify();
    }

    private void setFocus(Item item) {
        this.forwardEventToNativeField(this, 0);
    }

    private boolean forwardEventToNativeField(Screen screen, int keyCode) {
        return false;
    }

    public Item getCurrentItem() {
        return this.filterTextField;
    }

    protected void paintScreen(Graphics g) {
        this.filterTextField.paint(this.contentX, this.filterTextField.relativeY, this.contentX, this.contentX + this.contentWidth, g);
        super.paintScreen(g);
    }

    public int append(ChoiceItem item) {
        if (this.listType == 2) {
            this.choiceGroup.selectChoiceItem(item, item.isSelected);
            item.setItemCommandListener(this.choiceGroup);
        }
        this.itemsList.add(item);
        this.lastFilterText = null;
        if (MasterCanvas.isDisplayableShown((Displayable)this)) {
            this.itemStateChanged(this.filterTextField);
        }
        return this.itemsList.size() - 1;
    }

    public void delete(int elementNum) {
        this.itemsList.remove(elementNum);
        this.lastFilterText = null;
        if (MasterCanvas.isDisplayableShown((Displayable)this)) {
            this.itemStateChanged(this.filterTextField);
        }
    }

    public void deleteAll() {
        this.itemsList.clear();
        this.lastFilterText = null;
        if (MasterCanvas.isDisplayableShown((Displayable)this)) {
            this.itemStateChanged(this.filterTextField);
        }
    }

    public ChoiceItem getItem(int elementNum) {
        return (ChoiceItem)this.itemsList.get(elementNum);
    }

    public int getSelectedFlags(boolean[] selectedArray_return) {
        int count = 0;
        for (int i = 0; i < selectedArray_return.length; ++i) {
            boolean selected;
            selectedArray_return[i] = selected = ((ChoiceItem)this.itemsList.get((int)i)).isSelected;
            if (!selected) continue;
            ++count;
        }
        return count;
    }

    public boolean containsChangesTo(boolean[] flags) {
        if (this.itemsList.size() != flags.length) {
            return true;
        }
        for (int i = 0; i < flags.length; ++i) {
            boolean flag = flags[i];
            if (flag == ((ChoiceItem)this.itemsList.get((int)i)).isSelected) continue;
            return true;
        }
        return false;
    }

    public int getSelectedIndex() {
        Item focItem;
        if (this.listType == 3 && MasterCanvas.isDisplayableShown((Displayable)this) && (focItem = this.container.getFocusedItem()) != null) {
            return this.itemsList.indexOf(focItem);
        }
        Object[] items = this.itemsList.getInternalArray();
        for (int i = 0; i < items.length; ++i) {
            Object object = items[i];
            if (object == null) {
                return -1;
            }
            ChoiceItem item = (ChoiceItem)object;
            if (!item.isSelected) continue;
            return i;
        }
        return -1;
    }

    public void insert(int elementNum, ChoiceItem item) {
        this.itemsList.add(elementNum, item);
        this.lastFilterText = null;
        if (MasterCanvas.isDisplayableShown((Displayable)this)) {
            this.itemStateChanged(this.filterTextField);
        }
    }

    public void set(int elementNum, String stringPart, Image imagePart, Style elementStyle) {
        ChoiceItem item = this.getItem(elementNum);
        item.setText(stringPart);
        if (imagePart != null) {
            item.setImage(imagePart);
        }
        if (elementStyle != null) {
            item.setStyle(elementStyle);
        }
        this.lastFilterText = null;
        if (MasterCanvas.isDisplayableShown((Displayable)this)) {
            this.itemStateChanged(this.filterTextField);
        }
    }

    public void set(int elementNum, ChoiceItem item) {
        this.itemsList.set(elementNum, item);
        this.lastFilterText = null;
        if (MasterCanvas.isDisplayableShown((Displayable)this)) {
            this.itemStateChanged(this.filterTextField);
        }
    }

    public void setSelectedFlags(boolean[] selectedArray) {
        for (int i = 0; i < selectedArray.length; ++i) {
            boolean selected = selectedArray[i];
            ChoiceItem item = (ChoiceItem)this.itemsList.get(i);
            item.select(selected);
            if (this.listType != 2) continue;
            if (selected) {
                item.addCommand(ChoiceGroup.MARK_COMMAND);
                item.removeCommand(ChoiceGroup.UNMARK_COMMAND);
                continue;
            }
            item.addCommand(ChoiceGroup.MARK_COMMAND);
            item.removeCommand(ChoiceGroup.UNMARK_COMMAND);
        }
        if (MasterCanvas.isDisplayableShown((Displayable)this)) {
            this.itemStateChanged(this.filterTextField);
        }
    }

    public void setSelectedIndex(int elementNum, boolean selected) {
        if (this.listType == 2) {
            ChoiceItem item = (ChoiceItem)this.itemsList.get(elementNum);
            item.select(selected);
            if (selected) {
                item.addCommand(ChoiceGroup.MARK_COMMAND);
                item.removeCommand(ChoiceGroup.UNMARK_COMMAND);
            } else {
                item.addCommand(ChoiceGroup.MARK_COMMAND);
                item.removeCommand(ChoiceGroup.UNMARK_COMMAND);
            }
        } else {
            if (!selected) {
                return;
            }
            int oldIndex = this.getSelectedIndex();
            if (oldIndex != -1) {
                ChoiceItem oldSelected = (ChoiceItem)this.itemsList.get(oldIndex);
                oldSelected.select(false);
            }
            ChoiceItem newSelected = (ChoiceItem)this.itemsList.get(elementNum);
            newSelected.select(true);
        }
        if (MasterCanvas.isDisplayableShown((Displayable)this)) {
            if (this.listType == 3) {
                this.focus(elementNum);
            }
            this.itemStateChanged(this.filterTextField);
        }
    }

    public void focus(int index, boolean force) {
        Item item = null;
        if (index != -1) {
            item = (Item)this.itemsList.get(index);
        }
        this.focus(index, item, force);
    }

    public void focus(Item item, boolean force) {
        int index = -1;
        if (item != null) {
            this.itemsList.indexOf(item);
        }
        this.focus(index, item, force);
    }

    public void focus(int index, Item item, boolean force) {
        if (index != -1 && item == null) {
            item = (Item)this.itemsList.get(index);
        }
        if (item != null) {
            index = this.container.indexOf(item);
            this.container.focus(index);
        } else {
            this.container.focus(-1);
        }
    }

    public boolean isSelected(int elementNum) {
        ChoiceItem item = (ChoiceItem)this.itemsList.get(elementNum);
        return item.isSelected;
    }

    public int size() {
        return this.itemsList.size();
    }

    protected boolean handleCommand(Command cmd) {
        if (this.filterTextField.handleCommand(cmd)) {
            return true;
        }
        return super.handleCommand(cmd);
    }

    public void setFilterLabel(String label) {
        this.filterTextField.setLabel(label);
    }

    public void setFilterText(String text) {
        this.filterTextField.setString(text);
        if (this.contentWidth != 0 && MasterCanvas.isDisplayableShown((Displayable)this)) {
            int height = this.filterTextField.getItemHeight(this.contentWidth, this.contentWidth);
            if (height != this.filterHeight) {
                this.calculateContentArea(0, 0, this.screenWidth, this.screenHeight);
            }
            this.itemStateChanged(this.filterTextField);
        }
    }

    public String getFilterText() {
        return this.filterTextField.getString();
    }

    public void setFilterStyle(Style filterStyle) {
        this.filterTextField.focusedStyle = filterStyle;
        if (MasterCanvas.isDisplayableShown((Displayable)this)) {
            this.filterTextField.focus(filterStyle, 0);
        }
    }

    protected boolean matches(String filterText, ChoiceItem cItem, boolean checkForSelectedRadioItem) {
        if (checkForSelectedRadioItem && cItem.isSelected) {
            return true;
        }
        if (this.filterMode == 0) {
            return cItem.getText().toLowerCase().startsWith(filterText);
        }
        return cItem.getText().toLowerCase().indexOf(filterText) != -1;
    }

    public void itemStateChanged(Item item) {
        if (item == this.filterTextField) {
            boolean checkForSelectedRadioItem;
            String text = this.filterTextField.getString();
            if (text == this.lastFilterText) {
                return;
            }
            this.lastFilterText = text;
            Object[] itemObjects = this.itemsList.getInternalArray();
            ArrayList matchingItems = new ArrayList(itemObjects.length);
            int focIndex = -1;
            Item focItem = this.container.focusedItem;
            boolean bl = checkForSelectedRadioItem = this.listType == 1;
            if (text.length() == 0) {
                matchingItems.addAll(this.itemsList);
                focIndex = this.getSelectedIndex();
                if (focIndex != -1 && focItem == null) {
                    focItem = (Item)this.itemsList.get(focIndex);
                }
            } else {
                Object object;
                String filterText = text.toLowerCase();
                for (int i = 0; i < itemObjects.length && (object = itemObjects[i]) != null; ++i) {
                    ChoiceItem cItem = (ChoiceItem)object;
                    boolean isMatch = this.matches(filterText, cItem, checkForSelectedRadioItem);
                    if (!isMatch) continue;
                    matchingItems.add(cItem);
                    if (cItem != focItem) continue;
                    focIndex = i;
                }
            }
            this.container.setItemsList(matchingItems);
            if (focIndex != -1) {
                super.focus(focIndex, focItem, false);
            } else if (matchingItems.size() > 0) {
                super.focus(0, (Item)matchingItems.get(0), false);
            }
            if (checkForSelectedRadioItem && this.getSelectedIndex() != -1) {
                ((ChoiceGroup)this.container).setSelectedIndex(matchingItems.indexOf(this.itemsList.get(this.getSelectedIndex())), true);
            }
            this.filterTextField.showCommands();
        }
    }

    public void setStyle(Style style) {
        super.setStyle(style);
        Style filterStyle = (Style)style.getObjectProperty(244);
        if (filterStyle != null) {
            this.filterTextField.focusedStyle = filterStyle;
            this.filterTextField.focus(filterStyle, 0);
        }
    }

    protected String createCssSelector() {
        return "filteredlist";
    }

    public String toSelectionString(String delimiter) {
        ChoiceItem item;
        Object[] elements = this.itemsList.getInternalArray();
        StringBuffer buffer = null;
        for (int i = 0; i < elements.length && (item = (ChoiceItem)elements[i]) != null; ++i) {
            if (!item.isSelected) continue;
            if (buffer == null) {
                buffer = new StringBuffer();
            } else {
                buffer.append(delimiter);
            }
            buffer.append(item.text);
        }
        if (buffer == null) {
            return null;
        }
        return buffer.toString();
    }
}

