/*
 * Decompiled with CFR 0.152.
 */
package de.enough.polish.ui;

import de.enough.polish.ui.ClippingRegion;
import de.enough.polish.ui.Container;
import de.enough.polish.ui.Form;
import de.enough.polish.ui.Item;
import de.enough.polish.ui.MasterCanvas;
import de.enough.polish.ui.Style;
import de.enough.polish.ui.StyleSheet;
import javax.microedition.lcdui.Command;
import javax.microedition.lcdui.Displayable;
import javax.microedition.lcdui.Graphics;

public class FramedForm
extends Form {
    protected Container leftFrame;
    protected Container rightFrame;
    protected Container topFrame;
    protected Container bottomFrame;
    private int originalContentHeight;
    private int originalContentWidth;
    private boolean expandRightFrame;
    private boolean expandLeftFrame;
    protected Container currentlyActiveContainer;
    private int originalContentY;
    private int originalContentX;

    public FramedForm(String title) {
        this(title, (Style)null);
    }

    public FramedForm(String title, Style style) {
        super(title, style);
        this.currentlyActiveContainer = this.container;
        this.container.allowCycling = false;
    }

    private Container getFrame(int frameOrientation) {
        switch (frameOrientation) {
            case 16: {
                return this.topFrame;
            }
            case 32: {
                return this.bottomFrame;
            }
            case 4: {
                return this.leftFrame;
            }
            case 8: {
                return this.rightFrame;
            }
        }
        return this.container;
    }

    public void deleteAll() {
        super.deleteAll();
        if (this.leftFrame != null) {
            this.leftFrame.clear();
            this.leftFrame = null;
        }
        if (this.rightFrame != null) {
            this.rightFrame.clear();
            this.rightFrame = null;
        }
        if (this.topFrame != null) {
            this.topFrame.clear();
            this.topFrame = null;
        }
        if (this.bottomFrame != null) {
            this.bottomFrame.clear();
            this.bottomFrame = null;
        }
        this.requestInit();
    }

    public void deleteAll(int frameOrientation) {
        Container frame = this.getFrame(frameOrientation);
        if (frame != null) {
            frame.clear();
            this.deleteFrame(frameOrientation);
        }
    }

    public void append(int frameOrientation, Item item) {
        this.append(frameOrientation, item, null);
    }

    public void set(int frameOrientation, int itemNum, Item item) {
        Container frame = this.getFrame(frameOrientation);
        if (frame != null) {
            frame.set(itemNum, item);
        }
    }

    public void delete(int frameOrientation, int itemNum) {
        Container frame = this.getFrame(frameOrientation);
        if (frame != null) {
            frame.remove(itemNum);
            if (frame.size() == 0) {
                this.deleteFrame(frameOrientation);
            } else {
                this.requestInit();
            }
        }
    }

    public int size(int frameOrientation) {
        Container frame = this.getFrame(frameOrientation);
        if (frame == null) {
            return -1;
        }
        return frame.size();
    }

    public boolean deleteFrame(int frameOrientation) {
        Container frame;
        switch (frameOrientation) {
            case 16: {
                frame = this.topFrame;
                this.topFrame = null;
                break;
            }
            case 32: {
                frame = this.bottomFrame;
                this.bottomFrame = null;
                break;
            }
            case 4: {
                frame = this.leftFrame;
                this.leftFrame = null;
                break;
            }
            case 8: {
                frame = this.rightFrame;
                this.rightFrame = null;
                break;
            }
            default: {
                return false;
            }
        }
        if (frame == null) {
            return false;
        }
        if (frame == this.currentlyActiveContainer) {
            this.setActiveFrame(this.container);
        }
        frame.hideNotify();
        this.requestInit();
        return true;
    }

    public void append(int frameOrientation, Item item, Style itemStyle) {
        Container frame;
        if (itemStyle != null) {
            item.setStyle(itemStyle);
        }
        switch (frameOrientation) {
            case 16: {
                if (this.topFrame == null) {
                    this.topFrame = new Container(false, StyleSheet.defaultStyle);
                }
                frame = this.topFrame;
                break;
            }
            case 32: {
                if (this.bottomFrame == null) {
                    this.bottomFrame = new Container(false, StyleSheet.defaultStyle);
                }
                frame = this.bottomFrame;
                break;
            }
            case 4: {
                if (this.leftFrame == null) {
                    this.leftFrame = new Container(false, StyleSheet.defaultStyle);
                }
                frame = this.leftFrame;
                break;
            }
            case 8: {
                if (this.rightFrame == null) {
                    this.rightFrame = new Container(false, StyleSheet.defaultStyle);
                }
                frame = this.rightFrame;
                break;
            }
            default: {
                super.append(item, itemStyle);
                return;
            }
        }
        frame.screen = this;
        frame.allowCycling = false;
        frame.add(item);
        if (MasterCanvas.isDisplayableShown((Displayable)this)) {
            this.requestInit();
        }
    }

    protected void calculateContentArea(int x, int y, int width, int height) {
        super.calculateContentArea(x, y, width, height);
        x = this.contentX;
        y = this.contentY;
        width = this.contentWidth;
        height = this.contentHeight;
        this.originalContentWidth = width;
        this.originalContentHeight = height;
        this.originalContentY = this.contentY;
        this.originalContentX = this.contentX;
        if (this.leftFrame != null) {
            boolean bl = this.expandLeftFrame = (this.leftFrame.style.layout & 0x2000) == 8192;
            if (this.expandLeftFrame) {
                this.leftFrame.setStyle(this.leftFrame.style, true);
            }
            int frameWidth = this.leftFrame.getItemWidth(width / 2, width / 2);
            x += frameWidth;
            width -= frameWidth;
        }
        if (this.rightFrame != null) {
            boolean bl = this.expandRightFrame = (this.rightFrame.style.layout & 0x2000) == 8192;
            if (this.expandRightFrame) {
                this.rightFrame.setStyle(this.rightFrame.style, true);
            }
            width -= this.rightFrame.getItemWidth(this.originalContentWidth / 2, this.originalContentWidth / 2);
        }
        if (this.topFrame != null) {
            int frameHeight = this.topFrame.getItemHeight(this.originalContentWidth, this.originalContentWidth);
            y += frameHeight;
            height -= frameHeight;
        }
        if (this.bottomFrame != null) {
            height -= this.bottomFrame.getItemHeight(this.originalContentWidth, this.originalContentWidth);
        }
        this.container.requestFullInit();
        this.container.init(width, width);
        this.contentX = x;
        this.contentY = y;
        this.contentWidth = width;
        this.contentHeight = height;
        this.container.relativeX = x;
        this.container.relativeY = y;
        this.container.setScrollHeight(height);
    }

    protected boolean checkForRequestInit(Item source) {
        return super.checkForRequestInit(source) || source == this.topFrame || source == this.bottomFrame || source == this.leftFrame || source == this.rightFrame;
    }

    protected void requestInit() {
        super.requestInit();
        this.isInitRequested = true;
    }

    protected void paintScreen(Graphics g) {
        int y;
        Style frameStyle;
        if (this.currentlyActiveContainer != this.container) {
            super.paintScreen(g);
        }
        if (this.leftFrame != null) {
            frameStyle = this.leftFrame.style;
            if (this.expandLeftFrame) {
                if (frameStyle.background != null) {
                    frameStyle.background.paint(frameStyle.marginLeft, frameStyle.marginTop, this.leftFrame.backgroundWidth, this.originalContentHeight - frameStyle.marginTop - frameStyle.marginBottom, g);
                }
                if (frameStyle.border != null) {
                    frameStyle.border.paint(frameStyle.marginLeft, frameStyle.marginTop, this.leftFrame.backgroundWidth, this.originalContentHeight - frameStyle.marginTop - frameStyle.marginBottom, g);
                }
            }
            y = this.originalContentY;
            if ((frameStyle.layout & 0x30) == 48) {
                y += (this.originalContentHeight - frameStyle.marginBottom - this.leftFrame.itemHeight) / 2;
            } else if ((frameStyle.layout & 0x20) == 32) {
                y += this.originalContentHeight - frameStyle.marginBottom - this.leftFrame.itemHeight;
            }
            this.leftFrame.relativeX = 0;
            this.leftFrame.relativeY = y;
            this.leftFrame.paint(0, y, 0, this.contentWidth, g);
        }
        if (this.rightFrame != null) {
            frameStyle = this.rightFrame.style;
            if (this.expandRightFrame) {
                if (frameStyle.background != null) {
                    frameStyle.background.paint(this.contentWidth + frameStyle.marginLeft, frameStyle.marginTop, this.rightFrame.backgroundWidth, this.originalContentHeight - frameStyle.marginTop - frameStyle.marginBottom, g);
                }
                if (frameStyle.border != null) {
                    frameStyle.border.paint(this.contentWidth + frameStyle.marginLeft, frameStyle.marginTop, this.rightFrame.backgroundWidth, this.originalContentHeight - frameStyle.marginTop - frameStyle.marginBottom, g);
                }
            }
            y = this.originalContentY;
            if ((frameStyle.layout & 0x30) == 48) {
                y += (this.originalContentHeight - frameStyle.marginBottom - this.rightFrame.itemHeight) / 2;
            } else if ((frameStyle.layout & 0x20) == 32) {
                y += this.originalContentHeight - frameStyle.marginBottom - this.rightFrame.itemHeight;
            }
            this.rightFrame.relativeX = this.contentWidth;
            this.rightFrame.relativeY = y;
            this.rightFrame.paint(this.contentWidth, y, this.contentWidth, this.screenWidth, g);
        }
        if (this.topFrame != null) {
            this.topFrame.relativeX = this.originalContentX;
            this.topFrame.relativeY = this.originalContentY;
            this.topFrame.paint(this.originalContentX, this.originalContentY, this.originalContentX, this.originalContentX + this.originalContentWidth, g);
        }
        if (this.bottomFrame != null) {
            this.bottomFrame.relativeX = this.originalContentX;
            this.bottomFrame.relativeY = this.contentY + this.contentHeight;
            this.bottomFrame.paint(this.originalContentX, this.contentY + this.contentHeight, this.originalContentX, this.originalContentX + this.originalContentWidth, g);
        }
        if (this.currentlyActiveContainer == this.container) {
            super.paintScreen(g);
        }
    }

    protected boolean handleKeyPressed(int keyCode, int gameAction) {
        boolean handled = this.currentlyActiveContainer.handleKeyPressed(keyCode, gameAction);
        if (!handled && !this.isSoftKey(keyCode)) {
            Container newFrame = null;
            if (this.currentlyActiveContainer == this.container) {
                Container[] nextFrames;
                switch (gameAction) {
                    case 6: {
                        nextFrames = new Container[]{this.bottomFrame, this.leftFrame, this.rightFrame, this.topFrame};
                        break;
                    }
                    case 1: {
                        nextFrames = new Container[]{this.topFrame, this.leftFrame, this.rightFrame, this.bottomFrame};
                        break;
                    }
                    case 2: {
                        nextFrames = new Container[]{this.leftFrame, this.topFrame, this.bottomFrame, this.rightFrame};
                        break;
                    }
                    case 5: {
                        nextFrames = new Container[]{this.rightFrame, this.topFrame, this.bottomFrame, this.leftFrame};
                        break;
                    }
                    default: {
                        return false;
                    }
                }
                for (int i = 0; i < nextFrames.length; ++i) {
                    Container frame = nextFrames[i];
                    if (frame == null || frame.appearanceMode == 0) continue;
                    newFrame = frame;
                    break;
                }
            } else if (this.container.appearanceMode != 0) {
                newFrame = this.container;
            } else {
                this.container.handleKeyPressed(keyCode, gameAction);
            }
            if (newFrame != null && newFrame != this.currentlyActiveContainer) {
                this.setActiveFrame(newFrame);
                handled = true;
            }
        }
        return handled || super.handleKeyPressed(keyCode, gameAction);
    }

    protected boolean handleKeyReleased(int keyCode, int gameAction) {
        boolean handled = this.currentlyActiveContainer.handleKeyReleased(keyCode, gameAction);
        return handled || super.handleKeyReleased(keyCode, gameAction);
    }

    protected boolean handleKeyRepeated(int keyCode, int gameAction) {
        boolean handled = this.currentlyActiveContainer.handleKeyRepeated(keyCode, gameAction);
        return handled || super.handleKeyRepeated(keyCode, gameAction);
    }

    protected boolean handleCommand(Command cmd) {
        if (this.currentlyActiveContainer != this.container && this.currentlyActiveContainer != null && this.currentlyActiveContainer.handleCommand(cmd)) {
            return true;
        }
        return super.handleCommand(cmd);
    }

    public Item getCurrentItem() {
        if (this.currentlyActiveContainer != null) {
            return this.currentlyActiveContainer.focusedItem;
        }
        return null;
    }

    public void setActiveFrame(int frameOrientation) {
        this.setActiveFrame(this.getFrame(frameOrientation));
    }

    private void setActiveFrame(Container newFrame) {
        if (newFrame == null || newFrame == this.currentlyActiveContainer) {
            return;
        }
        this.currentlyActiveContainer.defocus(this.currentlyActiveContainer.style);
        if (newFrame.appearanceMode != 0) {
            int direction = 0;
            direction = this.currentlyActiveContainer == this.bottomFrame ? 1 : (this.currentlyActiveContainer == this.topFrame ? 6 : (this.currentlyActiveContainer == this.leftFrame ? 5 : (this.currentlyActiveContainer == this.rightFrame ? 2 : (newFrame == this.bottomFrame ? 6 : (newFrame == this.topFrame ? 1 : (newFrame == this.leftFrame ? 2 : 5))))));
            newFrame.focus(StyleSheet.focusedStyle, direction);
        }
        this.currentlyActiveContainer = newFrame;
        if (this.screenStateListener != null) {
            this.screenStateListener.screenStateChanged(this);
        }
    }

    public void animate(long currentTime, ClippingRegion repaintRegion) {
        super.animate(currentTime, repaintRegion);
        if (this.leftFrame != null) {
            this.leftFrame.animate(currentTime, repaintRegion);
        }
        if (this.rightFrame != null) {
            this.rightFrame.animate(currentTime, repaintRegion);
        }
        if (this.topFrame != null) {
            this.topFrame.animate(currentTime, repaintRegion);
        }
        if (this.bottomFrame != null) {
            this.bottomFrame.animate(currentTime, repaintRegion);
        }
    }

    protected Item[] getRootItems() {
        Item[] frames = new Container[4];
        int index = 0;
        if (this.topFrame != null) {
            frames[index] = this.topFrame;
            ++index;
        }
        if (this.bottomFrame != null) {
            frames[index] = this.bottomFrame;
            ++index;
        }
        if (this.leftFrame != null) {
            frames[index] = this.leftFrame;
            ++index;
        }
        if (this.rightFrame != null) {
            frames[index] = this.rightFrame;
            ++index;
        }
        if (index < 4) {
            Container[] activeFrames = new Container[index];
            System.arraycopy(frames, 0, activeFrames, 0, index);
            frames = activeFrames;
        }
        return frames;
    }

    public void setStyle(Style style) {
        super.setStyle(style);
    }
}

