/*
 * Decompiled with CFR 0.152.
 */
package de.enough.polish.ui;

import de.enough.polish.ui.AnimationThread;
import de.enough.polish.ui.Item;
import de.enough.polish.ui.Style;
import javax.microedition.lcdui.Font;
import javax.microedition.lcdui.Graphics;
import javax.microedition.lcdui.Image;

public class Gauge
extends Item {
    private static int ANIMATION_MODE_BACKANDFORTH = 1;
    public static final int INDEFINITE = -1;
    public static final int CONTINUOUS_IDLE = 0;
    public static final int INCREMENTAL_IDLE = 1;
    public static final int CONTINUOUS_RUNNING = 2;
    public static final int INCREMENTAL_UPDATING = 3;
    private static final int MODE_CONTINUOUS = 0;
    private static final int MODE_CHUNKED = 1;
    private static final int POSITION_LEFT = 0;
    private static final int POSITION_RIGHT = 1;
    private static final int POSITION_CENTER = 2;
    private int value;
    private String valueString;
    private int maxValue;
    private boolean isInteractive;
    private int color = 255;
    private int mode = 1;
    private int chunkWidth = 6;
    private int gapWidth = 3;
    private int gapColor = 0xFFFFFF;
    private Image image;
    private int imageYOffset;
    private Image indicatorImage;
    private boolean isIndefinite;
    private int indefinitePos;
    private boolean showValue = true;
    private int fontColor;
    private Font font;
    private int valueWidth;
    private int valuePosition = 0;

    public Gauge(String label, boolean interactive, int maxValue, int initialValue) {
        this(label, interactive, maxValue, initialValue, null);
    }

    public Gauge(String label, boolean interactive, int maxValue, int initialValue, Style style) {
        super(label, 0, 0, style);
        if (interactive) {
            if (maxValue < 0) {
                throw new IllegalArgumentException("Invalid maxValue for interactive Gauge: " + maxValue);
            }
            if (initialValue < 0 || initialValue > maxValue) {
                throw new IllegalArgumentException("Invalid initialValue for interactive Gauge: " + initialValue);
            }
        } else if (maxValue == -1) {
            this.isIndefinite = true;
            this.maxValue = 20;
            if (initialValue != 0 && initialValue != 2 && initialValue != 1 && initialValue != 3) {
                throw new IllegalArgumentException("Invalid initialValue for indefinite Gauge: " + initialValue);
            }
        } else {
            if (maxValue < 0) {
                throw new IllegalArgumentException("Invalid maxValue for Gauge: " + maxValue);
            }
            if (initialValue < 0 || initialValue > maxValue) {
                throw new IllegalArgumentException("Invalid initialValue for Gauge: " + initialValue);
            }
        }
        this.isInteractive = interactive;
        if (interactive) {
            this.appearanceMode = 3;
        }
        this.maxValue = maxValue;
        this.isIndefinite = maxValue == -1;
        this.setValue(initialValue);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void setValue(int value) {
        if (this.isIndefinite) {
            if (this.value == 2 && value != 2) {
                AnimationThread.removeAnimationItem(this);
            }
            if (value == 0) {
                this.indefinitePos = 0;
            } else if (value == 2) {
                if (this.isShown && this.value != 2) {
                    AnimationThread.addAnimationItem(this);
                }
            } else if (value == 1) {
                this.indefinitePos = 0;
            } else {
                if (value != 3) throw new IllegalArgumentException("Invalid value for indefinite Gauge: " + value);
                ++this.indefinitePos;
                if (this.indefinitePos > this.maxValue) {
                    this.indefinitePos = 0;
                }
            }
        } else if (value < 0) {
            value = 0;
        } else if (value > this.maxValue) {
            value = this.maxValue;
        }
        this.value = value;
        this.valueString = Integer.toString(value);
        if (this.view == null && this.isInitialized) {
            if (this.isIndefinite) {
                this.updateIndefiniteIndicatorImage();
            } else if (this.image == null && this.mode != 0) {
                this.createIndicatorImage();
            }
        }
        if (!this.isInitialized) return;
        this.repaint();
    }

    private void createIndicatorImage() {
        int percentage = this.value * 100 / this.maxValue;
        int position = percentage * (this.contentWidth - this.valueWidth) / 100;
        if (position == 0) {
            position = 1;
        }
        this.indicatorImage = Image.createImage((int)position, (int)this.contentHeight);
        Graphics g = this.indicatorImage.getGraphics();
        if (this.image != null) {
            int imageWidth = this.image.getWidth();
            for (int x = 0; x < position; x += imageWidth) {
                g.drawImage(this.image, x, 0, 20);
            }
        } else if (this.mode == 1) {
            g.setColor(this.color);
            g.fillRect(0, 0, position, this.contentHeight);
            g.setColor(this.gapColor);
            for (int x = this.chunkWidth; x < position; x += this.gapWidth + this.chunkWidth) {
                g.fillRect(x, 0, this.gapWidth, this.contentHeight);
            }
        } else {
            g.setColor(this.color);
            g.fillRect(0, 0, position, this.contentHeight);
        }
    }

    private void updateIndefiniteIndicatorImage() {
        Graphics g = this.indicatorImage.getGraphics();
        if (this.value == 0 || this.value == 1) {
            g.setColor(this.gapColor);
            g.fillRect(0, 0, this.contentWidth, this.contentHeight);
        } else if (this.value == 2) {
            g.setColor(this.color);
            g.fillRect(0, 0, this.contentWidth, this.contentHeight);
            g.setColor(this.gapColor);
            int cWidth = this.chunkWidth + this.gapWidth;
            for (int x = this.indefinitePos - cWidth; x < this.contentWidth; x += cWidth) {
                g.fillRect(x, 0, this.gapWidth, this.contentHeight);
            }
        } else {
            int percentage = this.indefinitePos * 100 / this.maxValue;
            int position = percentage * this.contentWidth / 100;
            g.setColor(this.gapColor);
            g.fillRect(0, 0, this.contentWidth, this.contentHeight);
            g.setColor(this.color);
            int cWidth = this.chunkWidth + this.gapWidth;
            for (int x = 0; x < position; x += cWidth) {
                g.fillRect(x, 0, this.chunkWidth, this.contentHeight);
            }
        }
    }

    public int getValue() {
        return this.value;
    }

    public void setMaxValue(int maxValue) {
        this.isInitialized = false;
        if (maxValue == -1) {
            if (this.maxValue != maxValue) {
                this.value = 0;
            }
            this.isIndefinite = true;
        } else {
            if (maxValue < 0) {
                throw new IllegalArgumentException();
            }
            if (this.value == 2) {
                this.isIndefinite = false;
                AnimationThread.removeAnimationItem(this);
            }
        }
        this.maxValue = maxValue;
        this.isInitialized = false;
    }

    public int getMaxValue() {
        return this.maxValue;
    }

    public boolean isInteractive() {
        return this.isInteractive;
    }

    public void paintContent(int x, int y, int leftBorder, int rightBorder, Graphics g) {
        if (this.showValue && this.valuePosition == 0) {
            g.setFont(this.font);
            g.setColor(this.fontColor);
            g.drawString(this.valueString, x, y, 20);
            x += this.valueWidth;
        }
        if (this.isIndefinite) {
            if (this.image != null) {
                g.drawImage(this.image, x + this.indefinitePos, y + this.imageYOffset, 20);
            } else if (this.indicatorImage != null) {
                g.drawImage(this.indicatorImage, x, y + this.imageYOffset, 20);
            }
        } else if (this.image != null) {
            if (this.value != 0) {
                int width = this.image.getWidth() * this.value / this.maxValue;
                int clipX = g.getClipX();
                int clipY = g.getClipY();
                int clipWidth = g.getClipWidth();
                int clipHeight = g.getClipHeight();
                g.clipRect(x, clipY, width, clipHeight);
                g.drawImage(this.image, x, y + this.imageYOffset, 20);
                g.setClip(clipX, clipY, clipWidth, clipHeight);
            }
        } else if (this.mode == 0) {
            g.setColor(this.color);
            int maxWidth = this.contentWidth;
            if (this.showValue && this.valuePosition != 2) {
                maxWidth -= this.valueWidth;
            }
            int w = maxWidth * this.value / this.maxValue;
            g.fillRect(x, y, w + 1, this.contentHeight + 1);
        } else {
            g.drawImage(this.indicatorImage, x, y, 20);
        }
        if (this.showValue) {
            if (this.valuePosition == 1) {
                g.setFont(this.font);
                g.setColor(this.fontColor);
                g.drawString(this.valueString, rightBorder, y, 24);
            } else if (this.valuePosition == 2) {
                g.setFont(this.font);
                g.setColor(this.fontColor);
                g.drawString(this.valueString, leftBorder + (rightBorder - leftBorder >> 1), y, 17);
            }
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    protected void initContent(int firstLineWidth, int lineWidth) {
        this.valueWidth = 0;
        int valueHeight = 0;
        if (this.isIndefinite) {
            this.showValue = false;
        }
        if (this.showValue) {
            if (this.font == null) {
                this.font = Font.getDefaultFont();
            }
            valueHeight = this.font.getHeight();
            this.valueWidth = this.font.stringWidth("" + this.maxValue) + this.paddingHorizontal;
        }
        if (this.preferredHeight > 0) {
            this.contentHeight = this.preferredHeight;
            if (this.image != null) {
                int imageHeight = this.image.getHeight();
                if ((this.layout & 0x20) == 32) {
                    this.imageYOffset = this.preferredHeight - imageHeight;
                } else if ((this.layout & 0x30) == 48) {
                    this.imageYOffset = (this.preferredHeight - imageHeight) / 2;
                }
            }
        } else {
            this.contentHeight = this.image != null ? this.image.getHeight() : 10;
        }
        if (this.contentHeight < valueHeight) {
            this.contentHeight = valueHeight;
        }
        this.contentWidth = this.image != null && !this.isIndefinite && this.preferredWidth == 0 ? this.image.getWidth() + this.valueWidth : (this.preferredWidth > 0 ? this.preferredWidth + this.valueWidth : (this.isLayoutExpand ? lineWidth : ((this.layout & 0x400) == 1024 ? Math.max(lineWidth / 3, 10) : firstLineWidth)));
        if (this.isIndefinite) {
            this.maxValue = this.image != null ? (this.value == 0 || this.value == 2 ? this.contentWidth : this.contentWidth / this.image.getWidth()) : 20;
            int imageWidth = this.contentWidth - this.valueWidth;
            int imageHeight = this.contentHeight;
            if (imageWidth <= 0 || imageHeight <= 0) throw new IllegalArgumentException("invalid lineWidth for gauge: " + lineWidth);
            this.indicatorImage = Image.createImage((int)imageWidth, (int)imageHeight);
            this.updateIndefiniteIndicatorImage();
            return;
        } else {
            if (this.image != null || this.mode == 0) return;
            this.createIndicatorImage();
        }
    }

    protected String createCssSelector() {
        return "gauge";
    }

    public void setStyle(Style style) {
        super.setStyle(style);
        if (this.maxValue != -1) {
            if (style.font != null) {
                this.font = style.font;
            }
            this.fontColor = style.getFontColor();
        }
    }

    protected boolean handleKeyPressed(int keyCode, int gameAction) {
        if (!this.isInteractive) {
            return false;
        }
        if (gameAction == 5) {
            if (this.value < this.maxValue) {
                this.setValue(++this.value);
                this.notifyStateChanged();
                return true;
            }
            return true;
        }
        if (gameAction == 2) {
            if (this.value > 0) {
                this.setValue(--this.value);
                this.notifyStateChanged();
                return true;
            }
            return true;
        }
        return false;
    }

    public boolean animate() {
        boolean animated = super.animate();
        if (this.view != null) {
            return animated;
        }
        if (this.isIndefinite && this.value == 2 && this.isInitialized) {
            ++this.indefinitePos;
            if (this.image == null) {
                if (this.indefinitePos > this.chunkWidth + this.gapWidth) {
                    this.indefinitePos = 0;
                }
                this.updateIndefiniteIndicatorImage();
            } else if (this.indefinitePos > this.maxValue) {
                this.indefinitePos = -this.image.getWidth();
            }
            return true;
        }
        return animated;
    }

    protected void hideNotify() {
        super.hideNotify();
        if (this.isIndefinite && this.value == 2) {
            AnimationThread.removeAnimationItem(this);
        }
        this.isShown = false;
    }

    protected void showNotify() {
        super.showNotify();
        if (this.isIndefinite && this.value == 2) {
            AnimationThread.addAnimationItem(this);
        }
        this.isShown = true;
    }
}

