/*
 * Decompiled with CFR 0.152.
 */
package de.enough.polish.ui;

import de.enough.polish.ui.Container;
import de.enough.polish.ui.Item;
import de.enough.polish.ui.StringItem;
import de.enough.polish.ui.Style;
import de.enough.polish.ui.StyleSheet;
import de.enough.polish.util.Debug;
import java.io.IOException;
import javax.microedition.lcdui.Graphics;
import javax.microedition.lcdui.Image;

public class IconItem
extends StringItem {
    protected Image image;
    protected int imageAlign = 4;
    protected int imageHeight;
    protected int imageWidth;
    protected int yAdjustText;
    protected boolean isTextVisible = true;
    protected int relativeIconX;
    protected int relativeIconY;

    public IconItem(String text, Image image) {
        this(null, text, image, null);
    }

    public IconItem(String text, Image image, Style style) {
        this(null, text, image, style);
    }

    public IconItem(String label, String text, Image image) {
        this(label, text, image, null);
    }

    public IconItem(String label, String text, Image image, Style style) {
        super(label, text, 1, style);
        if (image != null) {
            this.setImage(image);
        }
    }

    protected String createCssSelector() {
        return "icon";
    }

    protected void initContent(int firstLineWidth, int lineWidth) {
        if (this.image == null) {
            super.initContent(firstLineWidth, lineWidth);
            return;
        }
        this.imageWidth = this.image.getWidth();
        this.imageHeight = this.image.getHeight();
        int yAdjustImage = 0;
        if (this.imageAlign == 4 || this.imageAlign == 8) {
            int verticalAlign;
            this.imageWidth += this.paddingHorizontal;
            firstLineWidth -= this.imageWidth;
            lineWidth -= this.imageWidth;
            if (this.isTextVisible) {
                super.initContent(firstLineWidth, lineWidth);
            } else {
                this.contentWidth = 0;
                this.contentHeight = this.imageHeight;
            }
            if (this.imageHeight > this.contentHeight) {
                verticalAlign = this.layout & 0x30;
                this.yAdjustText = verticalAlign == 48 || verticalAlign == 0 ? (this.imageHeight - this.contentHeight) / 2 : (verticalAlign == 32 ? this.imageHeight - this.contentHeight : 0);
                this.contentHeight = this.imageHeight;
            } else if (this.contentHeight > this.imageHeight) {
                this.yAdjustText = 0;
                verticalAlign = this.layout & 0x30;
                if (verticalAlign == 48 || verticalAlign == 0) {
                    yAdjustImage = (this.contentHeight - this.imageHeight) / 2;
                } else if (verticalAlign == 32) {
                    yAdjustImage = this.contentHeight - this.imageHeight;
                }
            } else {
                this.yAdjustText = 0;
            }
            if (this.isLayoutExpand && this.imageAlign == 8) {
                this.contentWidth = firstLineWidth;
            }
            this.contentWidth += this.imageWidth;
        } else {
            this.imageHeight += this.paddingVertical;
            if (this.isTextVisible) {
                super.initContent(firstLineWidth, lineWidth);
            } else {
                this.contentHeight = 0;
                this.contentWidth = 0;
            }
            this.contentHeight += this.imageHeight;
            if (this.imageWidth > this.contentWidth) {
                this.contentWidth = this.imageWidth;
            }
        }
        int iconLeftX = 0;
        int iconTopY = yAdjustImage;
        if (this.imageAlign != 4) {
            if (this.imageAlign == 8) {
                iconLeftX = firstLineWidth;
            } else {
                iconLeftX = this.isLayoutExpand ? firstLineWidth - this.imageWidth >> 1 : this.contentWidth - this.imageWidth >> 1;
                if (this.imageAlign == 32) {
                    iconTopY += this.contentHeight - this.imageHeight;
                }
            }
        }
        this.relativeIconX = iconLeftX;
        this.relativeIconY = iconTopY;
    }

    public void paintContent(int x, int y, int leftBorder, int rightBorder, Graphics g) {
        if (this.image != null) {
            g.drawImage(this.image, x + this.relativeIconX, y + this.relativeIconY, 20);
            if (this.imageAlign == 4) {
                x += this.imageWidth;
                leftBorder += this.imageWidth;
                y += this.yAdjustText;
            } else if (this.imageAlign == 8) {
                rightBorder -= this.imageWidth;
                y += this.yAdjustText;
            } else if (this.imageAlign == 16) {
                y += this.imageHeight;
            }
        }
        if (this.isTextVisible) {
            super.paintContent(x, y, leftBorder, rightBorder, g);
        }
    }

    public Image getImage() {
        return this.image;
    }

    public void setStyle(Style style) {
        super.setStyle(style);
        String imageName = style.getProperty(6);
        if (imageName != null) {
            Item item = this;
            Item container = this.parent;
            while (container != null && !(container instanceof Container) && container.parent != null) {
                item = container;
                container = container.parent;
            }
            if (container instanceof Container) {
                imageName = ((Container)container).parseIndexUrl(imageName, item);
            } else if (imageName.indexOf("%INDEX%") != -1) {
                throw new IllegalStateException("IconItem cannot resolve %INDEX% in url since parent is not a container: " + container + ", parent=" + this.parent);
            }
            try {
                Image img = StyleSheet.getImage(imageName, this, true);
                if (img != null) {
                    this.image = img;
                }
            }
            catch (IOException e) {
                Debug.debug("error", "de.enough.polish.ui.IconItem", 382, (Object)("unable to load image [" + imageName + "]"), e);
            }
        }
    }

    public void setImage(String url) {
        try {
            Image img = StyleSheet.getImage(url, this, false);
            if (img != null) {
                this.setImage(img);
            }
        }
        catch (IOException e) {
            Debug.debug("error", "de.enough.polish.ui.IconItem", 447, (Object)("unable to load image [" + url + "]"), e);
        }
    }

    public void setImage(Image image) {
        this.setImage(image, null);
    }

    public void setImage(Image img, Style style) {
        if (style != null) {
            this.setStyle(style);
        }
        this.image = img;
        this.requestInit();
    }

    public void setImageAlign(int imageAlign) {
        this.imageAlign = imageAlign;
        this.isInitialized = false;
    }

    public void releaseResources() {
        super.releaseResources();
        this.isStyleInitialised = false;
        this.isInitialized = false;
    }

    public boolean isTextVisible() {
        return this.isTextVisible;
    }

    public void setTextVisible(boolean isTextVisible) {
        this.isTextVisible = isTextVisible;
        if (!isTextVisible) {
            this.textLines = null;
        }
        this.isInitialized = false;
    }
}

