/*
 * Decompiled with CFR 0.152.
 */
package de.enough.polish.ui;

import de.enough.polish.ui.Item;
import de.enough.polish.ui.Style;
import javax.microedition.lcdui.Font;
import javax.microedition.lcdui.Graphics;
import javax.microedition.lcdui.Image;

public class ImageItem
extends Item {
    private Image image;
    private String altText;
    private int textColor;
    private Font font;
    private int yOffset;
    private int height = -1;
    private int xOffset;
    private int xOverlap;

    public ImageItem(String label, Image image, int layout, String altText) {
        this(label, image, layout, altText, 0, null);
    }

    public ImageItem(String label, Image image, int layout, String altText, Style style) {
        this(label, image, layout, altText, 0, style);
    }

    public ImageItem(String label, Image image, int layout, String altText, int appearanceMode) {
        this(label, image, layout, altText, appearanceMode, null);
    }

    public ImageItem(String label, Image image, int layout, String altText, int appearanceMode, Style style) {
        super(label, layout, appearanceMode, style);
        this.image = image;
        this.altText = altText;
    }

    public Image getImage() {
        return this.image;
    }

    public void setImage(Image image) {
        this.image = image;
        this.xOffset = 0;
        this.requestInit();
        this.repaint();
    }

    public String getAltText() {
        return this.altText;
    }

    public void setAltText(String text) {
        this.altText = text;
        if (this.image == null) {
            this.isInitialized = false;
            this.repaint();
        }
    }

    public void paintContent(int x, int y, int leftBorder, int rightBorder, Graphics g) {
        if (this.image != null) {
            int clipX = 0;
            int clipY = 0;
            int clipWidth = 0;
            int clipHeight = 0;
            if (this.xOverlap != 0) {
                clipX = g.getClipX();
                clipY = g.getClipY();
                clipWidth = g.getClipWidth();
                clipHeight = g.getClipHeight();
                g.clipRect(x, clipY, this.contentWidth, clipHeight);
            }
            y += this.yOffset;
            x += this.xOffset;
            if (this.isLayoutExpand) {
                if (this.isLayoutCenter) {
                    g.drawImage(this.image, x + (rightBorder - x) / 2, y, 17);
                } else if (this.isLayoutRight) {
                    g.drawImage(this.image, rightBorder, y, 24);
                } else {
                    g.drawImage(this.image, x, y, 20);
                }
            } else {
                g.drawImage(this.image, x, y, 20);
            }
            if (this.xOverlap != 0) {
                g.setClip(clipX, clipY, clipWidth, clipHeight);
            }
        } else if (this.altText != null) {
            g.setColor(this.textColor);
            g.setFont(this.font);
            g.drawString(this.altText, x, y, 20);
        }
    }

    protected void initContent(int firstLineWidth, int lineWidth) {
        this.xOverlap = 0;
        if (this.image != null) {
            this.contentHeight = this.image.getHeight();
            this.contentWidth = this.image.getWidth();
            if (this.contentWidth > lineWidth) {
                this.xOverlap = this.contentWidth - lineWidth;
                this.contentWidth = lineWidth;
                this.appearanceMode = 3;
            }
        } else if (this.altText != null) {
            if (this.font == null) {
                this.font = Font.getDefaultFont();
            }
            this.contentHeight = this.font.getHeight();
            this.contentWidth = this.font.stringWidth(this.altText);
        } else {
            this.contentHeight = 0;
            this.contentWidth = 0;
        }
        if (this.height != -1) {
            this.contentHeight = this.height;
        }
    }

    protected String createCssSelector() {
        return "img";
    }

    public void setStyle(Style style) {
        super.setStyle(style);
        this.textColor = style.getFontColor();
        this.font = style.font;
    }

    protected boolean handleKeyPressed(int keyCode, int gameAction) {
        if (this.xOverlap != 0) {
            if (gameAction == 5 && keyCode != 54 && this.xOffset + this.xOverlap > 0) {
                int offset = this.xOffset - 10;
                if (offset + this.xOverlap < 0) {
                    offset = -this.xOverlap;
                }
                this.xOffset = offset;
                return true;
            }
            if (gameAction == 2 && keyCode != 52 && this.xOffset < 0) {
                int offset = this.xOffset + 10;
                if (offset > 0) {
                    offset = 0;
                }
                this.xOffset = offset;
                return true;
            }
        }
        return super.handleKeyPressed(keyCode, gameAction);
    }
}

