/*
 * Decompiled with CFR 0.152.
 */
package de.enough.polish.ui;

import de.enough.polish.ui.Background;
import de.enough.polish.ui.ClippingRegion;
import de.enough.polish.ui.CommandItem;
import de.enough.polish.ui.Container;
import de.enough.polish.ui.Item;
import de.enough.polish.ui.Screen;
import de.enough.polish.ui.Style;
import de.enough.polish.ui.StyleSheet;
import de.enough.polish.ui.backgrounds.TranslucentSimpleBackground;
import de.enough.polish.util.ArrayList;
import de.enough.polish.util.Debug;
import java.util.Enumeration;
import java.util.Hashtable;
import javax.microedition.lcdui.Command;
import javax.microedition.lcdui.Graphics;
import javax.microedition.lcdui.Image;

public class MenuBar
extends Item {
    protected final ArrayList commandsList;
    private final Container commandsContainer;
    protected boolean isOpened;
    private Command singleLeftCommand;
    private final CommandItem singleLeftCommandItem;
    private Command singleRightCommand;
    private final CommandItem singleRightCommandItem;
    private Command singleMiddleCommand;
    private final CommandItem singleMiddleCommandItem;
    private int topY;
    private int commandsContainerWidth;
    protected boolean isSoftKeyPressed;
    protected boolean canScrollDownwards;
    protected boolean canScrollUpwards;
    protected boolean paintScrollIndicator;
    protected Image optionsImage;
    protected boolean showImageAndText;
    protected Image selectImage;
    protected Image cancelImage;
    protected Background overlayBackground;
    protected final Hashtable allCommands;
    protected boolean isOrientationVertical;
    protected Style menuItemStyle;
    private static Command tmpMiddleCommand = new Command("", 4, -1);

    public MenuBar(Screen screen) {
        this(screen, null);
    }

    public MenuBar(Screen screen, Style style) {
        super(style);
        this.screen = screen;
        this.commandsList = new ArrayList();
        this.allCommands = new Hashtable();
        this.commandsContainer = new Container(true, StyleSheet.menuStyle);
        if (this.commandsContainer.style != null) {
            this.commandsContainer.setStyle(this.commandsContainer.style);
        }
        this.commandsContainer.layout |= 0x400;
        this.commandsContainer.screen = screen;
        this.commandsContainer.parent = this;
        Command dummy = new Command("", 8, 10000);
        this.singleRightCommandItem = new CommandItem(dummy, this, StyleSheet.rightcommandStyle);
        this.singleRightCommandItem.setImageAlign(4);
        this.singleLeftCommandItem = new CommandItem(dummy, this, StyleSheet.leftcommandStyle);
        this.singleLeftCommandItem.setImageAlign(4);
        this.singleMiddleCommandItem = new CommandItem(dummy, this, StyleSheet.middlecommandStyle);
        this.singleMiddleCommandItem.setImageAlign(4);
    }

    public void addCommand(Command cmd) {
        if (this.menuItemStyle != null) {
            this.addCommand(cmd, this.menuItemStyle);
        } else {
            this.addCommand(cmd, StyleSheet.menuitemStyle);
        }
    }

    public void addCommand(Command cmd, Style commandStyle) {
        if (cmd == this.singleLeftCommand || cmd == this.singleRightCommand || cmd == this.singleMiddleCommand || this.commandsList.contains(cmd)) {
            return;
        }
        CommandItem item = new CommandItem(cmd, this, commandStyle);
        this.allCommands.put(cmd, item);
        int type = cmd.getCommandType();
        int priority = cmd.getPriority();
        if (type == 8 || type == 4) {
            if (this.singleMiddleCommand == null) {
                this.singleMiddleCommand = cmd;
                this.singleMiddleCommandItem.setImage((Image)null);
                this.singleMiddleCommandItem.setText(cmd.getLabel());
                if (this.isInitialized) {
                    this.isInitialized = false;
                    this.repaint();
                }
                return;
            }
            if (this.singleMiddleCommand.getPriority() > priority) {
                Command oldMiddleCommand = this.singleMiddleCommand;
                this.singleMiddleCommand = cmd;
                this.singleMiddleCommandItem.setText(cmd.getLabel());
                cmd = oldMiddleCommand;
                item = (CommandItem)this.allCommands.get(cmd);
                priority = oldMiddleCommand.getPriority();
            }
        }
        if (type == 2 || type == 3 || type == 7) {
            if (this.singleRightCommand == null) {
                this.singleRightCommand = cmd;
                this.singleRightCommandItem.setImage((Image)null);
                this.singleRightCommandItem.setText(cmd.getLabel());
                if (this.isInitialized) {
                    this.isInitialized = false;
                    this.repaint();
                }
                return;
            }
            if (this.singleRightCommand.getPriority() > priority) {
                Command oldRightCommand = this.singleRightCommand;
                this.singleRightCommand = cmd;
                this.singleRightCommandItem.setText(cmd.getLabel());
                cmd = oldRightCommand;
                item = (CommandItem)this.allCommands.get(cmd);
                priority = oldRightCommand.getPriority();
            }
        }
        if (this.singleLeftCommand != null) {
            CommandItem singleItem = (CommandItem)this.allCommands.get(this.singleLeftCommand);
            this.commandsList.add(this.singleLeftCommand);
            this.commandsContainer.add(singleItem);
            this.singleLeftCommand = null;
        } else if (this.commandsList.size() == 0) {
            this.singleLeftCommand = cmd;
            this.singleLeftCommandItem.setText(cmd.getLabel());
            if (this.isInitialized) {
                this.isInitialized = false;
                this.repaint();
            }
            return;
        }
        this.addCommand(item);
        if (this.isInitialized) {
            this.isInitialized = false;
            this.repaint();
        }
    }

    public void removeCommand(Command cmd) {
        int index;
        this.allCommands.remove(cmd);
        if (cmd == this.singleMiddleCommand) {
            Command newMiddleCommand;
            this.singleMiddleCommand = newMiddleCommand = this.extractNextMiddleCommand();
            if (newMiddleCommand == null) {
                this.singleMiddleCommandItem.setText(null);
            } else {
                this.singleMiddleCommandItem.setText(newMiddleCommand.getLabel());
            }
            if (this.isInitialized) {
                this.isInitialized = false;
                this.repaint();
            }
            return;
        }
        if (cmd == this.singleLeftCommand) {
            this.singleLeftCommand = null;
            if (this.isInitialized) {
                this.isInitialized = false;
                this.repaint();
            }
        }
        if (cmd == this.singleRightCommand) {
            this.singleRightCommand = null;
            if (this.singleLeftCommand != null) {
                if (this.singleLeftCommand.getCommandType() == 2 || this.singleLeftCommand.getCommandType() == 3) {
                    this.singleRightCommand = this.singleLeftCommand;
                    this.singleRightCommandItem.setText(this.singleLeftCommand.getLabel());
                    this.singleLeftCommand = null;
                }
                if (this.isInitialized) {
                    this.isInitialized = false;
                    this.repaint();
                }
                return;
            }
            int newSingleRightCommandIndex = this.getNextNegativeOrPositiveCommandIndex(true);
            if (newSingleRightCommandIndex != -1) {
                if (newSingleRightCommandIndex == this.commandsContainer.getFocusedIndex()) {
                    this.commandsContainer.focus(-1);
                }
                this.singleRightCommand = (Command)this.commandsList.remove(newSingleRightCommandIndex);
                this.commandsContainer.remove(newSingleRightCommandIndex);
                this.singleRightCommandItem.setText(this.singleRightCommand.getLabel());
            }
        }
        if ((index = this.commandsList.indexOf(cmd)) != -1) {
            if (index == this.commandsContainer.getFocusedIndex()) {
                this.commandsContainer.focus(-1);
            }
            this.commandsList.remove(index);
            this.commandsContainer.remove(index);
        }
        if (this.commandsList.size() == 1) {
            CommandItem item = (CommandItem)this.commandsContainer.get(0);
            if (!item.hasChildren) {
                Command command = (Command)this.commandsList.remove(0);
                this.commandsContainer.focus(-1);
                this.commandsContainer.remove(0);
                this.singleLeftCommand = command;
                this.singleLeftCommandItem.setText(command.getLabel());
            }
        }
        if (this.isInitialized) {
            this.isInitialized = false;
            this.repaint();
        }
    }

    private Command extractNextMiddleCommand() {
        Command command;
        Command next = null;
        next = this.getNextMiddleCommand(next, this.singleLeftCommand);
        next = this.getNextMiddleCommand(next, this.singleRightCommand);
        Object[] myCommands = this.commandsList.getInternalArray();
        int index = -1;
        for (int i = 0; i < myCommands.length && (command = (Command)myCommands[i]) != null; ++i) {
            Command cmd = this.getNextMiddleCommand(next, command);
            if (cmd == next) continue;
            index = i;
            next = cmd;
        }
        if (next != null) {
            if (next == this.singleLeftCommand) {
                this.singleLeftCommand = null;
                this.singleLeftCommandItem.setText(null);
                index = this.getNextNegativeOrPositiveCommandIndex(false);
                if (index != -1) {
                    this.singleLeftCommand = (Command)this.commandsList.remove(index);
                    this.commandsContainer.remove(index);
                    this.singleLeftCommandItem.setText(this.singleLeftCommand.getLabel());
                }
            } else if (next == this.singleRightCommand) {
                this.singleRightCommand = null;
                this.singleRightCommandItem.setText(null);
                index = this.getNextNegativeOrPositiveCommandIndex(false);
                if (index != -1) {
                    this.singleRightCommand = (Command)this.commandsList.remove(index);
                    this.commandsContainer.remove(index);
                    this.singleRightCommandItem.setText(this.singleRightCommand.getLabel());
                }
            } else {
                if (index == this.commandsContainer.focusedIndex) {
                    this.commandsContainer.focus(-1);
                }
                this.commandsContainer.remove(index);
                this.commandsList.remove(index);
            }
        }
        return next;
    }

    private Command getNextMiddleCommand(Command current, Command cmd) {
        int commandType;
        if (!(cmd == null || (commandType = cmd.getCommandType()) != 4 && commandType != 8 || current != null && cmd.getPriority() >= current.getPriority())) {
            return cmd;
        }
        return current;
    }

    private int getNextNegativeOrPositiveCommandIndex(boolean isNegative) {
        Command command;
        Object[] myCommands = this.commandsList.getInternalArray();
        int maxPriority = Integer.MAX_VALUE;
        int maxPriorityId = -1;
        for (int i = 0; i < myCommands.length && (command = (Command)myCommands[i]) != null; ++i) {
            int type = command.getCommandType();
            if ((!isNegative || type != 2 && type != 3 && type != 6 && type != 7) && (isNegative || type != 4 && type != 8 && type != 1) || command.getPriority() >= maxPriority) continue;
            maxPriority = command.getPriority();
            maxPriorityId = i;
        }
        return maxPriorityId;
    }

    protected void initContent(int firstLineWidth, int lineWidth) {
        int availableWidth;
        if (this.isOpened) {
            int titleHeight = this.screen.titleHeight;
            int screenHeight = this.screen.screenHeight;
            this.topY = titleHeight;
            this.commandsContainer.setScrollHeight(screenHeight - titleHeight);
            this.commandsContainerWidth = this.screen.screenWidth;
            int containerHeight = this.commandsContainer.getItemHeight(this.commandsContainerWidth, this.commandsContainerWidth);
            this.commandsContainerWidth = this.commandsContainer.itemWidth;
            int commandsContainerY = screenHeight - containerHeight - 1;
            if (commandsContainerY < titleHeight) {
                containerHeight -= titleHeight - commandsContainerY;
                commandsContainerY = titleHeight;
            }
            this.commandsContainer.relativeY = -containerHeight;
            this.commandsContainer.relativeX = 0;
            this.canScrollUpwards = this.commandsContainer.yOffset != 0 && this.commandsContainer.focusedIndex != 0;
            this.canScrollDownwards = this.commandsContainer.yOffset + containerHeight > screenHeight - titleHeight && this.commandsContainer.focusedIndex != this.commandsList.size() - 1;
            this.paintScrollIndicator = this.canScrollUpwards || this.canScrollDownwards;
            CommandItem item = this.singleLeftCommandItem;
            if (this.selectImage != null) {
                item.setImage(this.selectImage);
                if (this.showImageAndText) {
                    item.setText("\u9009\u62e9");
                } else {
                    item.setText(null);
                }
            } else {
                item.setImage((Image)null);
                item.setText("\u9009\u62e9");
            }
            item = this.singleRightCommandItem;
            if (this.cancelImage != null) {
                item.setImage(this.cancelImage);
                if (this.showImageAndText) {
                    item.setText("\u53d6\u6d88");
                } else {
                    item.setText(null);
                }
            } else {
                item.setText("\u53d6\u6d88");
            }
        } else {
            CommandItem item;
            if (this.singleLeftCommand == null && this.singleRightCommand == null && this.singleMiddleCommand == null && this.commandsList.size() == 0) {
                this.contentWidth = 0;
                this.contentHeight = 0;
                return;
            }
            this.paintScrollIndicator = false;
            if (this.singleRightCommand != null) {
                item = (CommandItem)this.allCommands.get(this.singleRightCommand);
                this.singleRightCommandItem.setText(item.getText());
            } else {
                this.singleRightCommandItem.setText(null);
            }
            this.singleRightCommandItem.setImage((Image)null);
            if (this.commandsList.size() > 0) {
                item = this.singleLeftCommandItem;
                if (this.optionsImage != null) {
                    item.setImage(this.optionsImage);
                    if (this.showImageAndText) {
                        item.setText("\u9009\u9879");
                    } else {
                        item.setText(null);
                    }
                } else {
                    item.setImage((Image)null);
                    item.setText("\u9009\u9879");
                }
            }
        }
        this.singleRightCommandItem.relativeX = availableWidth = lineWidth >> 1;
        int height = Math.max(this.singleLeftCommandItem.getItemHeight(availableWidth, availableWidth), this.singleRightCommandItem.getItemHeight(availableWidth, availableWidth));
        this.contentHeight = height = Math.max(height, this.singleMiddleCommandItem.getItemHeight(availableWidth, availableWidth));
        this.singleLeftCommandItem.relativeY = (this.singleLeftCommandItem.layout & 0x30) == 48 ? this.contentHeight - this.singleLeftCommandItem.itemHeight >> 1 : ((this.singleLeftCommandItem.layout & 0x20) == 32 ? this.contentHeight - this.singleLeftCommandItem.itemHeight : 0);
        this.singleRightCommandItem.relativeY = (this.singleRightCommandItem.layout & 0x30) == 48 ? this.contentHeight - this.singleRightCommandItem.itemHeight >> 1 : ((this.singleRightCommandItem.layout & 0x20) == 32 ? this.contentHeight - this.singleRightCommandItem.itemHeight : 0);
        this.contentWidth = lineWidth;
    }

    protected void paintBackgroundAndBorder(int x, int y, int width, int height, Graphics g) {
        if (this.isOpened && this.overlayBackground != null) {
            this.overlayBackground.paint(0, this.screen.contentY, this.screen.screenWidth, this.screen.screenHeight, g);
        }
        super.paintBackgroundAndBorder(x, y, width, height, g);
    }

    protected void paintContent(int x, int y, int leftBorder, int rightBorder, Graphics g) {
        if (this.isOpened) {
            int clipX = g.getClipX();
            int clipY = g.getClipY();
            int clipWidth = g.getClipWidth();
            int clipHeight = g.getClipHeight();
            g.setClip(0, this.topY, this.screen.screenWidth, this.screen.screenHeight - this.topY);
            this.commandsContainer.paint(x + this.commandsContainer.relativeX, y + this.commandsContainer.relativeY, x + this.commandsContainer.relativeX, x + this.commandsContainer.relativeX + this.commandsContainerWidth, g);
            g.setClip(clipX, clipY, clipWidth, clipHeight);
            int centerX = leftBorder + (rightBorder - leftBorder >> 1);
            this.singleLeftCommandItem.paint(leftBorder, y + this.singleLeftCommandItem.relativeY, leftBorder, centerX, g);
            this.singleRightCommandItem.paint(centerX, y + this.singleRightCommandItem.relativeY, centerX, rightBorder, g);
        } else {
            int centerX = leftBorder + (rightBorder - leftBorder >> 1);
            if (this.singleMiddleCommand != null) {
                int width = rightBorder - leftBorder >>> 1;
                int commandWidth = this.singleMiddleCommandItem.getItemWidth(width, width);
                this.singleMiddleCommandItem.paint(centerX - (commandWidth >>> 1), y + this.singleMiddleCommandItem.relativeY, leftBorder + (width >>>= 1), rightBorder - width, g);
            }
            if (this.commandsContainer.size() > 0 || this.singleLeftCommand != null) {
                this.singleLeftCommandItem.paint(leftBorder, y + this.singleLeftCommandItem.relativeY, leftBorder, centerX, g);
            }
            if (this.singleRightCommand != null) {
                this.singleRightCommandItem.paint(centerX, y + this.singleRightCommandItem.relativeY, centerX, rightBorder, g);
            }
        }
    }

    protected String createCssSelector() {
        return "menubar";
    }

    protected void setOpen(boolean open) {
        if (!open && this.isOpened) {
            this.commandsContainer.hideNotify();
            this.isInitialized = open == this.isOpened;
            this.isOpened = open;
        } else if (open && !this.isOpened) {
            this.isInitialized = open == this.isOpened;
            this.isOpened = open;
            this.commandsContainer.focus(0);
            this.commandsContainer.showNotify();
        }
    }

    protected boolean handleKeyPressed(int keyCode, int gameAction) {
        this.isSoftKeyPressed = false;
        if (this.isOpened) {
            if (this.isSelectOptionsMenuKey(keyCode, gameAction)) {
                this.isSoftKeyPressed = true;
                MenuBar.notifyKeyPressed();
                CommandItem commandItem = (CommandItem)this.commandsContainer.getFocusedItem();
                commandItem.handleKeyPressed(0, 8);
                return true;
            }
            if (this.isCloseOptionsMenuKey(keyCode, gameAction)) {
                this.isSoftKeyPressed = true;
                MenuBar.notifyKeyPressed();
                this.commandsContainer.handleKeyPressed(0, 2);
                return true;
            }
            boolean handled = this.commandsContainer.handleKeyPressed(keyCode, gameAction);
            if (handled) {
                this.isInitialized = false;
            } else {
                CommandItem item;
                int index;
                if (gameAction == 6 || gameAction == 1) {
                    Debug.debug("error", "de.enough.polish.ui.MenuBar", 1169, (Object)("Container DID NOT HANDLE DOWN OR UP, selectedIndex=" + this.commandsContainer.getFocusedIndex() + ", count=" + this.commandsContainer.size() + ", cycling="), this.commandsContainer.allowCycling);
                    Debug.debug("error", "de.enough.polish.ui.MenuBar", 1176, (Object)("view-type of container " + this.commandsContainer + " = "), this.commandsContainer.containerView);
                }
                if (keyCode >= 49 && keyCode <= 57 && (index = keyCode - 49) <= this.commandsContainer.size() && (item = (CommandItem)this.commandsContainer.get(index)).getAppearanceMode() != 0) {
                    if (!item.isFocused) {
                        this.commandsContainer.focus(index);
                    }
                    handled = item.handleKeyPressed(0, 8);
                    return handled;
                }
            }
            return true;
        }
        if (keyCode == -5 && this.singleMiddleCommand != null && this.singleMiddleCommandItem.getAppearanceMode() != 0) {
            this.isSoftKeyPressed = true;
            MenuBar.notifyKeyPressed();
            this.singleMiddleCommandItem.notifyItemPressedStart();
            return true;
        }
        if (this.singleLeftCommand != null && this.screen.isSoftKeyLeft(keyCode, gameAction) && this.singleLeftCommandItem.getAppearanceMode() != 0) {
            this.isSoftKeyPressed = true;
            MenuBar.notifyKeyPressed();
            this.singleLeftCommandItem.notifyItemPressedStart();
            return true;
        }
        if (this.singleRightCommand != null && this.screen.isSoftKeyRight(keyCode, gameAction) && this.singleRightCommandItem.getAppearanceMode() != 0) {
            this.isSoftKeyPressed = true;
            MenuBar.notifyKeyPressed();
            this.singleRightCommandItem.notifyItemPressedStart();
            return true;
        }
        if (this.isOpenOptionsMenuKey(keyCode, gameAction)) {
            this.isSoftKeyPressed = true;
            CommandItem item = this.getOpenOptionsItem();
            if (item != null) {
                item.notifyItemPressedStart();
            }
            return true;
        }
        return false;
    }

    private CommandItem getOpenOptionsItem() {
        CommandItem result = this.singleLeftCommandItem;
        return result;
    }

    private boolean isOpenOptionsMenuKey(int keyCode, int gameAction) {
        boolean result = this.screen.isSoftKeyLeft(keyCode, gameAction);
        return result;
    }

    private boolean isCloseOptionsMenuKey(int keyCode, int gameAction) {
        boolean result = this.screen.isSoftKeyRight(keyCode, gameAction);
        return result;
    }

    private boolean isSelectOptionsMenuKey(int keyCode, int gameAction) {
        boolean result = this.screen.isSoftKeyLeft(keyCode, gameAction);
        return result;
    }

    public static void notifyKeyPressed() {
    }

    protected boolean handleKeyReleased(int keyCode, int gameAction) {
        if (this.isOpened) {
            CommandItem item;
            int index;
            if (this.isSelectOptionsMenuKey(keyCode, gameAction)) {
                this.isSoftKeyPressed = true;
                CommandItem commandItem = (CommandItem)this.commandsContainer.getFocusedItem();
                return commandItem.handleKeyReleased(0, 8);
            }
            if (this.isCloseOptionsMenuKey(keyCode, gameAction)) {
                this.isSoftKeyPressed = true;
                int selectedIndex = this.commandsContainer.getFocusedIndex();
                if (!this.commandsContainer.handleKeyReleased(0, 2) || selectedIndex != this.commandsContainer.getFocusedIndex()) {
                    this.setOpen(false);
                }
                return true;
            }
            boolean handled = this.commandsContainer.handleKeyReleased(keyCode, gameAction);
            if (handled) {
                this.isInitialized = false;
            } else if (keyCode >= 49 && keyCode <= 57 && (index = keyCode - 49) <= this.commandsContainer.size() && (item = (CommandItem)this.commandsContainer.get(index)).getAppearanceMode() != 0) {
                if (!item.isFocused) {
                    this.commandsContainer.focus(index);
                }
                handled = item.handleKeyReleased(0, 8);
                return handled;
            }
            return true;
        }
        if (keyCode == -5 && this.singleMiddleCommand != null && this.singleMiddleCommandItem.getAppearanceMode() != 0) {
            this.isSoftKeyPressed = true;
            this.singleMiddleCommandItem.notifyItemPressedEnd();
            this.screen.callCommandListener(this.singleMiddleCommand);
            return true;
        }
        if (this.singleLeftCommand != null && this.screen.isSoftKeyLeft(keyCode, gameAction) && this.singleLeftCommandItem.getAppearanceMode() != 0) {
            this.isSoftKeyPressed = true;
            this.singleLeftCommandItem.notifyItemPressedEnd();
            this.screen.callCommandListener(this.singleLeftCommand);
            return true;
        }
        if (this.singleRightCommand != null && this.screen.isSoftKeyRight(keyCode, gameAction) && this.singleRightCommandItem.getAppearanceMode() != 0) {
            this.isSoftKeyPressed = true;
            this.singleRightCommandItem.notifyItemPressedEnd();
            this.screen.callCommandListener(this.singleRightCommand);
            return true;
        }
        if (this.isOpenOptionsMenuKey(keyCode, gameAction)) {
            this.isSoftKeyPressed = true;
            CommandItem item = this.getOpenOptionsItem();
            if (item != null) {
                item.notifyItemPressedEnd();
            }
            if (this.commandsList.size() > 0) {
                this.setOpen(true);
                return true;
            }
        }
        return super.handleKeyReleased(keyCode, gameAction);
    }

    public void setStyle(Style style) {
        if (this.overlayBackground == null) {
            int color = 0;
            color = -1778384896;
            if ((color & 0xFF000000) != 0) {
                this.overlayBackground = new TranslucentSimpleBackground(color);
            }
        }
        super.setStyle(style);
    }

    public void animate(long currentTime, ClippingRegion repaintRegion) {
        super.animate(currentTime, repaintRegion);
        if (this.isOpened) {
            this.commandsContainer.animate(currentTime, repaintRegion);
        }
        if (this.singleLeftCommandItem != null) {
            this.singleLeftCommandItem.animate(currentTime, repaintRegion);
        }
        if (this.singleRightCommandItem != null) {
            this.singleRightCommandItem.animate(currentTime, repaintRegion);
        }
    }

    public void addSubCommand(Command childCommand, Command parentCommand) {
        if (this.menuItemStyle != null) {
            this.addSubCommand(childCommand, parentCommand, this.menuItemStyle);
        } else {
            this.addSubCommand(childCommand, parentCommand, StyleSheet.menuitemStyle);
        }
    }

    public void addSubCommand(Command childCommand, Command parentCommand, Style commandStyle) {
        CommandItem parentCommandItem = (CommandItem)this.allCommands.get(parentCommand);
        if (parentCommand == this.singleLeftCommand) {
            this.addCommand(parentCommandItem);
            this.singleLeftCommand = null;
        } else if (parentCommand == this.singleRightCommand) {
            this.addCommand(parentCommandItem);
            this.singleRightCommand = null;
            if (this.singleLeftCommand != null) {
                Command cmd = this.singleLeftCommand;
                this.singleLeftCommand = null;
                this.addCommand(cmd);
            }
        }
        if (parentCommandItem == null) {
            throw new IllegalStateException();
        }
        CommandItem child = new CommandItem(childCommand, parentCommandItem, commandStyle);
        this.allCommands.put(childCommand, child);
        parentCommandItem.addChild(child);
        if (this.isOpened) {
            this.isInitialized = false;
            this.repaint();
        }
    }

    private void addCommand(CommandItem item) {
        if (item == null) {
            Debug.debug("error", "de.enough.polish.ui.MenuBar", 1820, "MenuBar.addCommand(CommandItem): Unable to add null CommandItem");
            return;
        }
        Command cmd = item.command;
        int priority = cmd.getPriority();
        if (this.commandsList.size() == 0) {
            this.commandsList.add(cmd);
            this.commandsContainer.add(item);
        } else {
            Command[] myCommands = (Command[])this.commandsList.toArray(new Command[this.commandsList.size()]);
            boolean inserted = false;
            for (int i = 0; i < myCommands.length; ++i) {
                Command command = myCommands[i];
                if (cmd == command) {
                    return;
                }
                if (command.getPriority() <= priority) continue;
                this.commandsList.add(i, cmd);
                this.commandsContainer.add(i, item);
                inserted = true;
                break;
            }
            if (!inserted) {
                this.commandsList.add(cmd);
                this.commandsContainer.add(item);
            }
        }
    }

    public void removeAllCommands() {
        this.singleLeftCommand = null;
        this.singleRightCommand = null;
        this.singleMiddleCommand = null;
        this.commandsList.clear();
        this.allCommands.clear();
        this.commandsContainer.clear();
        this.singleLeftCommandItem.setText(null);
        this.singleLeftCommandItem.setImage((Image)null);
        this.singleRightCommandItem.setText(null);
        this.singleRightCommandItem.setImage((Image)null);
        this.singleMiddleCommandItem.setText(null);
        this.singleMiddleCommandItem.setImage((Image)null);
        this.setOpen(false);
        this.repaint();
    }

    public CommandItem getCommandItem(Command command) {
        if (command == this.singleLeftCommand) {
            return this.singleLeftCommandItem;
        }
        if (command == this.singleRightCommand) {
            return this.singleRightCommandItem;
        }
        if (command == this.singleMiddleCommand) {
            return this.singleMiddleCommandItem;
        }
        return (CommandItem)this.allCommands.get(command);
    }

    public Item getItemAt(int relX, int relY) {
        if (this.isOpened && relY < 0) {
            return this.commandsContainer.getItemAt(relX - this.commandsContainer.relativeX, relY - this.commandsContainer.relativeY);
        }
        if (relY >= 0) {
            Item item = this.singleLeftCommandItem.getItemAt(relX - this.singleLeftCommandItem.relativeX, relY - this.singleLeftCommandItem.relativeY);
            if (item != null) {
                return item;
            }
            item = this.singleRightCommandItem.getItemAt(relX - this.singleRightCommandItem.relativeX, relY - this.singleRightCommandItem.relativeY);
            if (item != null) {
                return item;
            }
        }
        return super.getItemAt(relX, relY);
    }

    public boolean isOrientationVertical() {
        return this.isOrientationVertical;
    }

    public void setOrientationVertical(boolean isVertical) {
    }

    public int getSpaceTop(int width, int height) {
        return 0;
    }

    public int getSpaceLeft(int width, int height) {
        return 0;
    }

    public int getSpaceRight(int width, int height) {
        return 0;
    }

    public int getSpaceBottom(int width, int height) {
        return this.getItemHeight(width, width);
    }

    public int size() {
        return this.allCommands.size();
    }

    public Style getMenuItemStyle() {
        return this.menuItemStyle;
    }

    public void setMenuItemStyle(Style menuItemStyle) {
        this.menuItemStyle = menuItemStyle;
        Enumeration enumerator = this.allCommands.elements();
        while (enumerator.hasMoreElements()) {
            CommandItem item = (CommandItem)enumerator.nextElement();
            item.setStyle(menuItemStyle);
            item.repaint();
        }
    }

    public Container getCommandsContainer() {
        return this.commandsContainer;
    }

    public boolean contains(Command command) {
        return this.allCommands != null && this.allCommands.get(command) != null;
    }

    public void informDefaultCommand(Command cmd) {
        if (cmd != this.singleMiddleCommand) {
            this.removeCommand(cmd);
            if (this.singleMiddleCommand != null) {
                this.addCommand(tmpMiddleCommand);
            }
            this.singleMiddleCommand = cmd;
            this.singleMiddleCommandItem.setText(cmd.getLabel());
        }
    }
}

