/*
 * Decompiled with CFR 0.152.
 */
package de.enough.polish.ui;

import de.enough.polish.ui.Item;
import de.enough.polish.ui.Style;
import de.enough.polish.util.DrawUtil;
import de.enough.polish.util.ImageUtil;
import javax.microedition.lcdui.Graphics;
import javax.microedition.lcdui.Image;

public class PictureBrowserItem
extends Item {
    private Image[] thumbnails;
    private int[][] thumbnailsRGBData;
    private int selectedThumbIndex = 0;
    private int thumbnailWidth;
    private int thumbnailHeight;
    private int selectedWidth;
    private int selectedHeight;
    private String[] urls;

    public PictureBrowserItem(String label, Image[] thumbnails, String[] urls, int scaleFactor) {
        this(label, thumbnails, urls, scaleFactor, null);
    }

    public PictureBrowserItem(String label, Image[] thumbnails, String[] urls, int scaleFactor, Style style) {
        super(label, 0, 3, style);
        this.thumbnails = thumbnails;
        this.urls = urls;
        Image thumbnail = thumbnails[0];
        this.thumbnailWidth = thumbnail.getWidth() * scaleFactor / 100;
        this.thumbnailHeight = thumbnail.getHeight() * scaleFactor / 100;
        this.selectedWidth = this.thumbnailWidth * 2 + this.paddingVertical;
        this.selectedHeight = this.thumbnailHeight * 2 + this.paddingVertical;
        int size = this.thumbnailWidth * this.thumbnailHeight;
        this.thumbnailsRGBData = new int[thumbnails.length][];
        for (int i = 0; i < thumbnails.length; ++i) {
            int w = thumbnails[i].getWidth();
            int h = thumbnails[i].getHeight();
            int[] rgbData = new int[w * h];
            this.thumbnails[i].getRGB(rgbData, 0, w, 0, 0, w, h);
            if (i == this.selectedThumbIndex) {
                this.thumbnailsRGBData[i] = new int[this.selectedHeight * this.selectedWidth];
                ImageUtil.scale(rgbData, this.selectedWidth, this.selectedHeight, w, h, this.thumbnailsRGBData[i]);
                continue;
            }
            this.thumbnailsRGBData[i] = new int[size];
            ImageUtil.scale(rgbData, this.thumbnailWidth, this.thumbnailHeight, w, h, this.thumbnailsRGBData[i]);
        }
    }

    public int getNumberOfThumbnails() {
        return this.thumbnailsRGBData.length;
    }

    public void setSelectedThumbIndex(int index) {
        int[] newSelectedRbgData = this.thumbnailsRGBData[index];
        if (index == this.selectedThumbIndex && newSelectedRbgData != null) {
            return;
        }
        Image thumbnail = this.thumbnails[index];
        int width = thumbnail.getWidth();
        int height = thumbnail.getHeight();
        int[] rgbData = new int[width * height];
        thumbnail.getRGB(rgbData, 0, width, 0, 0, width, height);
        newSelectedRbgData = new int[this.selectedHeight * this.selectedWidth];
        ImageUtil.scale(rgbData, this.selectedWidth, this.selectedHeight, width, height, newSelectedRbgData);
        if (this.thumbnailsRGBData[this.selectedThumbIndex] != null) {
            Image selectedThumb = this.thumbnails[this.selectedThumbIndex];
            width = selectedThumb.getWidth();
            height = selectedThumb.getHeight();
            rgbData = new int[width * height];
            selectedThumb.getRGB(rgbData, 0, width, 0, 0, width, height);
            this.thumbnailsRGBData[this.selectedThumbIndex] = new int[this.thumbnailWidth * this.thumbnailHeight];
            ImageUtil.scale(rgbData, this.thumbnailWidth, this.thumbnailHeight, width, height, this.thumbnailsRGBData[this.selectedThumbIndex]);
        }
        this.thumbnailsRGBData[index] = newSelectedRbgData;
        this.selectedThumbIndex = index;
        this.repaint();
    }

    protected void paintContent(int x, int y, int leftBorder, int rightBorder, Graphics g) {
        int index = this.selectedThumbIndex - Math.min(2, this.thumbnails.length - 1);
        if (index < 0) {
            index = this.thumbnails.length + index;
        }
        int number = Math.min(5, this.thumbnails.length);
        int originalY = y;
        for (int i = 0; i < number; ++i) {
            if (index == this.selectedThumbIndex) {
                y = originalY;
                DrawUtil.drawRgb(this.thumbnailsRGBData[index], x += this.thumbnailWidth + this.paddingHorizontal, y, this.selectedWidth, this.selectedHeight, false, g);
                x += this.selectedWidth + this.paddingHorizontal;
            } else {
                DrawUtil.drawRgb(this.thumbnailsRGBData[index], x, y, this.thumbnailWidth, this.thumbnailHeight, false, g);
                y += this.thumbnailHeight + this.paddingVertical;
            }
            if (++index != this.thumbnails.length) continue;
            index = 0;
        }
    }

    public void setStyle(Style style) {
        super.setStyle(style);
        int newSelectedHeight = this.thumbnailHeight * 2 + this.paddingVertical;
        int newSelectedWidth = this.thumbnailWidth * 2 + this.paddingVertical;
        if (newSelectedHeight != this.selectedHeight || newSelectedWidth != this.selectedWidth) {
            this.selectedWidth = newSelectedWidth;
            this.selectedHeight = newSelectedHeight;
            this.thumbnailsRGBData[this.selectedThumbIndex] = null;
            this.setSelectedThumbIndex(this.selectedThumbIndex);
        }
    }

    protected boolean handleKeyPressed(int keyCode, int gameAction) {
        if (this.thumbnails.length > 1) {
            if (gameAction == 2) {
                if (this.selectedThumbIndex == 0) {
                    this.setSelectedThumbIndex(this.thumbnails.length - 1);
                } else {
                    this.setSelectedThumbIndex(this.selectedThumbIndex - 1);
                }
                return true;
            }
            if (gameAction == 5) {
                if (this.selectedThumbIndex < this.thumbnails.length - 1) {
                    this.setSelectedThumbIndex(this.selectedThumbIndex + 1);
                } else {
                    this.setSelectedThumbIndex(0);
                }
                return true;
            }
        }
        return false;
    }

    public int getSelectedThumbIndex() {
        return this.selectedThumbIndex;
    }

    public String getUrl(int index) {
        if (this.urls == null) {
            return null;
        }
        return this.urls[index];
    }

    protected String createCssSelector() {
        return "picturebrowser";
    }

    protected void initContent(int firstLineWidth, int lineWidth) {
        this.contentWidth = this.thumbnailWidth * 2 + 2 * this.paddingHorizontal + this.selectedWidth;
        this.contentHeight = this.thumbnailHeight * 2 + this.paddingVertical;
    }
}

