/*
 * Decompiled with CFR 0.152.
 */
package de.enough.polish.ui;

import de.enough.polish.ui.MasterCanvas;
import de.enough.polish.ui.Screen;
import de.enough.polish.ui.Style;
import de.enough.polish.util.Arrays;
import de.enough.polish.util.Debug;
import de.enough.polish.util.TextUtil;
import java.io.IOException;
import javax.microedition.lcdui.Graphics;
import javax.microedition.lcdui.Image;
import javax.microedition.media.Manager;
import javax.microedition.media.MediaException;
import javax.microedition.media.Player;
import javax.microedition.media.control.VideoControl;

public class SnapshotScreen
extends Screen
implements Runnable {
    private Player player;
    private VideoControl videoControl;
    private boolean isHiding;
    private boolean takeSnapshot;
    private boolean wait;
    private String snapshotEncoding;
    private byte[] snapshotData;
    private MediaException error;

    public SnapshotScreen(String title) {
        this(title, null);
    }

    public SnapshotScreen(String title, Style style) {
        super(title, false, style);
    }

    public void hideNotify() {
        super.hideNotify();
        if (!this.takeSnapshot) {
            this.isHiding = true;
            Thread thread = new Thread(this);
            if (!this.wait) {
                thread.start();
            } else {
                try {
                    thread.wait();
                }
                catch (Exception e) {
                    Debug.debug("error", "de.enough.polish.ui.SnapshotScreen", 153, (Object)"Problem while Waiting in hideNotify() ", e);
                }
            }
        }
    }

    public void showNotify() {
        super.showNotify();
        if (!this.takeSnapshot) {
            this.isHiding = false;
            Thread thread = new Thread(this);
            if (!this.wait) {
                thread.start();
            } else {
                try {
                    thread.wait();
                }
                catch (Exception e) {
                    Debug.debug("error", "de.enough.polish.ui.SnapshotScreen", 178, (Object)"Problem while Waiting in showNotify() ", e);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     */
    public void run() {
        var1_1 = Thread.currentThread();
        synchronized (var1_1) {
            this.wait = true;
            if (!this.isHiding && this.player == null) {
                try {
                    contentTypes = Manager.getSupportedContentTypes((String)"capture");
                    if (contentTypes == null || contentTypes.length == 0) {
                        this.error = new MediaException("capture not supported");
                        return;
                    }
                    protocol = "capture://video";
                    for (i = 0; i < contentTypes.length; ++i) {
                        contentType = contentTypes[i];
                        if (!"image".equals(contentType)) continue;
                        protocol = "capture://image";
                    }
                    this.player = Manager.createPlayer((String)protocol);
                    this.player.realize();
                    this.videoControl = (VideoControl)this.player.getControl("VideoControl");
                    if (this.videoControl == null) ** GOTO lbl50
                    try {
                        this.videoControl.initDisplayMode(1, (Object)MasterCanvas.instance);
                        width = this.contentWidth;
                        height = this.contentHeight;
                        this.videoControl.setDisplayLocation(this.contentX, this.contentY);
                        this.videoControl.setDisplaySize(width, height);
                        this.videoControl.setVisible(true);
                        this.player.prefetch();
                        this.player.start();
                    }
                    catch (MediaException e) {
                        this.error = e;
                        Debug.debug("error", "de.enough.polish.ui.SnapshotScreen", 238, (Object)"Cannot start video player. The error is: ", e);
                        return;
                    }
                }
                catch (IOException e) {
                    Debug.debug("error", "de.enough.polish.ui.SnapshotScreen", 244, (Object)"Unable to establish player", e);
                    this.error = new MediaException(e.toString());
                }
                catch (MediaException e) {
                    Debug.debug("error", "de.enough.polish.ui.SnapshotScreen", 248, (Object)"Unable to establish player", e);
                    this.error = e;
                    return;
                }
            } else if (!this.isHiding && this.player.getState() != 400) {
                try {
                    this.player.start();
                }
                catch (MediaException e) {
                    Debug.debug("error", "de.enough.polish.ui.SnapshotScreen", 257, (Object)"Unable to start player", e);
                }
            }
lbl50:
            // 7 sources

            if (this.takeSnapshot) {
                if (this.videoControl == null) {
                    this.error = new MediaException("Unable to init player: " + (this.error != null ? this.error.toString() : "unknown"));
                } else {
                    try {
                        this.snapshotData = this.videoControl.getSnapshot(this.snapshotEncoding);
                        if (this.snapshotData == null) {
                            this.snapshotData = this.videoControl.getSnapshot(this.snapshotEncoding);
                            if (this.snapshotData == null) {
                                this.error = new MediaException("No Data");
                            }
                        }
                    }
                    catch (MediaException e) {
                        Debug.debug("error", "de.enough.polish.ui.SnapshotScreen", 281, (Object)"Unable to take snapshot ", e);
                        this.error = e;
                    }
                    catch (SecurityException e) {
                        Debug.debug("error", "de.enough.polish.ui.SnapshotScreen", 285, (Object)"Unable to take snapshot ", e);
                        this.error = new MediaException(e.toString());
                        this.discardPlayer();
                    }
                }
            }
            if (this.isHiding && this.player != null) {
                try {
                    try {
                        this.player.stop();
                    }
                    catch (MediaException e) {
                        Debug.debug("error", "de.enough.polish.ui.SnapshotScreen", 299, (Object)"Unable to stop player", e);
                    }
                }
                catch (Exception e) {
                    Debug.debug("error", "de.enough.polish.ui.SnapshotScreen", 303, (Object)"Unable to close player", e);
                }
            }
            this.wait = false;
            try {
                this.notifyAll();
            }
            catch (Exception e) {
                Debug.debug("error", "de.enough.polish.ui.SnapshotScreen", 318, "Problem in notifying the thrreads ");
            }
        }
    }

    public static String[] getSnapshotEncodings() {
        String supportedEncodingsStr = System.getProperty("video.snapshot.encodings");
        if (supportedEncodingsStr == null) {
            return new String[0];
        }
        Object[] encodings = TextUtil.split(supportedEncodingsStr, ' ');
        Arrays.sort(encodings);
        return encodings;
    }

    public Image getSnapshotImage() throws MediaException {
        return this.getSnapshotImage(null);
    }

    public Image getSnapshotImage(String encoding) throws MediaException {
        byte[] data = this.getSnapshot(encoding);
        return Image.createImage((byte[])data, (int)0, (int)data.length);
    }

    public byte[] getSnapshot() throws MediaException {
        return this.getSnapshot(null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public byte[] getSnapshot(String encoding) throws MediaException {
        if (this.error != null) {
            throw this.error;
        }
        try {
            this.snapshotEncoding = encoding;
            this.takeSnapshot = true;
            Thread thread = new Thread(this);
            if (!this.wait) {
                thread.start();
            } else {
                try {
                    thread.wait();
                }
                catch (Exception e) {
                    Debug.debug("error", "de.enough.polish.ui.SnapshotScreen", 402, (Object)"Problem while Waiting in hideNotify() ", e);
                }
            }
            while (this.snapshotData == null && this.error == null) {
                try {
                    Thread.sleep(40L);
                }
                catch (InterruptedException e) {}
            }
            if (this.error != null) {
                throw this.error;
            }
            byte[] data = this.snapshotData;
            this.snapshotData = null;
            byte[] byArray = data;
            return byArray;
        }
        finally {
            this.takeSnapshot = false;
        }
    }

    protected void paintScreen(Graphics g) {
        if (this.error != null) {
            g.drawString(this.error.toString(), this.getWidth() - 10, this.getHeight() / 2, 24);
        }
    }

    protected String createCssSelector() {
        return "snapshotscreen";
    }

    private void discardPlayer() {
        if (this.player != null) {
            this.player.close();
            this.player = null;
        }
    }
}

