/*
 * Decompiled with CFR 0.152.
 */
package de.enough.polish.ui;

import de.enough.polish.io.Externalizable;
import de.enough.polish.ui.ClippingRegion;
import de.enough.polish.ui.Item;
import de.enough.polish.ui.Style;
import de.enough.polish.util.DrawUtil;
import de.enough.polish.util.TextUtil;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import javax.microedition.lcdui.Font;
import javax.microedition.lcdui.Graphics;
import javax.microedition.lcdui.Image;

public abstract class TextEffect
implements Externalizable {
    protected transient Style style;

    public void setStyle(Style style) {
        this.style = style;
    }

    public boolean animate() {
        return false;
    }

    public void animate(Item parent, long currentTime, ClippingRegion repaintRegion) {
        if (this.animate()) {
            parent.addRelativeToContentRegion(repaintRegion, 0, 0, parent.contentWidth, parent.contentHeight);
        }
    }

    public void drawStrings(String[] textLines, int textColor, int x, int y, int leftBorder, int rightBorder, int lineHeight, int maxWidth, int layout, Graphics g) {
        boolean isLayoutRight = false;
        boolean isLayoutCenter = false;
        int centerX = 0;
        if ((layout & 3) == 3) {
            isLayoutCenter = true;
            centerX = leftBorder + (rightBorder - leftBorder) / 2;
        } else if ((layout & 2) == 2) {
            isLayoutRight = true;
        }
        for (int i = 0; i < textLines.length; ++i) {
            String line = textLines[i];
            int lineX = x;
            int lineY = y;
            int orientation = 0;
            if (isLayoutRight) {
                lineX = rightBorder;
                orientation = 24;
            } else if (isLayoutCenter) {
                lineX = centerX;
                orientation = 17;
            } else {
                orientation = 20;
            }
            this.drawString(line, textColor, lineX, lineY, orientation, g);
            x = leftBorder;
            y += lineHeight;
        }
    }

    public abstract void drawString(String var1, int var2, int var3, int var4, int var5, Graphics var6);

    public int getLeftX(int x, int orientation, int textWidth) {
        if ((orientation & 4) == 4) {
            return x;
        }
        if ((orientation & 8) == 8) {
            return x - textWidth;
        }
        return x - textWidth / 2;
    }

    public int getTopY(int y, int orientation, Font font) {
        return this.getTopY(y, orientation, font.getHeight(), font.getBaselinePosition());
    }

    public int getTopY(int y, int orientation, int height, int baseLine) {
        if ((orientation & 0x10) == 16) {
            return y;
        }
        if ((orientation & 0x20) == 32) {
            return y - height;
        }
        return y - (height - baseLine);
    }

    public static int[] getRgbData(String text, int textColor, Font font) {
        int transparentColor = DrawUtil.getComplementaryColor(textColor);
        if (transparentColor == textColor) {
            transparentColor = 0;
        }
        int width = font.stringWidth(text);
        int height = font.getHeight();
        return TextEffect.getRgbData(text, textColor, font, 0, 0, width, height, transparentColor);
    }

    public static int[] getRgbData(String text, int textColor, Font font, int x, int y, int width, int height) {
        int transparentColor = DrawUtil.getComplementaryColor(textColor);
        if (transparentColor == textColor) {
            transparentColor = 0;
        }
        return TextEffect.getRgbData(text, textColor, font, x, y, width, height, transparentColor);
    }

    public static int[] getRgbData(String text, int textColor, Font font, int x, int y, int width, int height, int transparentColor) {
        Image midp2ImageBuffer = Image.createImage((int)width, (int)height);
        Graphics bufferG = midp2ImageBuffer.getGraphics();
        bufferG.setColor(transparentColor);
        bufferG.fillRect(0, 0, width, height);
        bufferG.setFont(font);
        bufferG.setColor(textColor);
        bufferG.drawString(text, x, y, 20);
        int[] rgbData = new int[width * height];
        midp2ImageBuffer.getRGB(rgbData, 0, width, 0, 0, width, height);
        int[] clearColorArray = new int[1];
        midp2ImageBuffer.getRGB(clearColorArray, 0, 1, 0, 0, 1, 1);
        transparentColor = clearColorArray[0];
        for (int i = 0; i < rgbData.length; ++i) {
            if (rgbData[i] != transparentColor) continue;
            rgbData[i] = 0;
        }
        return rgbData;
    }

    public void showNotify() {
    }

    public void hideNotify() {
    }

    public void releaseResources() {
    }

    public int stringWidth(String str) {
        return this.getFont().stringWidth(str);
    }

    public int getFontHeight() {
        return this.getFont().getHeight();
    }

    protected Font getFont() {
        if (this.style != null && this.style.font != null) {
            return this.style.font;
        }
        return Font.getDefaultFont();
    }

    public String[] wrap(String text, Font font, int firstLineWidth, int lineWidth) {
        return TextUtil.wrap(text, font, firstLineWidth, lineWidth);
    }

    public void read(DataInputStream dataInputStream) throws IOException {
    }

    public void write(DataOutputStream dataOutputStream) throws IOException {
    }
}

