/*
 * Decompiled with CFR 0.152.
 */
package de.enough.polish.ui;

import de.enough.polish.ui.ClippingRegion;
import de.enough.polish.ui.Item;
import de.enough.polish.ui.ItemCommandListener;
import de.enough.polish.ui.MasterCanvas;
import de.enough.polish.ui.Screen;
import de.enough.polish.ui.StringItem;
import de.enough.polish.ui.Style;
import de.enough.polish.ui.StyleSheet;
import javax.microedition.lcdui.Command;
import javax.microedition.lcdui.CommandListener;
import javax.microedition.lcdui.Displayable;
import javax.microedition.lcdui.Font;
import javax.microedition.lcdui.Graphics;
import javax.microedition.lcdui.TextBox;

public class TextField
extends StringItem
implements CommandListener,
ItemCommandListener {
    public static final int ANY = 0;
    public static final int EMAILADDR = 1;
    public static final int NUMERIC = 2;
    public static final int PHONENUMBER = 3;
    public static final int URL = 4;
    public static final int DECIMAL = 5;
    public static final int PASSWORD = 65536;
    public static final int UNEDITABLE = 131072;
    public static final int SENSITIVE = 262144;
    public static final int NON_PREDICTIVE = 524288;
    public static final int INITIAL_CAPS_WORD = 0x100000;
    public static final int INITIAL_CAPS_SENTENCE = 0x200000;
    public static final int CONSTRAINT_MASK = 65535;
    private static final int CLEAR_PRIORITY = 8;
    public static final Command CLEAR_CMD = new Command("\u6e05\u9664", 3, 8);
    private static final int DELETE_PRIORITY = 1;
    public static final Command DELETE_CMD = new Command("\u5220\u9664", 3, 1);
    private static final String VALID_LOCAL_EMAIL_ADDRESS_CHARACTERS = ".-_@!#$%&'*+/=?^`{|}~";
    private static final String VALID_DOMAIN_CHARACTERS = "._-";
    private int maxSize;
    private int constraints;
    private char editingCaretChar = (char)124;
    protected char caretChar = (char)124;
    protected boolean showCaret;
    private long lastCaretSwitch;
    protected String title;
    private String passwordText;
    private boolean isPassword;
    private boolean enableDirectInput;
    private ItemCommandListener additionalItemCommandListener;
    protected int inputMode;
    protected char emailSeparatorChar = (char)59;
    private TextBox midpTextBox;
    long lastTimePressed = -1L;
    protected boolean flashCaret = true;
    protected boolean isUneditable;
    private boolean isShowInputInfo = true;
    private boolean suppressCommands = false;
    private boolean isKeyPressedHandled;

    public TextField(String label, String text, int maxSize, int constraints) {
        this(label, text, maxSize, constraints, null);
    }

    public TextField(String label, String text, int maxSize, int constraints, Style style) {
        super(label, null, 3, style);
        this.constraints = constraints;
        this.maxSize = maxSize;
        this.title = label != null ? label : "Input";
        if ((constraints & 0x10000) == 65536) {
            this.isPassword = true;
        }
        if ((constraints & 2) == 2 && (constraints & 5) != 5) {
            this.enableDirectInput = true;
        }
        this.setConstraints(constraints);
        this.setString(text);
    }

    private void createTextBox() {
        String currentText = this.isPassword ? this.passwordText : this.text;
        this.midpTextBox = new TextBox(this.title, currentText, this.maxSize, this.constraints);
        this.midpTextBox.addCommand(StyleSheet.OK_CMD);
        if (!this.isUneditable) {
            this.midpTextBox.addCommand(StyleSheet.CANCEL_CMD);
        }
        this.midpTextBox.setCommandListener((CommandListener)this);
    }

    public String getString() {
        if (this.isPassword) {
            if (this.passwordText == null) {
                return "";
            }
            return this.passwordText;
        }
        if (this.text == null) {
            return "";
        }
        return this.text;
    }

    public String getDotSeparatedDecimalString() {
        if ((this.getConstraints() & 5) != 5) {
            throw new IllegalStateException();
        }
        String value = this.getString();
        if (value == null) {
            return null;
        }
        return value.replace(',', '.');
    }

    public void setString(String text) {
        if (this.midpTextBox != null) {
            this.midpTextBox.setString(text);
        }
        if (this.isPassword) {
            this.passwordText = text;
            if (text != null) {
                int length = text.length();
                StringBuffer buffer = new StringBuffer(length);
                for (int i = 0; i < length; ++i) {
                    buffer.append('*');
                }
                text = buffer.toString();
            }
        }
        if (this.isFocused) {
            this.updateDeleteCommand(text);
        }
        this.setText(text);
    }

    protected void updateDeleteCommand(String newText) {
        if (!this.isUneditable) {
            if (newText == null || newText.length() == 0) {
                this.removeCommand(DELETE_CMD);
            } else if (this.text == null || this.text.length() == 0) {
                this.addCommand(DELETE_CMD);
            }
        }
    }

    public int getChars(char[] data) {
        if (this.text == null) {
            return 0;
        }
        String txt = this.text;
        if (this.isPassword) {
            txt = this.passwordText;
        }
        char[] textArray = txt.toCharArray();
        System.arraycopy(textArray, 0, data, 0, textArray.length);
        return textArray.length;
    }

    public void setChars(char[] data, int offset, int length) {
        char[] copy = new char[length];
        System.arraycopy(data, offset, copy, 0, length);
        this.setString(new String(copy));
    }

    public void insert(String src, int position) {
        String txt = this.text;
        if (txt == null) {
            txt = "";
        }
        if (this.isPassword) {
            txt = this.passwordText;
        }
        String start = txt.substring(0, position);
        String end = txt.substring(position);
        this.setString(start + src + end);
    }

    public void insert(char[] data, int offset, int length, int position) {
        char[] copy = new char[length];
        System.arraycopy(data, offset, copy, 0, length);
        this.insert(new String(copy), position);
    }

    public void delete(int offset, int length) {
        String txt = this.text;
        if (this.isPassword) {
            txt = this.passwordText;
        }
        String start = txt.substring(0, offset);
        String end = txt.substring(offset + length);
        this.setString(start + end);
    }

    public int getMaxSize() {
        return this.maxSize;
    }

    public int setMaxSize(int maxSize) {
        if (this.text != null && maxSize < this.text.length() || maxSize < 1) {
            throw new IllegalArgumentException();
        }
        if (this.midpTextBox != null) {
            this.maxSize = this.midpTextBox.setMaxSize(maxSize);
            return this.maxSize;
        }
        this.maxSize = maxSize;
        return maxSize;
    }

    public int size() {
        if (this.text == null) {
            return 0;
        }
        return this.text.length();
    }

    public int getCaretPosition() {
        if (this.midpTextBox != null) {
            return this.midpTextBox.getCaretPosition();
        }
        return 0;
    }

    public void setCaretPosition(int position) {
    }

    public void setConstraints(int constraints) {
        this.constraints = constraints;
        int fieldType = constraints & 0xFFFF;
        this.animateTextWrap = this.isUneditable = (constraints & 0x20000) == 131072;
        if (this.midpTextBox != null) {
            this.midpTextBox.setConstraints(constraints);
        }
        this.removeCommand(DELETE_CMD);
        this.removeCommand(CLEAR_CMD);
        if (!this.suppressCommands) {
            if (this.isFocused) {
                this.getScreen().removeItemCommands(this);
            }
            if (!this.isUneditable) {
                this.addCommand(DELETE_CMD);
            }
            if (!this.isUneditable) {
                this.addCommand(CLEAR_CMD);
            }
        }
        this.itemCommandListener = this;
        if (this.isFocused) {
            this.showCommands();
        }
    }

    public int getConstraints() {
        return this.constraints;
    }

    public void setInitialInputMode(String characterSubset) {
        if (this.midpTextBox == null) {
            this.createTextBox();
        }
        this.midpTextBox.setInitialInputMode(characterSubset);
    }

    public void paintContent(int x, int y, int leftBorder, int rightBorder, Graphics g) {
        super.paintContent(x, y, leftBorder, rightBorder, g);
        if (this.isUneditable || !this.isFocused) {
            return;
        }
        if (this.showCaret && this.isFocused) {
            g.setColor(this.textColor);
            x = this.isLayoutCenter ? leftBorder + (rightBorder - leftBorder >> 1) + (this.contentWidth >> 1) + 2 : (this.isLayoutRight ? rightBorder : (x += this.contentWidth + 2));
            g.drawLine(x, y, x, y + this.getFontHeight());
        }
    }

    protected void initContent(int firstLineWidth, int lineWidth) {
        this.screen = this.getScreen();
        super.initContent(firstLineWidth, lineWidth);
        if (this.font == null) {
            this.font = Font.getDefaultFont();
        }
        if (this.contentWidth < this.minimumWidth) {
            this.contentWidth = this.minimumWidth;
        }
        if (this.contentHeight < this.minimumHeight) {
            this.contentHeight = this.minimumHeight;
        } else if (this.contentHeight < this.getFontHeight()) {
            this.contentHeight = this.getFontHeight();
        }
    }

    protected String createCssSelector() {
        return "textfield";
    }

    public void setStyle(Style style) {
        super.setStyle(style);
        if (this.font == null) {
            this.font = Font.getDefaultFont();
        }
    }

    public void animate(long currentTime, ClippingRegion repaintRegion) {
        super.animate(currentTime, repaintRegion);
    }

    public boolean animate() {
        if (!this.isFocused) {
            return false;
        }
        long currentTime = System.currentTimeMillis();
        if (!this.flashCaret || this.isUneditable) {
            return false;
        }
        if (currentTime - this.lastCaretSwitch > 500L) {
            this.lastCaretSwitch = currentTime;
            this.showCaret = !this.showCaret;
            return true;
        }
        return false;
    }

    protected boolean handleKeyPressed(int keyCode, int gameAction) {
        String currentText;
        this.isKeyPressedHandled = false;
        if (gameAction == 1 && keyCode != 50 || gameAction == 6 && keyCode != 56 || gameAction == 2 && keyCode != 52 || gameAction == 5 && keyCode != 54 || gameAction == 8 && keyCode != 53 || this.screen.isSoftKey(keyCode, gameAction)) {
            return false;
        }
        String string = currentText = this.isPassword ? this.passwordText : this.text;
        if (this.enableDirectInput) {
            int currentLength;
            int n = currentLength = this.text == null ? 0 : this.text.length();
            if (keyCode >= 48 && keyCode <= 57) {
                if (currentLength >= this.maxSize) {
                    this.isKeyPressedHandled = true;
                    return true;
                }
                String newText = (currentText == null ? "" : currentText) + (keyCode - 48);
                this.setString(newText);
                this.notifyStateChanged();
                this.isKeyPressedHandled = true;
                return true;
            }
            if (currentLength > 0 && (keyCode == -8 || gameAction == 2)) {
                this.setString(currentText.substring(0, currentLength - 1));
                this.notifyStateChanged();
                this.isKeyPressedHandled = true;
                return true;
            }
            return false;
        }
        if (keyCode >= 32 || keyCode == -8 || this.getScreen().isGameActionFire(keyCode, gameAction)) {
            this.showTextBox();
            return true;
        }
        return false;
    }

    protected boolean handleKeyInsert(int keyCode, int gameAction) {
        return false;
    }

    protected boolean handleKeyClear(int keyCode, int gameAction) {
        return false;
    }

    protected boolean handleKeyMode(int keyCode, int gameAction) {
        return false;
    }

    protected boolean handleKeyNavigation(int keyCode, int gameAction) {
        return false;
    }

    protected boolean handlePointerReleased(int x, int y) {
        if (this.isInItemArea(x, y)) {
            this.notifyItemPressedEnd();
            this.showTextBox();
            return true;
        }
        return false;
    }

    private void showTextBox() {
        if (this.midpTextBox == null) {
            this.createTextBox();
        }
        if (StyleSheet.currentScreen != null) {
            this.screen = StyleSheet.currentScreen;
        } else if (this.screen == null) {
            this.screen = this.getScreen();
        }
        MasterCanvas.setCurrent(StyleSheet.display, (Displayable)this.midpTextBox);
    }

    public void commandAction(Command cmd, Displayable box) {
        if (cmd == StyleSheet.CANCEL_CMD) {
            this.midpTextBox.setString(this.text);
        } else if (!this.isUneditable) {
            this.setString(this.midpTextBox.getString());
            this.setCaretPosition(this.size());
            this.notifyStateChanged();
        }
        MasterCanvas.setCurrent(StyleSheet.display, (Displayable)this.screen);
    }

    public void setItemCommandListener(ItemCommandListener l) {
        this.additionalItemCommandListener = l;
    }

    public ItemCommandListener getItemCommandListener() {
        return this.additionalItemCommandListener;
    }

    public void commandAction(Command cmd, Item item) {
        if (cmd == DELETE_CMD) {
            if (this.text != null && this.text.length() > 0) {
                String myText = this.getString();
                this.setString(myText.substring(0, myText.length() - 1));
                this.notifyStateChanged();
                return;
            }
        } else if (cmd == CLEAR_CMD) {
            this.setString(null);
            this.notifyStateChanged();
        } else if (this.additionalItemCommandListener != null) {
            this.additionalItemCommandListener.commandAction(cmd, item);
        } else {
            CommandListener listener;
            Screen scr = this.getScreen();
            if (scr != null && (listener = scr.getCommandListener()) != null) {
                listener.commandAction(cmd, (Displayable)scr);
            }
        }
    }

    protected Style focus(Style focStyle, int direction) {
        Style unfocusedStyle = super.focus(focStyle, direction);
        this.updateDeleteCommand(this.text);
        return unfocusedStyle;
    }

    public void setInputMode(int inputMode) {
        this.inputMode = inputMode;
    }

    public int getInputMode() {
        return this.inputMode;
    }

    public void setShowInputInfo(boolean show) {
        this.isShowInputInfo = show;
    }

    protected void showNotify() {
        this.updateDeleteCommand(this.text);
        super.showNotify();
    }

    public boolean isSuppressCommands() {
        return this.suppressCommands;
    }

    public void setSuppressCommands(boolean suppressCommands) {
        this.suppressCommands = suppressCommands;
        this.setConstraints(this.constraints);
    }
}

