/*
 * Decompiled with CFR 0.152.
 */
package de.enough.polish.ui;

import de.enough.polish.ui.AnimationThread;
import de.enough.polish.ui.IconItem;
import de.enough.polish.ui.Style;
import javax.microedition.lcdui.Graphics;
import javax.microedition.lcdui.Image;

public class Ticker
extends IconItem {
    private int tickerXOffset;
    private int step = 2;
    private int tickerWidth;

    public Ticker(String str) {
        this(str, (Style)null);
    }

    public Ticker(String str, Style style) {
        super((String)null, (Image)null, style);
        this.setString(str);
        this.setAppearanceMode(0);
    }

    public String getString() {
        return this.text;
    }

    public void setString(String text) {
        if (text != null) {
            text = text.replace('\n', ' ');
        }
        super.setText(text);
    }

    protected void initContent(int firstLineWidth, int lineWidth) {
        super.initContent(Integer.MAX_VALUE, Integer.MAX_VALUE);
        this.tickerWidth = this.contentWidth;
        this.contentWidth = lineWidth;
        this.tickerXOffset = -lineWidth;
    }

    public void paintContent(int x, int y, int leftBorder, int rightBorder, Graphics g) {
        int clipX = g.getClipX();
        int clipY = g.getClipY();
        int clipHeight = g.getClipHeight();
        int clipWidth = g.getClipWidth();
        int width = rightBorder - leftBorder;
        g.clipRect(x, clipY, width, clipHeight);
        super.paintContent(x -= this.tickerXOffset, y, leftBorder, rightBorder, g);
        if (x < leftBorder && x + this.tickerWidth + this.paddingHorizontal < rightBorder) {
            x = this.tickerWidth > width ? (x += this.tickerWidth + this.paddingHorizontal) : rightBorder + (x - leftBorder);
            super.paintContent(x, y, leftBorder, rightBorder, g);
        }
        g.setClip(clipX, clipY, clipWidth, clipHeight);
    }

    protected String createCssSelector() {
        return "ticker";
    }

    public void setStyle(Style style) {
        this.font = style.font;
        this.textColor = style.getFontColor();
        super.setStyle(style);
    }

    public boolean animate() {
        if (this.tickerWidth == 0) {
            return false;
        }
        this.tickerXOffset = this.tickerXOffset < this.tickerWidth ? (this.tickerXOffset += this.step) : (this.tickerWidth > this.contentWidth ? (this.tickerXOffset -= this.tickerWidth + this.paddingHorizontal - this.step) : this.tickerXOffset - this.contentWidth + this.step);
        return true;
    }

    protected void hideNotify() {
        super.hideNotify();
        AnimationThread.removeAnimationItem(this);
    }

    protected void showNotify() {
        super.showNotify();
        AnimationThread.addAnimationItem(this);
    }
}

