/*
 * Decompiled with CFR 0.152.
 */
package de.enough.polish.ui.backgrounds;

import de.enough.polish.ui.Background;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import javax.microedition.lcdui.Graphics;

public class BorderedRoundRectOpeningBackground
extends Background {
    private boolean isAnimationRunning;
    private int currentHeight;
    private int color;
    private int startHeight;
    private int speed;
    private int maxHeight;
    private int arcWidth;
    private int arcHeight;
    private int borderColor;

    public BorderedRoundRectOpeningBackground(int color, int startHeight, int speed, int arcWidth, int arcHeight, int borderColor, int borderWidth) {
        this.color = color;
        this.startHeight = startHeight;
        this.speed = speed;
        this.arcHeight = arcHeight;
        this.arcWidth = arcWidth;
        this.borderColor = borderColor;
        this.borderWidth = borderWidth;
    }

    public void paint(int x, int y, int width, int height, Graphics g) {
        this.maxHeight = height;
        if (this.isAnimationRunning) {
            int difference = height - this.currentHeight;
            height = this.currentHeight;
            y += difference >> 1;
        }
        g.setColor(this.color);
        g.fillRoundRect(x, y, width, height, this.arcWidth, this.arcHeight);
        if (!this.isAnimationRunning && this.borderWidth > 0) {
            g.setColor(this.borderColor);
            g.drawRoundRect(x, y, --width, --height, this.arcWidth, this.arcHeight);
            if (this.borderWidth > 1) {
                for (int border = this.borderWidth - 1; border > 0; --border) {
                    g.drawRoundRect(x + border, y + border, width - (border << 1), height - (border << 1), this.arcWidth, this.arcHeight);
                }
            }
        }
    }

    public boolean animate() {
        if (this.isAnimationRunning) {
            int adjust = this.speed;
            if (adjust == -1 && (adjust = (this.maxHeight - this.currentHeight) / 3) < 2) {
                adjust = 2;
            }
            this.currentHeight += adjust;
            if (this.currentHeight >= this.maxHeight) {
                this.isAnimationRunning = false;
            }
            return true;
        }
        return false;
    }

    public void showNotify() {
        super.showNotify();
        this.currentHeight = this.startHeight;
        this.isAnimationRunning = true;
    }

    public BorderedRoundRectOpeningBackground() {
    }

    public void read(DataInputStream dataInputStream) throws IOException {
        super.read(dataInputStream);
        this.arcHeight = dataInputStream.readInt();
        this.arcWidth = dataInputStream.readInt();
        this.borderColor = dataInputStream.readInt();
        this.color = dataInputStream.readInt();
        this.currentHeight = dataInputStream.readInt();
        this.isAnimationRunning = dataInputStream.readBoolean();
        this.maxHeight = dataInputStream.readInt();
        this.speed = dataInputStream.readInt();
        this.startHeight = dataInputStream.readInt();
    }

    public void write(DataOutputStream dataOutputStream) throws IOException {
        super.write(dataOutputStream);
        dataOutputStream.writeInt(this.arcHeight);
        dataOutputStream.writeInt(this.arcWidth);
        dataOutputStream.writeInt(this.borderColor);
        dataOutputStream.writeInt(this.color);
        dataOutputStream.writeInt(this.currentHeight);
        dataOutputStream.writeBoolean(this.isAnimationRunning);
        dataOutputStream.writeInt(this.maxHeight);
        dataOutputStream.writeInt(this.speed);
        dataOutputStream.writeInt(this.startHeight);
    }
}

