/*
 * Decompiled with CFR 0.152.
 */
package de.enough.polish.ui.backgrounds;

import de.enough.polish.io.Serializer;
import de.enough.polish.ui.Background;
import de.enough.polish.ui.Color;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import javax.microedition.lcdui.Graphics;

public class BorderedSimpleBackground
extends Background {
    private int color;
    private Color colorObj;
    private int borderColor;
    private Color borderColorObj;
    private boolean isInitialized;

    public BorderedSimpleBackground(int color, int borderColor, int borderWidth) {
        this.color = color;
        this.borderColor = borderColor;
        this.borderWidth = borderWidth;
        this.isInitialized = true;
    }

    public BorderedSimpleBackground(Color color, Color borderColor, int borderWidth) {
        this.colorObj = color;
        this.borderColorObj = borderColor;
        this.borderWidth = borderWidth;
        this.isInitialized = false;
    }

    public void paint(int x, int y, int width, int height, Graphics g) {
        if (!this.isInitialized) {
            this.color = this.colorObj.getColor();
            this.borderColor = this.borderColorObj.getColor();
            this.isInitialized = true;
            this.colorObj = null;
            this.borderColorObj = null;
        }
        g.setColor(this.color);
        g.fillRect(x, y, width, height);
        g.setColor(this.borderColor);
        g.drawRect(x, y, --width, --height);
        if (this.borderWidth > 1) {
            for (int border = this.borderWidth - 1; border > 0; --border) {
                g.drawRect(x + border, y + border, width - (border << 1), height - (border << 1));
            }
        }
    }

    public BorderedSimpleBackground() {
    }

    public void read(DataInputStream dataInputStream) throws IOException {
        super.read(dataInputStream);
        this.borderColor = dataInputStream.readInt();
        this.borderColorObj = (Color)Serializer.deserialize(dataInputStream);
        this.color = dataInputStream.readInt();
        this.colorObj = (Color)Serializer.deserialize(dataInputStream);
        this.isInitialized = dataInputStream.readBoolean();
    }

    public void write(DataOutputStream dataOutputStream) throws IOException {
        super.write(dataOutputStream);
        dataOutputStream.writeInt(this.borderColor);
        Serializer.serialize(this.borderColorObj, dataOutputStream);
        dataOutputStream.writeInt(this.color);
        Serializer.serialize(this.colorObj, dataOutputStream);
        dataOutputStream.writeBoolean(this.isInitialized);
    }
}

