/*
 * Decompiled with CFR 0.152.
 */
package de.enough.polish.ui.backgrounds;

import de.enough.polish.io.Serializer;
import de.enough.polish.ui.Background;
import de.enough.polish.ui.ClippingRegion;
import de.enough.polish.ui.Item;
import de.enough.polish.ui.Screen;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import javax.microedition.lcdui.Graphics;

public class CombinedBackground
extends Background {
    private Background foreground;
    private Background background;

    public CombinedBackground(Background foreground, Background background) {
        this.foreground = foreground;
        this.background = background;
    }

    public void paint(int x, int y, int width, int height, Graphics g) {
        this.background.paint(x, y, width, height, g);
        this.foreground.paint(x, y, width, height, g);
    }

    public void animate(Screen screen, Item parent, long currentTime, ClippingRegion repaintRegion) {
        this.foreground.animate(screen, parent, currentTime, repaintRegion);
        this.background.animate(screen, parent, currentTime, repaintRegion);
    }

    public void showNotify() {
        this.foreground.showNotify();
        this.background.showNotify();
    }

    public void hideNotify() {
        this.foreground.hideNotify();
        this.background.hideNotify();
    }

    public void releaseResources() {
        this.foreground.releaseResources();
        this.background.releaseResources();
    }

    public CombinedBackground() {
    }

    public void read(DataInputStream dataInputStream) throws IOException {
        super.read(dataInputStream);
        this.background = (Background)Serializer.deserialize(dataInputStream);
        this.foreground = (Background)Serializer.deserialize(dataInputStream);
    }

    public void write(DataOutputStream dataOutputStream) throws IOException {
        super.write(dataOutputStream);
        Serializer.serialize(this.background, dataOutputStream);
        Serializer.serialize(this.foreground, dataOutputStream);
    }
}

